<?php

class PostGrid_Widget extends Exptheme_Core_Widget_Base{
    protected $name = 'post_grid';
    protected $title = 'Dailyfit Post Grid';
    protected $icon = 'eicon-posts-ticker';
    protected $categories = array( 'exptheme-core' );
    protected $params = '{"sections":[{"name":"tab_layout","label":"Layout","tab":"layout","controls":[{"name":"post_type","label":"Select Post Type","type":"select","multiple":true,"options":{"post":"Post","portfolio":"Portfolio","service":"Services","team":"Team","product":"Product"},"default":"post"},{"name":"layout_post","label":"Select Template of Post","type":"layoutcontrol","default":"post-1","options":{"post-1":{"label":"Layout 1","image":"https:\/\/kyukushin-self-defense-global-federation.com\/wp-content\/themes\/dailyfit\/elements\/widgets\/img-layout\/post_grid\/post-layout1.png"},"post-2":{"label":"Layout 2","image":"https:\/\/kyukushin-self-defense-global-federation.com\/wp-content\/themes\/dailyfit\/elements\/widgets\/img-layout\/post_grid\/post-layout2.png"},"post-3":{"label":"Layout 3","image":"https:\/\/kyukushin-self-defense-global-federation.com\/wp-content\/themes\/dailyfit\/elements\/widgets\/img-layout\/post_grid\/post-layout3.png"}},"prefix_class":"exp-post-layout-","condition":{"post_type":["post"]}},{"name":"layout_portfolio","label":"Select Template of Portfolio","type":"layoutcontrol","default":"post-1","options":{"portfolio-1":{"label":"Layout 1","image":"https:\/\/kyukushin-self-defense-global-federation.com\/wp-content\/themes\/dailyfit\/elements\/widgets\/img-layout\/post_grid\/portfolio-layout1.png"}},"prefix_class":"exp-post-layout-","condition":{"post_type":["portfolio"]}},{"name":"layout_service","label":"Select Template of Services","type":"layoutcontrol","default":"post-1","options":{"service-1":{"label":"Layout 1","image":"https:\/\/kyukushin-self-defense-global-federation.com\/wp-content\/themes\/dailyfit\/elements\/widgets\/img-layout\/post_grid\/service-layout1.jpg"},"service-2":{"label":"Layout 2","image":"https:\/\/kyukushin-self-defense-global-federation.com\/wp-content\/themes\/dailyfit\/elements\/widgets\/img-layout\/post_grid\/service-layout2.jpg"}},"prefix_class":"exp-post-layout-","condition":{"post_type":["service"]}},{"name":"layout_team","label":"Select Template of Team","type":"layoutcontrol","default":"post-1","options":{"team-1":{"label":"Layout 1","image":"https:\/\/kyukushin-self-defense-global-federation.com\/wp-content\/themes\/dailyfit\/elements\/widgets\/img-layout\/post_grid\/team-layout1.jpg"},"team-2":{"label":"Layout 2","image":"https:\/\/kyukushin-self-defense-global-federation.com\/wp-content\/themes\/dailyfit\/elements\/widgets\/img-layout\/post_grid\/team-layout2.jpg"}},"prefix_class":"exp-post-layout-","condition":{"post_type":["team"]}},{"name":"layout_product","label":"Select Template of Product","type":"layoutcontrol","default":"post-1","options":{"product-1":{"label":"Layout 1","image":"https:\/\/kyukushin-self-defense-global-federation.com\/wp-content\/themes\/dailyfit\/elements\/widgets\/img-layout\/post_grid\/product-layout1.jpg"}},"prefix_class":"exp-post-layout-","condition":{"post_type":["product"]}}]},{"name":"tab_source","label":"Source","tab":"settings","controls":[{"name":"select_post_by","label":"Select posts by","type":"select","multiple":true,"options":{"term_selected":"Terms selected","post_selected":"Posts selected "},"default":"term_selected"},{"name":"source_post","label":"Select Term of Post","type":"select2","multiple":true,"options":{"latest-news|category":"Latest News","our-blog|category":"Our Blog","our-blog-artical|category":"Our Blog &amp; Artical","%d8%a2%d8%ae%d8%b1-%d8%a7%d9%84%d8%a3%d8%ae%d8%a8%d8%a7%d8%b1|category":"\u0622\u062e\u0631 \u0627\u0644\u0623\u062e\u0628\u0627\u0631"},"condition":{"post_type":["post"],"select_post_by":"term_selected"}},{"name":"source_portfolio","label":"Select Term of Portfolio","type":"select2","multiple":true,"options":{"our-projects|portfolio-category":"Our Projects"},"condition":{"post_type":["portfolio"],"select_post_by":"term_selected"}},{"name":"source_service","label":"Select Term of Services","type":"select2","multiple":true,"options":{"our-classes|service-category":"Our Classes","rtl-services|service-category":"RTL Services","services-v1|service-category":"Services V1"},"condition":{"post_type":["service"],"select_post_by":"term_selected"}},{"name":"source_team","label":"Select Term of Team","type":"select2","multiple":true,"options":{"hide|team-category":"hide","our-team|team-category":"Our Team","%d9%81%d8%b1%d9%8a%d9%82%d9%86%d8%a7|team-category":"\u0641\u0631\u064a\u0642\u0646\u0627"},"condition":{"post_type":["team"],"select_post_by":"term_selected"}},{"name":"source_product","label":"Select Term of Product","type":"select2","multiple":true,"options":{"external|product_type":"external","simple|product_type":"simple","variable|product_type":"variable","featured|product_visibility":"featured","outofstock|product_visibility":"outofstock","accessories|product_cat":"Accessories","decor|product_cat":"Decor","hoodies|product_cat":"Hoodies","music|product_cat":"Music","tshirts|product_cat":"Tshirts"},"condition":{"post_type":["product"],"select_post_by":"term_selected"}},{"name":"source_post_post_ids","label":"Select posts","type":"select2","multiple":true,"options":{"3990":"\u0627\u062f\u0641\u0639 \u0645\u0633\u062a\u0648\u0649 \u0644\u064a\u0627\u0642\u062a\u0643 \u0627\u0644\u0628\u062f\u0646\u064a\u0629 \u0645\u0639 \u0645\u0631\u0627\u0641\u0642 \u0635\u0627\u0644\u0629 \u0627\u0644\u0623\u0644\u0639\u0627\u0628 \u0627\u0644\u0631\u064a\u0627\u0636\u064a\u0629 \u0644\u062f\u064a\u0646\u0627","3992":"\u0643\u064a\u0641 \u062a\u062d\u0627\u0641\u0638 \u0639\u0644\u0649 \u0635\u062d\u0629 \u062c\u0633\u0645\u0643 \u0641\u064a \u0623\u0643\u062b\u0631 \u0645\u0646 \u0627\u0644\u0645\u0647\u0631\u062c\u0627\u0646","3993":"\u0643\u064a\u0641 \u062a\u062d\u0627\u0641\u0638 \u0639\u0644\u0649 \u0635\u062d\u0629 \u062c\u0633\u0645\u0643 \u0641\u064a \u0623\u0643\u062b\u0631 \u0645\u0646 \u0627\u0644\u0645\u0647\u0631\u062c\u0627\u0646","75":"Push Your Fitness Further With Facilities","80":"How to keep your Body Healthy","82":"Give your Fitness a Boost with our Gym","143":"Push your Fitness Further with Our GYM","150":"How to keep your Body Health in Over Festival","155":"Give your Fitness a Boost with our GYM","463":"Modify any Program to Improve Weakness","465":"Give your Fitness a Boost with our GYM","472":"How to make your Body Health","474":"Push your Fitness Further with Our GYM","477":"Push your Fitness Further with Our GYM"},"condition":{"post_type":["post"],"select_post_by":"post_selected"}},{"name":"source_portfolio_post_ids","label":"Select posts","type":"select2","multiple":true,"options":{"3700":"Cardio Program","3701":"Cardio Program","3702":"Cardio Program","3703":"Cardio Program","3704":"Cardio Program","3705":"Cardio Program","3706":"Cardio Program","3707":"Cardio Program","3708":"Cardio Program","3709":"Cardio Program","3710":"Cardio Program","3711":"Cardio Program"},"condition":{"post_type":["portfolio"],"select_post_by":"post_selected"}},{"name":"source_service_post_ids","label":"Select posts","type":"select2","multiple":true,"options":{"3682":"Progression","3683":"Workout","3684":"Nutrition","3685":"Psycho Training","3686":"Self Defence","3687":"Fitness For Man","3688":"Strength Training","3689":"Cardio For Man","3690":"Advance GYM","3691":"Progression","3692":"Workout","3930":"\u062a\u064e\u063a\u0630\u0650\u064a\u064e\u0629","3931":"\u0627\u0643\u062a\u0634\u0641 - \u062d\u0644","3932":"\u0627\u0644\u062a\u0642\u062f\u0645"},"condition":{"post_type":["service"],"select_post_by":"post_selected"}},{"name":"source_team_post_ids","label":"Select posts","type":"select2","multiple":true,"options":{"3657":"Dr. Ellouzi Sabeur","3658":"Dr. Sobhi H. Berri","3659":"Madona Fron","3660":"Junifor Jonas","3661":"Smith Cross","3662":"Monica Jand","3974":"\u0645\u0648\u0646\u064a\u0643\u0627 \u062c\u0627\u0646\u062f","3981":"\u0633\u0645\u064a\u062b \u0643\u0631\u0648\u0633","3982":"\u062c\u0648\u0646\u064a\u0641\u0648\u0631 \u062c\u0648\u0646\u0627\u0633"},"condition":{"post_type":["team"],"select_post_by":"post_selected"}},{"name":"source_product_post_ids","label":"Select posts","type":"select2","multiple":true,"options":{"388":"Black Shoes","389":"Hoodie","391":"T-Shirt","3130":"Beanie","3995":"Belt","16":"Black Shoes","393":"Black Suit","395":"Polo","3996":"Cap","396":"Black Suit","404":"Black Suit","405":"Black Shoes","406":"Black Blazer"},"condition":{"post_type":["product"],"select_post_by":"post_selected"}},{"name":"orderby","label":"Order By","type":"select","default":"date","options":{"date":"Date","ID":"ID","author":"Author","title":"Title","rand":"Random"}},{"name":"order","label":"Sort Order","type":"select","default":"desc","options":{"desc":"Descending","asc":"Ascending"}},{"name":"limit","label":"Total items","type":"number","default":"6"}]},{"name":"tab_grid","label":"Grid","tab":"settings","controls":[{"name":"img_size","label":"Image Size","type":"text","description":"Enter image size (Example: \"thumbnail\", \"medium\", \"large\", \"full\" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height))."},{"name":"col_xs","label":"Columns XS Devices","type":"select","default":"1","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_sm","label":"Columns SM Devices","type":"select","default":"2","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_md","label":"Columns MD Devices","type":"select","default":"3","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_lg","label":"Columns LG Devices","type":"select","default":"4","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_xl","label":"Columns XL Devices","type":"select","default":"4","options":{"1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"}},{"name":"grid_masonry","label":"Grid Masonry","type":"repeater","controls":[{"name":"col_xs_m","label":"Columns XS Devices","type":"select","default":"1","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_sm_m","label":"Columns SM Devices","type":"select","default":"2","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_md_m","label":"Columns MD Devices","type":"select","default":"3","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_lg_m","label":"Columns LG Devices","type":"select","default":"4","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_xl_m","label":"Columns XL Devices","type":"select","default":"4","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"img_size_m","label":"Image Size","type":"text","description":"Enter image size (Example: \"thumbnail\", \"medium\", \"large\", \"full\" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height))."}]}]},{"name":"tab_display","label":"Display","tab":"settings","controls":[{"name":"date","label":"Show Date","type":"switcher","label_on":"On","label_off":"Off","return_value":"yes","default":"yes","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1","post-2","post-3"]}]}]}},{"name":"show_title","label":"Show Title","type":"switcher","default":"true","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"team"},{"name":"layout_team","operator":"in","value":["team-1","team-2"]}]},{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1","post-2","post-3"]}]},{"terms":[{"name":"post_type","operator":"==","value":"portfolio"},{"name":"layout_portfolio","operator":"in","value":["portfolio-1"]}]}]}},{"name":"show_comments","label":"Show Comments","type":"switcher","label_on":"On","label_off":"Off","return_value":"yes","default":"yes","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1","post-2"]}]}]}},{"name":"author","label":"Show Author","type":"switcher","label_on":"On","label_off":"Off","return_value":"yes","default":"yes","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1","post-2"]}]}]}},{"name":"show_excerpt","label":"Show Excerpt","type":"switcher","default":"true","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1","post-3"]}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]}]}},{"name":"num_words","label":"Number of Words","type":"number","default":25,"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1","post-3"]},{"name":"show_excerpt","operator":"in","value":["true"]}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]},{"name":"show_excerpt","operator":"in","value":["true"]}]}]}},{"name":"show_read_btn","label":"Show Read More Button","type":"switcher","label_on":"On","label_off":"Off","return_value":"yes","default":"yes","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-2","post-3"]}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-2"]}]}]}},{"name":"btn_title","label":"Button Title","type":"text","label_block":true,"placeholder":"Enter button title","default":"Read More","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-2","post-3"]},{"name":"show_read_btn","operator":"in","value":["yes"]}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-2"]}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-2"]},{"name":"show_read_btn","operator":"in","value":["yes"]}]}]}},{"name":"show_category","label":"Show Category","type":"switcher","default":"true","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]},{"terms":[{"name":"post_type","operator":"==","value":"product"},{"name":"layout_product","operator":"in","value":["product-1"]}]}]}},{"name":"show_price","label":"Show Price","type":"switcher","default":"true","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"product"},{"name":"layout_product","operator":"in","value":["product-1"]}]}]}},{"name":"show_social","label":"Show Sodial Media","type":"switcher","default":"true","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"team"},{"name":"layout_team","operator":"in","value":["team-1"]}]}]}},{"name":"show_designation","label":"Show Designation","type":"switcher","default":"true","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"team"},{"name":"layout_team","operator":"in","value":["team-1","team-2"]}]}]}},{"name":"pagination_type","label":"Pagination Type","type":"select","default":"false","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"portfolio"},{"name":"layout_portfolio","operator":"in","value":["portfolio-1"]}]},{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1","post-2"]}]},{"terms":[{"name":"post_type","operator":"==","value":"product"},{"name":"layout_product","operator":"in","value":["product-1"]}]},{"terms":[{"name":"post_type","operator":"==","value":"team"},{"name":"layout_team","operator":"in","value":["team-1","team-2"]}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]}]},"options":{"pagination":"Pagination","loadmore":"Loadmore","false":"Disable"}}]},{"name":"tab_style","label":"Style","tab":"settings","controls":[{"name":"img_hover_color","label":"Image Hover Background Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]}]},"selectors":{"{{WRAPPER}} .news-block-two .inner-box .image":"background-color: {{VALUE}} !important;"}},{"name":"category_color","label":"Category Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]}]},"selectors":{"{{WRAPPER}} .news-block-two .inner-box .lower-content .post-meta li a":"color: {{VALUE}} !important;","{{WRAPPER}} .news-block-two .inner-box .lower-content .post-meta li .icon":"color: {{VALUE}} !important;"}},{"name":"category_icon_color","label":"Category Icon Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]}]},"selectors":{"{{WRAPPER}} .news-block-two .inner-box .lower-content .post-meta li .icon":"color: {{VALUE}} !important;"}},{"name":"category_typography","label":"Category Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .news-block-two .inner-box .lower-content .post-meta li a","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]}]}},{"name":"date_title_bg_color","label":"Date Background Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1","post-2","post-3"]}]}]},"selectors":{"{{WRAPPER}} .news-block-one.update-block .inner-box .image-box .post-date":"background-color: {{VALUE}} !important;","{{WRAPPER}} .news-block .inner-box .image .post-date":"background-color: {{VALUE}} !important;"}},{"name":"date_title_color","label":"Date Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1","post-2","post-3"]}]}]},"selectors":{"{{WRAPPER}} .te-date":"color: {{VALUE}} !important;"}},{"name":"date_title_typography","label":"Date Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .te-date","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1","post-2","post-3"]}]}]}},{"name":"author_icon_box_bg_color","label":"Author icon box Background Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]}]},"selectors":{"{{WRAPPER}} .news-block-two .inner-box .lower-content .lower-box .author-info .icon":"background-color: {{VALUE}} !important;"}},{"name":"author_icon_box_border_color","label":"Author icon box Border Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]}]},"selectors":{"{{WRAPPER}} .news-block-two .inner-box .lower-content .lower-box .author-info .icon":"border: 1px solid {{VALUE}} !important;"}},{"name":"author_icon_hover_color","label":"Author icon box Hover Background  Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]}]},"selectors":{"{{WRAPPER}} .news-block-two .inner-box:hover .lower-content .lower-box .author-info .icon":"background-color: {{VALUE}} !important;"}},{"name":"author_icon_hover_border_color","label":"Author icon box Hover Border  Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]}]},"selectors":{"{{WRAPPER}} .news-block-two .inner-box:hover .lower-content .lower-box .author-info .icon":"border: 1px solid {{VALUE}} !important;"}},{"name":"author_icon_color","label":"Author icon Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]}]},"selectors":{"{{WRAPPER}} .news-block-two .inner-box .lower-content .lower-box .author-info .icon":"color: {{VALUE}} !important;"}},{"name":"author_icon_hover_color1","label":"Author icon Color On Hover","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]}]},"selectors":{"{{WRAPPER}} .news-block-two .inner-box:hover .lower-content .lower-box .author-info .icon":"color: {{VALUE}} !important;"}},{"name":"author_icon_hover_color","label":"Author icon hover Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]}]},"selectors":{"{{WRAPPER}} .news-block-two .inner-box:hover .lower-content .lower-box .author-info .icon":"color: {{VALUE}} !important;"}},{"name":"author_title_color","label":"Author Title Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1","post-2"]}]}]},"selectors":{"{{WRAPPER}} .te-author":"color: {{VALUE}} !important;"}},{"name":"author_title_typography","label":"Author Title Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .te-author","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1","post-2"]}]}]}},{"name":"comment_title_color","label":"Comments Title Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1","post-2"]}]}]},"selectors":{"{{WRAPPER}} .te-comments":"color: {{VALUE}} !important;"}},{"name":"comments_title_typography","label":"Comments Title Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .te-comments","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1","post-2"]}]}]}},{"name":"team_border_section_style","label":"Border Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"team"},{"name":"layout_team","operator":"in","value":["team-1"]}]}]},"selectors":{"{{WRAPPER}} .team-block-two .inner-box:before":"border-color: {{VALUE}} !important;"}},{"name":"team_border_hover_section_style","label":"Border Hover Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"team"},{"name":"layout_team","operator":"in","value":["team-1"]}]}]},"selectors":{"{{WRAPPER}} .team-block-two .inner-box:hover:before":"border-color: {{VALUE}} !important;"}},{"name":"title_bg_color","label":"Title Background Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"portfolio"},{"name":"layout_portfolio","operator":"in","value":["portfolio-1"]}]}]},"selectors":{"{{WRAPPER}} .gallery-block .inner-box .image .content":"background-color: {{VALUE}};"}},{"name":"title_color","label":"Title Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1","post-2","post-3"]}]},{"terms":[{"name":"post_type","operator":"==","value":"team"},{"name":"layout_team","operator":"in","value":["team-1","team-2"]}]},{"terms":[{"name":"post_type","operator":"==","value":"portfolio"},{"name":"layout_portfolio","operator":"in","value":["portfolio-1"]}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]},{"terms":[{"name":"post_type","operator":"==","value":"product"},{"name":"layout_product","operator":"in","value":["product-1"]}]}]},"selectors":{"{{WRAPPER}} .te-title":"color: {{VALUE}};","{{WRAPPER}} .gallery-block .inner-box .image .overlay-box .content h3 a":"color: {{VALUE}};","{{WRAPPER}} .gallery-block .inner-box .image .content h5 a":"color: {{VALUE}};"}},{"name":"title_hover_color","label":"Title Hover Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1"]}]},{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1","post-3"]}]}]},"selectors":{"{{WRAPPER}} .gallery-block .inner-box .image .overlay-box .content h3 a:hover":"color: {{VALUE}};","{{WRAPPER}} .services-block-two .inner-box:hover h3 a":"color: {{VALUE}};","{{WRAPPER}} .te-title:hover":"color: {{VALUE}};"}},{"name":"title_typography","label":"Title Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .te-title","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1","post-2","post-3"]}]},{"terms":[{"name":"post_type","operator":"==","value":"team"},{"name":"layout_team","operator":"in","value":["team-1","team-2"]}]},{"terms":[{"name":"post_type","operator":"==","value":"portfolio"},{"name":"layout_portfolio","operator":"in","value":["portfolio-1"]}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]},{"terms":[{"name":"post_type","operator":"==","value":"product"},{"name":"layout_product","operator":"in","value":["product-1"]}]}]}},{"name":"desc_color","label":"Description Color","type":"color","selectors":{"{{WRAPPER}} .te-text":"color: {{VALUE}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]},{"terms":[{"name":"post_type","operator":"==","value":"product"},{"name":"layout_product","operator":"in","value":["product-1"]}]},{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1","post-3"]}]}]}},{"name":"desc_hover_color","label":"Description Hover Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1"]}]}]},"selectors":{"{{WRAPPER}} .services-block-two .inner-box:hover .text":"color: {{VALUE}};"}},{"name":"desc_typography","label":"Description Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .te-text","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]},{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1","post-3"]}]}]}},{"name":"icon_color","label":"Icon Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1"]}]}]},"selectors":{"{{WRAPPER}} .te-icons i":"color: {{VALUE}};","{{WRAPPER}} .te-icons span":"color: {{VALUE}};","{{WRAPPER}} .te-icons svg":"fill: {{VALUE}};","{{WRAPPER}} .te-icons svg g":"fill: {{VALUE}};"}},{"name":"icon_hover_color","label":"Icon Hover Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1"]}]}]},"selectors":{"{{WRAPPER}} .services-block-two .inner-box:hover .icon-box":"color: {{VALUE}};"}},{"name":"icon_font_size","label":"icon Font Size","type":"slider","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1"]}]}]},"size_units":["px"],"range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .te-icons i":"font-size: {{SIZE}}{{UNIT}};","{{WRAPPER}} .te-icons span":"font-size: {{SIZE}}{{UNIT}};","{{WRAPPER}} .te-icons svg":"width: {{SIZE}}{{UNIT}};","{{WRAPPER}} .te-icons img":"width: {{SIZE}}{{UNIT}};"}},{"name":"post_btn_icon_color","label":"Button Icon Color","type":"color","selectors":{"{{WRAPPER}} .news-block-one.update-block .inner-box .lower-content .link-btn a:before":"background: {{VALUE}} !important;"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-2"]}]}]}},{"name":"post_btn_color1","label":"Button Color","type":"color","selectors":{"{{WRAPPER}} .te-post-btn":"color: {{VALUE}} !important;","{{WRAPPER}} .news-block-one.update-block .inner-box .lower-content .link-btn a":"color: {{VALUE}} !important;"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-2"]}]}]}},{"name":"portfolio_border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .gallery-block .inner-box .image .content .content-inner:before":"background-color: {{VALUE}} !important;"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"portfolio"},{"name":"layout_portfolio","operator":"in","value":["portfolio-1"]}]}]}},{"name":"portfolio_button_bg_color","label":"Button Background Color","type":"color","selectors":{"{{WRAPPER}} .gallery-block .inner-box .image .content .icon":"background-color: {{VALUE}} !important;"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"portfolio"},{"name":"layout_portfolio","operator":"in","value":["portfolio-1"]}]}]}},{"name":"portfolio_buton_icon_color","label":"Button Icon Color","type":"color","selectors":{"{{WRAPPER}} .gallery-block .inner-box .image .content .icon":"color: {{VALUE}} !important;"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"portfolio"},{"name":"layout_portfolio","operator":"in","value":["portfolio-1"]}]}]}},{"name":"button_typography","label":"Button Typography","type":"typography","control_type":"group","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-3"]}]}]},"selector":"{{WRAPPER}} .btn-style-two"},{"name":"button_color","label":"Button Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-3"]}]}]},"selectors":{"{{WRAPPER}} .btn-style-two":"color: {{VALUE}};"}},{"name":"button_bg_color","label":"Button Background Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-3"]}]}]},"selectors":{"{{WRAPPER}} .btn-style-two":"background-color: {{VALUE}} !important;"}},{"name":"button_padding","label":"Padding","type":"dimensions","size_units":["px"],"selectors":{"{{WRAPPER}} .btn-style-two":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"control_type":"responsive","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-3"]}]}]}},{"name":"button_margin","label":"Margin","type":"dimensions","size_units":["px"],"selectors":{"{{WRAPPER}} .btn-style-two":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"control_type":"responsive","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-3"]}]}]}},{"name":"button_border_radius","label":"Border Radius","type":"dimensions","size_units":["px"],"selectors":{"{{WRAPPER}} .btn-style-two":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"control_type":"responsive","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-3"]}]}]}},{"name":"button_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-3"]}]}]},"selector":"{{WRAPPER}} .btn-style-two"},{"name":"button_border_color","label":"Border Color","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-3"]}]}]},"default":"","selectors":{"{{WRAPPER}} .btn-two-outer:before":"border-color: {{VALUE}} !important;","{{WRAPPER}} .btn-two-outer:after":"border-color: {{VALUE}} !important;"}},{"name":"button_bg_color_hover","label":"Button Background Color Hover","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-3"]}]}]},"selectors":{"{{WRAPPER}} .btn-style-two:before":"border-bottom: 55px solid {{VALUE}};","{{WRAPPER}} .btn-style-two:after":"border-bottom: 55px solid {{VALUE}};"}},{"name":"button_color_hover","label":"Button Color Hover","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-3"]}]}]},"selectors":{"{{WRAPPER}} .btn-style-two:hover":"color: {{VALUE}};"}},{"name":"button_border_color_hover","label":"Border Color Hover","type":"color","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-3"]}]}]},"default":"","selectors":{"{{WRAPPER}} .btn-two-outer:after":"border-color: {{VALUE}} !important;"},"condition":{"button_border_type!":""}},{"name":"designation_color","label":"Designation Color","type":"color","selectors":{"{{WRAPPER}} .te-designation":"color: {{VALUE}} !important;"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"team"},{"name":"layout_team","operator":"in","value":["team-1","team-2"]}]}]}},{"name":"designation_typography","label":"Designation Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .te-designation","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"team"},{"name":"layout_team","operator":"in","value":["team-1","team-2"]}]}]}}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'imagesloaded','isotope','dailyfit-post-grid' );
}