<?php
/**
 * Template part for displaying default header layout
 */

$logo_m = dailyfit()->get_theme_opt( 'logo_m', ['url' => get_template_directory_uri().'/assets/images/logo-2.png', 'id' => '' ] );
$p_menu = dailyfit()->get_page_opt('p_menu');
?>
<header id="exp-header-default">
    <div id="exp-header-main" class="exp-header-main">
        <div class="container">
            <div class="d-flex">
                <div class="exp-header-branding">
                    <?php
                        if ($logo_m['url']) {
                            printf(
                                '<a href="%1$s" title="%2$s" rel="home"><img src="%3$s" alt="%2$s"/></a>',
                                esc_url( home_url( '/' ) ),
                                esc_attr( get_bloginfo( 'name' ) ),
                                esc_url( $logo_m['url'] )
                            );
                        }
                    ?>
                </div>
                <div class="exp-header-menu">
                    <div class="exp-header-menu-scroll">
                        <div class="exp-menu-close exp-hide-xl exp-close"></div>
                        <div class="exp-logo-mobile exp-hide-xl">
                            <?php
                                if ($logo_m['url']) {
                                    printf(
                                        '<a href="%1$s" title="%2$s" rel="home"><img src="%3$s" alt="%2$s"/></a>',
                                        esc_url( home_url( '/' ) ),
                                        esc_attr( get_bloginfo( 'name' ) ),
                                        esc_url( $logo_m['url'] )
                                    );
                                }
                            ?>
                        </div>
                        <?php dailyfit_header_mobile_search_form(); ?>
                        <nav class="exp-header-nav">
                            <?php
                                if ( has_nav_menu( 'primary' ) )
                                {
                                    $attr_menu = array(
                                        'theme_location' => 'primary',
                                        'container'  => '',
                                        'menu_id'    => '',
                                        'menu_class' => 'exp-menu-primary clearfix',
                                        'link_before'     => '<span>',
                                        'link_after'      => '</span>',
                                        'walker'         => class_exists( 'EXP_Mega_Menu_Walker' ) ? new EXP_Mega_Menu_Walker : '',
                                    );
                                    if(isset($p_menu) && !empty($p_menu)) {
                                        $attr_menu['menu'] = $p_menu;
                                    }
                                    wp_nav_menu( array(
                                        'theme_location' => 'primary',
                                        'container'  => '',
                                        'menu_id'    => '',
                                        'menu_class' => 'exp-menu-primary clearfix',
                                        'link_before'     => '<span>',
                                        'link_after'      => '</span>',
                                        'walker'         => class_exists( 'EXP_Mega_Menu_Walker' ) ? new EXP_Mega_Menu_Walker : '',
                                    ) );
                                } else { 
                                    printf(
                                        '<ul class="exp-menu-primary exp-primary-menu-not-set"><li><a href="%1$s">%2$s</a></li></ul>',
                                        esc_url( admin_url( 'nav-menus.php' ) ),
                                        esc_html__( 'Create New Menu', 'dailyfit' )
                                    );
                                    ?>
                                <?php }
                            ?>
                        </nav>
                    </div>
                </div>
                <div class="exp-header-menu-backdrop"></div>
            </div>
        </div>
        <div id="exp-nav-mobile">
            <div class="exp-nav-mobile-button exp-anchor-divider exp-cursor--cta">
                <span class="exp-icon-line exp-icon-line1"></span>
                <span class="exp-icon-line exp-icon-line2"></span>
                <span class="exp-icon-line exp-icon-line3"></span>
            </div>
        </div>
    </div>
</header>
