<?php
/**
 * Template part for displaying posts in loop
 *
 * @package Expert Themes
 */
$post_video_link = dailyfit()->get_page_opt( 'post_video_link' );
$post_tag = dailyfit()->get_theme_opt( 'post_tag', true );
$post_navigation = dailyfit()->get_theme_opt( 'post_navigation', false );
$post_social_share = dailyfit()->get_theme_opt( 'post_social_share', false );
$post_slider = dailyfit()->get_page_opt( 'post_slider' );
$post_date = dailyfit()->get_theme_opt( 'post_date', true );
?>
<article id="exp-post-<?php the_ID(); ?>" <?php post_class('exp---post'); ?>>
    <?php if($post_slider) { ?>
        <div class="exp-post-gallery-slider exp-item--image">
            <div class="exp-custom-swiper">
                <div class="swiper-wrapper">
                    <?php 
                        wp_enqueue_script('swiper');
                        wp_enqueue_script( 'exp-slider', get_template_directory_uri() . '/assets/admin/js/slider.js', array( 'jquery' ), '1.0.0', true );
                        $g_images = explode( ',', $post_slider ); foreach ($g_images as $img_id) :
                        $g_img = exp_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => '870x315',
                        ));
                        $g_thumbnail = $g_img['thumbnail'];
                        ?>
                        <div class="swiper-slide">
                            <?php echo dailyfit_html($g_thumbnail); ?>
                        </div>
                    <?php endforeach; ?>
                </div>
                <div class="exp-swiper-arrow exp-swiper-arrow-next"><i class="fa fa-angle-right"></i></div>
                <div class="exp-swiper-arrow exp-swiper-arrow-prev"><i class="fa fa-angle-left"></i></div>
            </div>
        </div>
    <?php } else { ?>
        <?php if (has_post_thumbnail()) {
            echo '<div class="exp-item--image">'; ?>
                <?php the_post_thumbnail('dailyfit-medium'); ?>
                <?php if(!empty($post_video_link)) : ?>
                    <a class="btn-video" href="<?php echo esc_url($post_video_link); ?>"><i class="fa fa-play"></i></a>
                <?php endif; ?>
                
                <?php if($post_date) : ?>
                    <div class="post-item-date">
                        <span class="fa fa-calendar">
                            <?php echo get_the_date('F j, Y'); ?>
                        </span>
                    </div>
                <?php endif; ?>
                
            <?php echo '</div>';
        }
    } ?>
    <div class="exp-item--holder">
        <?php dailyfit()->blog->get_post_metas();  ?>
        <div class="exp-item--excerpt clearfix">
            <?php
                the_content();
                wp_link_pages( array(
                    'before'      => '<div class="page-links">',
                    'after'       => '</div>',
                    'link_before' => '<span>',
                    'link_after'  => '</span>',
                ) );
            ?>
        </div>

    </div>

    <?php if($post_tag || $post_social_share ) :  ?>
        <div class="exp--post-footer">
            <?php if($post_tag) { dailyfit()->blog->get_tagged_in(); } ?>
            <?php if($post_social_share) { dailyfit()->blog->get_socials_share(); } ?>
        </div>
    <?php endif; ?>

    <?php if($post_navigation) { dailyfit()->blog->get_post_nav(); } ?>
</article><!-- #post -->