<?php
/**
 * @package Expert Themes
 */
$archive_readmore_text = dailyfit()->get_theme_opt('archive_readmore_text', esc_html__('Read More', 'dailyfit'));
$archive_date = dailyfit()->get_theme_opt( 'archive_date', true );
$blog_layout = dailyfit()->get_page_opt('blog_layout', 'standard');
if(isset($_GET['blog_layout'])) {
    $blog_layout = $_GET['blog_layout'];
}
?>
<div id="post-<?php the_ID(); ?>" <?php post_class('blog-classic news-block-three exp---post exp-item--archive exp-item--'.$blog_layout); ?>>
    <div class="inner-box">
        <?php if (has_post_thumbnail()) { 
            echo '<div class="image">'; ?>
                <a href="<?php echo esc_url( get_permalink()); ?>"><?php the_post_thumbnail('770x420'); ?></a>
                
                <?php if( $archive_date ): ?>
                    <div class="post-item-date">
                        <span class="fa fa-calendar">
                            <?php echo get_the_date('F j, Y'); ?>
                        </span>
                    </div>
                <?php endif; ?>
                
            <?php echo '</div>';
        } ?>
        <div class="lower-content <?php if(!has_post_thumbnail()) echo 'blog_style_two'; else echo ''; ?>">
            <?php dailyfit()->blog->get_archive_meta(); 
    			if( get_the_title() ) :
    		?>
            <h3>
                <a href="<?php echo esc_url( get_permalink()); ?>" title="<?php the_title_attribute(); ?>">
                    <?php if(is_sticky()) { ?>
                        <i class="fa fa-check exp-mr-4"></i>
                    <?php } ?>
                    <?php the_title(); ?>
                </a>
            </h3>
            <?php  endif;  ?>
            <div class="text">
                <p>
    				<?php
                        dailyfit()->blog->get_excerpt();
                        wp_link_pages( array(
                            'before'      => '<div class="page-links">',
                            'after'       => '</div>',
                            'link_before' => '<span>',
                            'link_after'  => '</span>',
                        ) );
                    ?> 
                </p>      
            </div>
            
            <a class="read-more" href="<?php echo esc_url( get_permalink()); ?>"><?php echo dailyfit_html($archive_readmore_text); ?></a>
            
        </div>
    </div>
</div>