<?php
/**
 * @package Expert Themes
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('col-lg-4 col-md-6 col-sm-12'); ?>>
    <div class="exp-item--inner">
        <?php if (has_post_thumbnail()) {
            echo '<div class="item--featured">'; ?>
                <a href="<?php echo esc_url( get_permalink()); ?>"><?php the_post_thumbnail('dailyfit-portfolio'); ?></a>
            <?php echo '</div>';
        } ?>
        <div class="item--holder">
            <h3 class="item--title">
                <a href="<?php echo esc_url( get_permalink()); ?>" title="<?php the_title(); ?>">
                    <?php echo esc_attr(get_the_title($post->ID)); ?>
                </a>
            </h3>
            <div class="item--category"><?php the_terms( get_the_ID(), 'portfolio-category', '', ', ', '' ); ?></div>
        </div>
    </div>
</article>