<?php
/**
 * @package Expert Themes
 */
get_header();
?>

<div class="auto-container">
    <div class="row exp-has-sidebar exp-sidebar-right">
        
        <div id="exp-content-area" class="exp-content-area exp-content-event col-12 col-lg-8">
            <main id="exp-content-main">
                <?php while (have_posts()) : the_post(); ?>
                    <div class="content-side <?php echo esc_attr($class); ?>">
                        <div class="classes-detail">
                            <div class="inner-box">
        
                                 <?php if( has_post_thumbnail() ) : ?>
                                      <div class="pt-post-media image">
                                        <?php the_post_thumbnail('dailyfit_1170x510'); ?>
                                        <?php
                                            $archive_year  = get_the_time( 'Y' ); 
                                            $archive_month = get_the_time( 'm' ); 
                                            $archive_day   = get_the_time( 'd' ); 
                                        ?>
                                        <div class="pt-post-date">
                                          <a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>">
                                          <span><?php echo esc_html( get_the_date('d',get_the_ID())); ?></span><?php echo esc_html( get_the_date('M',get_the_ID()));?></a>
                                        </div>
                                      </div>
                                      
                                  <?php  endif;   ?>
                                <div class="lower-content">
                                
                                    <div class="pt-blog-contain">
                 
                                         <div class="pt-post-meta">
        
                                      <ul> 
                                       <li class="pt-post-author"><i class="fa fa-user"></i><?php the_author(); ?></li>
                                       <li class="pt-post-cat">
                                           <?php
                                          $i =0;
                                          $categories = get_the_category( get_the_ID() );
                                          foreach( $categories as $category ) {
                                            if($i==0)
                                            {
                                            ?>
                                           <a href="<?php echo esc_url( get_category_link( $category->term_id ) ); ?>"><i class="fa fa-tag"></i><?php echo esc_attr( $category->name ) ?></a>
                                            <?php   
                                            $i++;     
                                          }}         
                                          ?> 
                                        </li>
                                     <li class="pt-post-comment">
                                          <?php 
                                          if(get_comments_number(get_the_ID()) == 1)
                                          {
                                            $comment = 'Comment';
                                          }
                                          else
                                          {
                                            $comment = 'Comments';
                                          }
                                          ?>
                                            <a href="<?php the_permalink(); ?>"><i class="fa fa-comments"></i>
                                              <?php echo get_comments_number(get_the_ID()).' '.esc_html($comment); ?></a> 
                                        </li>
                                       
                                      </ul>
                                    </div>
                                         <?php
                                            if(!is_single())
                                            {
                                            ?>
                                         <?php
                                            if(!is_single())
                                            {
                                            ?>
                                         <h5 class="pt-blog-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
                                         <?php } ?>
                                         <?php } ?>
                                        
                                      </div>
                                    
                                	<?php the_content(); ?>
                                	
                                	<?php comments_template(); ?>
                            	</div>    
                            </div>
                        </div>
                    </div>
                <?php endwhile ?>
            </main>
        </div>
        
        <?php if ( is_active_sidebar( 'sidebar-event' ) ) :  ?>
            <div id="exp-sidebar-area" class="exp-sidebar-area exp-sidebar-event col-12 col-lg-4">
                <div class="exp-sidebar-sticky sidebar">
                    <?php get_sidebar('sidebar-event'); ?>
                </div>
            </div>
        <?php endif; ?>
        
    </div>
</div>
<?php get_footer();