<?php
/**
 * @package Expert Themes
 */
get_header();
$dailyfit_sidebar = dailyfit()->get_sidebar_args(['type' => 'blog', 'content_col'=> '8']);
$blog_layout = dailyfit()->get_page_opt('blog_layout', 'standard');
if(isset($_GET['blog_layout'])) {
    $blog_layout = $_GET['blog_layout'];
}
?>
<div class="blog-classic blog-main">
    <div class="auto-container">
        <div class="row <?php echo esc_attr($dailyfit_sidebar['wrap_class']) ?> exp-post-<?php echo esc_attr($blog_layout); ?>" >
            <div id="exp-content-area" class="<?php echo esc_attr($dailyfit_sidebar['content_class']) ?>">
                <main id="exp-content-main">
                    <div class="blog__items">
                        <?php if ( have_posts() ) {
                            while ( have_posts() ) {
                                the_post();
                                get_template_part( 'template-parts/content/archive/'.$blog_layout );
                            }
                            dailyfit()->page->get_pagination();
                        } else {
                            get_template_part( 'template-parts/content/content', 'none' );
                        } ?>
                    </div>
                </main>
            </div>
            <?php if ($dailyfit_sidebar['sidebar_class']) : ?>
                <div id="exp-sidebar-area" class="<?php echo esc_attr($dailyfit_sidebar['sidebar_class']) ?>">
                    <div class="exp-sidebar-sticky sidebar">
                        <?php get_sidebar(); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php get_footer();
