<?php
if (!class_exists('ReduxFramework')) {
    return;
}
if (class_exists('ReduxFrameworkPlugin')) {
    remove_action('admin_notices', array(ReduxFrameworkPlugin::instance(), 'admin_notices'));
}

$opt_name = dailyfit()->get_option_name();
$version = dailyfit()->get_version();

$args = array(
    // TYPICAL -> Change these values as you need/desire
    'opt_name'             => $opt_name,
    // This is where your data is stored in the database and also becomes your global variable name.
    'display_name'         => '', //$theme->get('Name'),
    // Name that appears at the top of your panel
    'display_version'      => $version,
    // Version that appears at the top of your panel
    'menu_type'            => 'submenu', //class_exists('Exptheme_Core') ? 'submenu' : '',
    //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu'       => true,
    // Show the sections below the admin menu item or not
    'menu_title'           => esc_html__('Theme Options', 'dailyfit'),
    'page_title'           => esc_html__('Theme Options', 'dailyfit'),
    // You will need to generate a Google API key to use this feature.
    // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
    'google_api_key'       => '',
    // Set it you want google fonts to update weekly. A google_api_key value is required.
    'google_update_weekly' => false,
    // Must be defined to add google fonts to the typography module
    'async_typography'     => false,
    // Use a asynchronous font on the front end or font string
    //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
    'admin_bar'            => false,
    // Show the panel pages on the admin bar
    'admin_bar_icon'       => 'dashicons-admin-generic',
    // Choose an icon for the admin bar menu
    'admin_bar_priority'   => 50,
    // Choose an priority for the admin bar menu
    'global_variable'      => '',
    // Set a different name for your global variable other than the opt_name
    'dev_mode'             => true,
    // Show the time the page took to load, etc
    'update_notice'        => true,
    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer'           => true,
    // Enable basic customizer support
    //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
    //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field
    'show_options_object' => false,
    // OPTIONAL -> Give you extra features
    'page_priority'        => 80,
    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent'          => 'expert', //class_exists('Vitors_Admin_Page') ? 'case' : '',
    // For a full list of options, visit: //codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
    'page_permissions'     => 'manage_options',
    // Permissions needed to access the options panel.
    'menu_icon'            => '',
    // Specify a custom URL to an icon
    'last_tab'             => '',
    // Force your panel to always open to a specific tab (by id)
    'page_icon'            => 'icon-themes',
    // Icon displayed in the admin panel next to your menu_title
    'page_slug'            => 'expert-theme-options',
    // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
    'save_defaults'        => true,
    // On load save the defaults to DB before user clicks save or not
    'default_show'         => false,
    // If true, shows the default value next to each field that is not the default value.
    'default_mark'         => '',
    // What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export'   => true,
    // Shows the Import/Export panel when not used as a field.

    // CAREFUL -> These options are for advanced use only
    'transient_time'       => 60 * MINUTE_IN_SECONDS,
    'output'               => true,
    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag'           => true,
    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
    // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

    // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
    'database'             => '',
    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'use_cdn'              => true,
    // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

    // HINTS
    'hints'                => array(
        'icon'          => 'el el-question-sign',
        'icon_position' => 'right',
        'icon_color'    => 'lightgray',
        'icon_size'     => 'normal',
        'tip_style'     => array(
            'color'   => 'red',
            'shadow'  => true,
            'rounded' => false,
            'style'   => '',
        ),
        'tip_position'  => array(
            'my' => 'top left',
            'at' => 'bottom right',
        ),
        'tip_effect'    => array(
            'show' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'mouseover',
            ),
            'hide' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'click mouseleave',
            ),
        ),
    ),
);

Redux::SetArgs($opt_name, $args);

/*--------------------------------------------------------------
# General
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('General', 'dailyfit'),
    'icon'   => 'el-icon-home',
    'fields' => array(
        array(
            'id' => 'info_01ec772344',
            'type' => 'info',
            'style' => 'custom',
            'color' => '#ff0000',
            'title' => __('Mouse Cursor', 'dailyfit') ,
        ),
        array(
            'id' => 'section_7b84de1145',
            'type' => 'section',
            'indent' => true
        ),
        array(
            'id'       => 'show_mouse_cursor',
            'type'     => 'button_set',
            'title'    => esc_html__('Enable Mouse Cursor', 'dailyfit'),
            'options'  => array(
                'show' => esc_html__('Show', 'dailyfit'),
                'hide' => esc_html__('Hide', 'dailyfit'),
            ),
            'default'  => 'show',
        ),
        
        array(
            'id' => 'mouse_cursor_style',
            'type' => 'button_set',
            'title' => __('Mouse Cursor Style', 'dailyfit') ,
            'required' => array(
                'show_mouse_cursor',
                '=',
                'show'
            ),
            //Must provide key => value pairs for options
            'options' => array(
                'one' => esc_html__('Style One','dailyfit'),
                'two' => esc_html__('Style Two', 'dailyfit'),
            ) ,
            'default' => esc_html__('one','dailyfit')
        ),
        
        array(
            'id' => 'mouse_cursor_color',
            'type' => 'color',
            'title'    => __('Cursor Color', 'dailyfit'),                        
            'desc' => esc_html__('Choose Color For  Mouse Cursor.', 'dailyfit') ,
            'mode' => 'background',           
            'transparent' => false,
            'required' => array(
                'mouse_cursor_style',
                '=',
                'two'
            ),
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Favicon', 'dailyfit'),
    'icon'       => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields'     => array(
        array(
            'id' => 'info_01ec7723',
            'type' => 'info',
            'style' => 'custom',
            'color' => '#ff0000',
            'title' => __('Favicon Options', 'dailyfit') ,
        ),
        array(
            'id' => 'section_7b84de11',
            'type' => 'section',
            'indent' => true
        ),
        array(
            'id'       => 'favicon',
            'type'     => 'media',
            'title'    => esc_html__('Favicon', 'dailyfit'),
            'default'  => '',
            'url'      => false
        ),
    )
));


Redux::setSection($opt_name, array(
    'title'      => esc_html__('Color Scheme', 'dailyfit'),
    'icon'       => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields'     => array(
        array(
            'id' => 'info_01ec7723',
            'type' => 'info',
            'style' => 'custom',
            'color' => '#ff0000',
            'title' => __('Color Scheme Options', 'dailyfit') ,
        ),
        array(
            'id' => 'section_7b84de11',
            'type' => 'section',
            'indent' => true
        ),
        array(
            'id'       => 'show_color_scheme',
            'type'     => 'button_set',
            'title'    => esc_html__('Enable Custom Color', 'dailyfit'),
            'options'  => array(
                'show' => esc_html__('Show', 'dailyfit'),
                'hide' => esc_html__('Hide', 'dailyfit'),
            ),
            'default'  => 'show',
        ),
        array(
            'id'       => 'main_color_scheme',
            'type'     => 'color',
            'title'    => esc_html__('Primary Color (Red) ', 'dailyfit'),
            'default'  => '#ff0000',
            'transparent' => false,
            'required' => array(
                'show_color_scheme',
                '=',
                'show'
            ),
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Preloader', 'dailyfit'),
    'icon'       => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields'     => array(
        array(
            'id' => 'info_01ec772',
            'type' => 'info',
            'style' => 'custom',
            'color' => '#ff0000',
            'title' => __('Pre Loader Options', 'dailyfit') ,
        ),
        array(
            'id' => 'section_7b84de1',
            'type' => 'section',
            'indent' => true
        ),
        
        
        array(
            'id' => 'loader_switch',
            'type' => 'button_set',
            'title' => __('Choose Style', 'dailyfit') ,
            //Must provide key => value pairs for options
            'options' => array(
                'none' => esc_html__('none','dailyfit'),
                'image' => esc_html__('Image','dailyfit'),
                'text' => esc_html__('text', 'dailyfit'),
                'prebuild' => esc_html__('Pre Build', 'dailyfit'),
            ) ,
            'default' => esc_html__('image','dailyfit')
            
        ) ,
        
        
        array(
            'id' => 'background_loader',
            'type' => 'media',
            'title'    => __('Upload Loader Image', 'dailyfit'),               
            
            'desc' => 'upload gif image here',
            'url' => false,
            'read-only' => false,
            'required' => array(
                'loader_switch',
                '=',
                'image'
            ) ,
        ) ,  
        
        array(
            'id' => 'loader_background_color1',
            'type' => 'color',   
            'title'    => __('Background Color', 'dailyfit'),                        
            'desc' => esc_html__('Choose Background Color For  Loader.', 'dailyfit') ,
            'mode' => 'background',           
            'transparent' => false,
            'required' => array(
                'loader_switch',
                '=',
                'image'
            ) ,
        ) , 
          
        array(
            'id' => 'loader_dimensions',
            'type' => 'dimensions',
            'units' => array(
                'em',
                'px',
                '%'
            ) , // You can specify a unit value. Possible: px, em, %
            'units_extended' => 'true', // Allow users to select any type of unit
            'title' => esc_html__('Loader (Width/Height) Option', 'dailyfit') ,            
            'required' => array(
                'loader_switch',
                '=',
                'image'
            ) ,
        
        ) ,
        array(
            'id'        => 'loader_text',
            'type'      => 'text',   
            'title'    => __('Enter Loader Text', 'dailyfit'),                      
            'default'   => esc_html__( 'Loading....','dailyfit' ),
            'desc' => esc_html__('Enter Text', 'dailyfit') ,
            'required' => array(
                'loader_switch',
                '=',
                'text'
            ) ,
        ),
        array(
            'id'       => 'loader_tag',
            'type'     => 'select',
            'title'    => __('Select Html Tag', 'dailyfit'),             
            'desc'     => __('Select Tag For Loader Text.', 'dailyfit'),
            // Must provide key => value pairs for select options
            'options'  => array(
                'h1' => esc_html__('h1', 'dailyfit'),
                'h2' => esc_html__('h2', 'dailyfit'),
                'h3' => esc_html__('h3', 'dailyfit'),
                'h4' => esc_html__('h4', 'dailyfit'),
                'h5' => esc_html__('h5', 'dailyfit'),
                'h6' => esc_html__('h6', 'dailyfit'),
                
            ),
            'required' => array(
                'loader_switch',
                '=',
                'text'
            ) ,
            'default' => esc_html__('h2', 'dailyfit'),
        ),
        
        array(
            'id' => 'loader_color',
            'type' => 'color', 
            'title'    => __('Choose Color Loader Text', 'dailyfit'),                                 
            'desc' => esc_html__('Choose Color For Loader Text .', 'dailyfit') ,
            
            'mode' => 'background',            
            'transparent' => false,
            'required' => array(
                'loader_switch',
                '=',
                'text'
            ) ,
        ),
        
        array(
            'id' => 'loader_background_color',
            'type' => 'color',   
            'title'    => __('Background Color', 'dailyfit'),                        
            'desc' => esc_html__('Choose Background Color For  Loader.', 'dailyfit') ,
            'mode' => 'background',           
            'transparent' => false,
            'required' => array(
                'loader_switch',
                '=',
                'text'
            ) ,
        ) ,
        
        
        array(
            'id'       => 'loading_type',
            'type'     => 'select',
            'title'    => __('Loading Type', 'dailyfit'),             
            'desc'     => __('Select Loading Type.', 'dailyfit'),
            // Must provide key => value pairs for select options
            'options'  => array(
                's1' => esc_html__('Style 1', 'dailyfit'),
                's2' => esc_html__('Style 2', 'dailyfit'),
                's3' => esc_html__('Style 3', 'dailyfit'),
                's4' => esc_html__('Style 4', 'dailyfit'),
                's5' => esc_html__('Style 5', 'dailyfit'),
                's6' => esc_html__('Style 6', 'dailyfit'),
                's7' => esc_html__('Style 7', 'dailyfit'),
                's8' => esc_html__('Style 8', 'dailyfit'),
                's9' => esc_html__('Style 9', 'dailyfit'),
                's10' => esc_html__('Style 10', 'dailyfit'),
                's11' => esc_html__('Style 11', 'dailyfit'),
                's12' => esc_html__('Style 12', 'dailyfit'),
            ),
            'required' => array(
                'loader_switch',
                '=',
                'prebuild'
            ),
            'default' => esc_html__('s1', 'dailyfit'),
        ),
        
    ),
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Cookie Policy', 'dailyfit'),
    'icon'       => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'cookie_policy',
            'type'     => 'button_set',
            'title'    => esc_html__('Cookie Policy', 'dailyfit'),
            'options'  => array(
                'show' => esc_html__('Show', 'dailyfit'),
                'hide' => esc_html__('Hide', 'dailyfit'),
            ),
            'default'  => 'hide',
        ),
        array(
            'id'      => 'cookie_policy_description',
            'type'    => 'text',
            'title'   => esc_html__('Description', 'dailyfit'),
            'default' => '',
            'required' => array( 0 => 'cookie_policy', 1 => 'equals', 2 => 'show' ),
        ),
        array(
            'id'          => 'cookie_policy_description_typo',
            'type'        => 'typography',
            'title'       => esc_html__('Description Font', 'dailyfit'),
            'google'      => true,
            'font-backup' => false,
            'all_styles'  => true,
            'line-height'  => true,
            'font-size'  => true,
            'text-align'  => false,
            'color'  => false,
            'output'      => array('.exp-cookie-policy .exp-item--description'),
            'units'       => 'px',
            'required' => array( 0 => 'cookie_policy', 1 => 'equals', 2 => 'show' ),
        ),
        array(
            'id'      => 'cookie_policy_btntext',
            'type'    => 'text',
            'title'   => esc_html__('Button Text', 'dailyfit'),
            'default' => '',
            'required' => array( 0 => 'cookie_policy', 1 => 'equals', 2 => 'show' ),
        ),
        array(
            'id'    => 'cookie_policy_link',
            'type'  => 'select',
            'title' => esc_html__( 'Button Link', 'dailyfit' ), 
            'data'  => 'page',
            'args'  => array(
                'post_type'      => 'page',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                'order'          => 'ASC',
            ),
            'required' => array( 0 => 'cookie_policy', 1 => 'equals', 2 => 'show' ),
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Subscribe', 'dailyfit'),
    'icon'       => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'subscribe',
            'type'     => 'button_set',
            'title'    => esc_html__('Subscribe', 'dailyfit'),
            'options'  => array(
                'show' => esc_html__('Show', 'dailyfit'),
                'hide' => esc_html__('Hide', 'dailyfit'),
            ),
            'default'  => 'hide',
        ),
        array(
            'id'      => 'subscribe_layout',
            'type'    => 'select',
            'title'   => esc_html__('Layout', 'dailyfit'),
            'desc'    => sprintf(esc_html__('Please create your layout before choosing. %sClick Here%s','dailyfit'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=exp-template' ) ) . '">','</a>'),
            'options' => dailyfit_get_templates_option('popup'),
            'required' => array( 0 => 'subscribe', 1 => 'equals', 2 => 'show' ),
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Go To Top Setting', 'dailyfit'),
    'icon'       => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'info_01ec77234',
            'type' => 'info',
            'style' => 'custom',
            'color' => '#ff0000',
            'title' => __('Enable Go To Top', 'dailyfit') ,
        ),
        array(
            'id' => 'section_7b84de114',
            'type' => 'section',
            'indent' => true
        ),
        array(
            'id'       => 'back_to_top',
            'type'     => 'button_set',
            'options'  => array(
                'yes' => 'Yes',
                'no' => 'No'
            ),
            'default'  => 'yes'
        ),

         array(
            'id' => 'back_top_background_color',
            'type' => 'color',   
            'title'    => __('Background Color', 'dailyfit'),                        
            'desc' => esc_html__('Choose Background Color For Back To Top.', 'dailyfit') ,
            
            'mode' => 'background',            
            'transparent' => false,
            'required' => array(
                'back_to_top',
                '=',
                'yes'
            ) ,
           
        ) ,

        array(
            'id' => 'back_top_background_color_hover',
            'type' => 'color',   
            'title'    => __('Background Hover Color', 'dailyfit'),                        
            'desc' => esc_html__('Choose Background Hover Color For Back To Top.', 'dailyfit') ,            
            'mode' => 'background',            
            'transparent' => false,
            'required' => array(
                'back_to_top',
                '=',
                'yes'
            ) ,
           
        ) ,
        
        array(
            'id'       => 'back_top_icon',
            'type'     => 'exp_iconpicker',
            'title'    => esc_html__('Back to Top Icon', 'dailyfit'),
            'required' => array(
                'back_to_top',
                '=',
                'yes'
            ) ,
            'default' => esc_html__('icon fa fa-long-arrow-up', 'dailyfit'),
            'force_output' => true
        ),

        array(
            'id' => 'back_top_icon_size',
            'type' => 'slider',
            'title' => esc_html__('Icon Size', 'dailyfit') ,
            'desc'  => esc_html__('Only Enter Numbers Without PX.', 'dailyfit'),
            "default" => 13,
            "min" => 1,
            "step" => 1,
            "max" => 100,
            'display_value' => 'text',
            'required' => array(
                'back_to_top',
                '=',
                'yes'
            ) ,

        ) ,
        
        array(
            'id' => 'back_top_border_radius',
            'type' => 'slider',
            'title' => esc_html__('Border Radius', 'dailyfit') ,
            'desc'  => esc_html__('Only Border Radius Without PX.', 'dailyfit'),
            "default" => 40,
            "min" => 1,
            "step" => 1,
            "max" => 100,
            'display_value' => 'text',
            'required' => array(
                'back_to_top',
                '=',
                'yes'
            ) ,

        ) ,

        array(
            'id' => 'back_top_icon_color',
            'type' => 'color',   
            'title'    => __('Icon Color', 'dailyfit'),                        
            'desc' => esc_html__('Choose Icon Color For Back To Top.', 'dailyfit') ,            
            'mode' => 'background',            
            'transparent' => false,
            'required' => array(
                'back_to_top',
                '=',
                'yes'
            ) ,
        ) ,

        array(
            'id' => 'back_top_icon_hover_color',
            'type' => 'color',   
            'title'    => __('Icon Hover Color', 'dailyfit'),                        
            'desc' => esc_html__('Choose Icon Hover Color For Back To Top.', 'dailyfit') ,            
            'mode' => 'background',            
            'transparent' => false,
            'required' => array(
                'back_to_top',
                '=',
                'yes'
            ) ,
        ) ,
        array(
            'id' => 'progress_bar_color',
            'type' => 'color',   
            'title'    => __('Progress Bar Color', 'dailyfit'),                        
            'desc' => esc_html__('Choose Progress Bar Color.', 'dailyfit') ,
            'mode' => 'background',           
            'transparent' => false,
        ),
    )
));


/*--------------------------------------------------------------
# Header
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Header Settings', 'dailyfit'),
    'id'         => 'header_settings',
    'desc'       => '',
    'icon'       => 'eicon-header',
    'fields'     => array_merge(
        dailyfit_header_opts(),
        array(
            array(
                'id'       => 'sticky_scroll',
                'type'     => 'button_set',
                'title'    => esc_html__('Sticky Scroll', 'dailyfit'),
                'options'  => array(
                    'exp-sticky-stt' => esc_html__('Scroll To Top', 'dailyfit'),
                    'exp-sticky-stb'  => esc_html__('Scroll To Bottom', 'dailyfit'),
                ),
                'default'  => 'exp-sticky-stb',
            ),
        )
    ),
));

/*--------------------------------------------------------------
# Page Title area
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Page Title', 'dailyfit'),
    'icon'   => 'el-icon-map-marker',
    'fields' => array_merge(
        dailyfit_page_title_opts() 
    )
));



/*--------------------------------------------------------------
# Footer
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Footer Settings', 'dailyfit'),
    'icon'   => 'eicon-footer',
    'fields' => array_merge(
        dailyfit_footer_opts(),
        array(
            array(
                'id'       => 'footer_fixed',
                'type'     => 'button_set',
                'title'    => esc_html__('Footer Fixed', 'dailyfit'),
                'options'  => array(
                    'on' => esc_html__('On', 'dailyfit'),
                    'off' => esc_html__('Off', 'dailyfit'),
                ),
                'default'  => 'off',
            ),
        ),
    )
));


/*--------------------------------------------------------------
# WordPress default content
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title' => esc_html__('Blog Archive', 'dailyfit'),
    'icon'  => 'el-icon-pencil',
    'fields'     => array_merge(
        dailyfit_sidebar_pos_opts([ 'prefix' => 'blog_']),
        array(
            array(
                'id'       => 'archive_date',
                'title'    => esc_html__('Date', 'dailyfit'),
                'subtitle' => esc_html__('Display the Date for each blog post.', 'dailyfit'),
                'type'     => 'switch',
                'default'  => true,
            ),
            array(
                'id'       => 'archive_author',
                'title'    => esc_html__('Author', 'dailyfit'),
                'subtitle' => esc_html__('Display the Author for each blog post.', 'dailyfit'),
                'type'     => 'switch',
                'default'  => true,
            ),
            array(
                'id'       => 'archive_comments',
                'title'    => esc_html__('Comments', 'dailyfit'),
                'subtitle' => esc_html__('Display the Comments for each blog post.', 'dailyfit'),
                'type'     => 'switch',
                'default'  => true,
            ),
            array(
                'id'       => 'archive_category',
                'title'    => esc_html__('Category', 'dailyfit'),
                'subtitle' => esc_html__('Display the Category for each blog post.', 'dailyfit'),
                'type'     => 'switch',
                'default'  => true,
            ),
            array(
                'id'      => 'archive_excerpt_length',
                'type'    => 'text',
                'title'   => esc_html__('Excerpt Length', 'dailyfit'),
                'default' => '',
                'subtitle' => esc_html__('Default: 50', 'dailyfit'),
            ),
            array(
                'id'      => 'archive_readmore_text',
                'type'    => 'text',
                'title'   => esc_html__('Read More Text', 'dailyfit'),
                'default' => '',
                'subtitle' => esc_html__('Default: Read more', 'dailyfit'),
            )
        )
    )
));

/*--------------------------------------------------------------
# Single Page Settings
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Single Post', 'dailyfit'),
    'icon'       => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields'     => array_merge(
        dailyfit_sidebar_pos_opts([ 'prefix' => 'post_']),
        array(
            array(
                'id'       => 'post_date',
                'title'    => esc_html__('Date', 'dailyfit'),
                'subtitle' => esc_html__('Display the Date for blog post.', 'dailyfit'),
                'type'     => 'switch',
                'default'  => true
            ),
            array(
                'id'       => 'post_author',
                'title'    => esc_html__('Author', 'dailyfit'),
                'subtitle' => esc_html__('Display the Author for blog post.', 'dailyfit'),
                'type'     => 'switch',
                'default'  => true
            ),
            array(
                'id'       => 'post_single_category',
                'title'    => esc_html__('Categories', 'dailyfit'),
                'subtitle' => esc_html__('Display the Category for blog post.', 'dailyfit'),
                'type'     => 'switch',
                'default'  => true
            ),
             array(
                'id'       => 'post_single_comments',
                'title'    => esc_html__('Comments', 'dailyfit'),
                'subtitle' => esc_html__('Display the Comments for blog post.', 'dailyfit'),
                'type'     => 'switch',
                'default'  => true
            ),
            array(
                'id'       => 'post_tag',
                'title'    => esc_html__('Tags', 'dailyfit'),
                'subtitle' => esc_html__('Display the Tag for blog post.', 'dailyfit'),
                'type'     => 'switch',
                'default'  => true
            ),
            array(
                'id'       => 'post_navigation',
                'title'    => esc_html__('Navigation', 'dailyfit'),
                'subtitle' => esc_html__('Display the Navigation for blog post.', 'dailyfit'),
                'type'     => 'switch',
                'default'  => false,
            ),
            array(
                'title' => esc_html__('Social', 'dailyfit'),
                'type'  => 'section',
                'id' => 'social_section',
                'indent' => true,
            ),
            array(
                'id'       => 'post_social_share',
                'title'    => esc_html__('Social', 'dailyfit'),
                'subtitle' => esc_html__('Display the Social Share for blog post.', 'dailyfit'),
                'type'     => 'switch',
                'default'  => false,
            ),
            array(
                'id'       => 'social_facebook',
                'title'    => esc_html__('Facebook', 'dailyfit'),
                'type'     => 'switch',
                'default'  => true,
                'indent' => true,
                'required' => array( 0 => 'post_social_share', 1 => 'equals', 2 => '1' ),
            ),
            array(
                'id'       => 'social_twitter',
                'title'    => esc_html__('Twitter', 'dailyfit'),
                'type'     => 'switch',
                'default'  => true,
                'indent' => true,
                'required' => array( 0 => 'post_social_share', 1 => 'equals', 2 => '1' ),
            ),
            array(
                'id'       => 'social_pinterest',
                'title'    => esc_html__('Pinterest', 'dailyfit'),
                'type'     => 'switch',
                'default'  => true,
                'indent' => true,
                'required' => array( 0 => 'post_social_share', 1 => 'equals', 2 => '1' ),
            ),
            array(
                'id'       => 'social_linkedin',
                'title'    => esc_html__('LinkedIn', 'dailyfit'),
                'type'     => 'switch',
                'default'  => true,
                'indent' => true,
                'required' => array( 0 => 'post_social_share', 1 => 'equals', 2 => '1' ),
            ),
        )
    )
));

/*--------------------------------------------------------------
# 404 Page Settings
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'      => esc_html__('404 Page', 'dailyfit'),
    'icon'       => 'el el-circle-arrow-right',
    'subsection' => true,
    'fields'     => array_merge(
        array(
            
            array(
                'id'      => '404_page_title',
                'type'    => 'text',
                'title'   => esc_html__('404 Page Title', 'dailyfit'),
                'default' => esc_html__('404', 'dailyfit'),
            ),
            array(
                'id'      => '404_page_heading',
                'type'    => 'text',
                'title'   => esc_html__('404 page Heading', 'dailyfit'),
                'default' => esc_html__('Page not Found', 'dailyfit'),
            ),
            array(
                'id'      => '404_page_text',
                'type'    => 'textarea',
                'title'   => esc_html__('404 page Text', 'dailyfit'),
                'default' => esc_html__('Sorry, we couldnot find the page you are looking for', 'dailyfit'),
            ),
            array(
                'id'       => 'back_home_btn',
                'title'    => esc_html__('Show Button', 'dailyfit'),
                'subtitle' => esc_html__('Show 404 Page Button', 'dailyfit'),
                'type'     => 'switch',
                'default'  => true
            ),
            array(
                'id'      => 'back_home_btn_label',
                'type'    => 'text',
                'title'   => esc_html__('404 page button Title', 'dailyfit'),
                'default' => esc_html__('Back To Home Page', 'dailyfit'),
                 'required' => array( 'back_home_btn', '=', true ),
            ),
        )
    )
));


/*--------------------------------------------------------------
# Service
--------------------------------------------------------------*/
Redux::setSection($opt_name, array(
    'title'      => esc_html__('Service', 'dailyfit'),
    'icon'       => 'eicon-post-list',
    'fields'     => array(
        array(
            'id'       => 'service_display',
            'type'     => 'button_set',
            'title'    => esc_html__('Service', 'dailyfit'),
            'options'  => array(
                'on' => esc_html__('On', 'dailyfit'),
                'off' => esc_html__('Off', 'dailyfit'),
            ),
            'default'  => 'on',
        ),
        array(
            'id'       => 'sg_service_title',
            'type'     => 'button_set',
            'title'    => esc_html__('Page Title Type', 'dailyfit'),
            'options'  => array(
                'default' => esc_html__('Default', 'dailyfit'),
                'custom_text' => esc_html__('Custom Text', 'dailyfit'),
            ),
            'default'  => 'default',
            'required' => array( 0 => 'service_display', 1 => 'equals', 2 => 'on' ),
            'force_output' => true
        ),
        array(
            'id'      => 'sg_service_title_text',
            'type'    => 'text',
            'title'   => esc_html__('Page Title Text', 'dailyfit'),
            'default' => 'Single Service',
            'required' => array( 0 => 'sg_service_title', 1 => 'equals', 2 => 'custom_text' ),
        ),
        array(
            'id'      => 'service_slug',
            'type'    => 'text',
            'title'   => esc_html__('Service Slug', 'dailyfit'),
            'default' => '',
            'desc'     => 'Default: service',
            'required' => array( 0 => 'service_display', 1 => 'equals', 2 => 'on' ),
            'force_output' => true
        ),
        array(
            'id'      => 'service_name',
            'type'    => 'text',
            'title'   => esc_html__('Service Name', 'dailyfit'),
            'default' => '',
            'desc'     => 'Default: Services',
            'required' => array( 0 => 'service_display', 1 => 'equals', 2 => 'on' ),
            'force_output' => true
        ),
        array(
            'id'    => 'archive_service_link',
            'type'  => 'select',
            'title' => esc_html__( 'Custom Archive Page Link', 'dailyfit' ), 
            'data'  => 'page',
            'args'  => array(
                'post_type'      => 'page',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                'order'          => 'ASC',
            ),
            'required' => array( 0 => 'service_display', 1 => 'equals', 2 => 'on' ),
            'force_output' => true
        ),
    )
));


/*--------------------------------------------------------------
# Portfolio
--------------------------------------------------------------*/
Redux::setSection($opt_name, array(
    'title'      => esc_html__('Portfolio', 'dailyfit'),
    'icon'       => 'el el-briefcase',
    'fields'     => array(
        array(
            'id'       => 'portfolio_display',
            'type'     => 'button_set',
            'title'    => esc_html__('Portfolio', 'dailyfit'),
            'options'  => array(
                'on' => esc_html__('On', 'dailyfit'),
                'off' => esc_html__('Off', 'dailyfit'),
            ),
            'default'  => 'on',
        ),
        array(
            'id'       => 'sg_portfolio_title',
            'type'     => 'button_set',
            'title'    => esc_html__('Page Title Type', 'dailyfit'),
            'options'  => array(
                'default' => esc_html__('Default', 'dailyfit'),
                'custom_text' => esc_html__('Custom Text', 'dailyfit'),
            ),
            'default'  => 'default',
            'required' => array( 0 => 'portfolio_display', 1 => 'equals', 2 => 'on' ),
            'force_output' => true
        ),
        array(
            'id'      => 'sg_portfolio_title_text',
            'type'    => 'text',
            'title'   => esc_html__('Page Title Text', 'dailyfit'),
            'default' => 'Single Portfolio',
            'required' => array( 0 => 'sg_portfolio_title', 1 => 'equals', 2 => 'custom_text' ),
        ),
        array(
            'id'      => 'portfolio_slug',
            'type'    => 'text',
            'title'   => esc_html__('Portfolio Slug', 'dailyfit'),
            'default' => '',
            'desc'     => 'Default: portfolio',
            'required' => array( 0 => 'portfolio_display', 1 => 'equals', 2 => 'on' ),
            'force_output' => true
        ),
        array(
            'id'      => 'portfolio_name',
            'type'    => 'text',
            'title'   => esc_html__('Portfolio Name', 'dailyfit'),
            'default' => '',
            'desc'     => 'Default: Portfolio',
            'required' => array( 0 => 'portfolio_display', 1 => 'equals', 2 => 'on' ),
            'force_output' => true
        ),
        array(
            'id'    => 'archive_portfolio_link',
            'type'  => 'select',
            'title' => esc_html__( 'Custom Archive Page Link', 'dailyfit' ), 
            'data'  => 'page',
            'args'  => array(
                'post_type'      => 'page',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                'order'          => 'ASC',
            ),
            'required' => array( 0 => 'portfolio_display', 1 => 'equals', 2 => 'on' ),
            'force_output' => true
        ),
    )
));


/*--------------------------------------------------------------
# Team
--------------------------------------------------------------*/
Redux::setSection($opt_name, array(
    'title'      => esc_html__('Team', 'dailyfit'),
    'icon'       => 'eicon-person',
    'fields'     => array(
        array(
            'id'       => 'team_display1',
            'type'     => 'switch',
            'title'    => esc_html__('Team', 'dailyfit'),
            'default'  => true
        ),
        array(
            'id'       => 'sg_team_title',
            'type'     => 'button_set',
            'title'    => esc_html__('Page Title Type', 'dailyfit'),
            'options'  => array(
                'default' => esc_html__('Default', 'dailyfit'),
                'custom_text' => esc_html__('Custom Text', 'dailyfit'),
            ),
            'default'  => 'default',
            'required' => array( 0 => 'team_display1', 1 => 'equals', 2 => 'true' ),
            'force_output' => true
        ),
        array(
            'id'      => 'sg_team_title_text',
            'type'    => 'text',
            'title'   => esc_html__('Page Title Text', 'dailyfit'),
            'default' => 'Single Portfolio',
            'required' => array( 0 => 'sg_team_title', 1 => 'equals', 2 => 'custom_text' ),
        ),
        array(
            'id'      => 'team_slug',
            'type'    => 'text',
            'title'   => esc_html__('Team Slug', 'dailyfit'),
            'default' => '',
            'desc'     => 'Default: team',
            'required' => array( 0 => 'team_display1', 1 => 'equals', 2 => 'true' ),
            'force_output' => true
        ),
        array(
            'id'      => 'team_name',
            'type'    => 'text',
            'title'   => esc_html__('Career Name', 'dailyfit'),
            'default' => '',
            'desc'     => 'Default: Team',
            'required' => array( 0 => 'team_display1', 1 => 'equals', 2 => 'true' ),
            'force_output' => true
        ),
        array(
            'id'    => 'archive_team_link',
            'type'  => 'select',
            'title' => esc_html__( 'Custom Archive Page Link', 'dailyfit' ), 
            'data'  => 'page',
            'args'  => array(
                'post_type'      => 'page',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                'order'          => 'ASC',
            ),
            'required' => array( 0 => 'team_display1', 1 => 'equals', 2 => 'true' ),
            'force_output' => true
        ),
    )
));




/*--------------------------------------------------------------
# Shop
--------------------------------------------------------------*/
if(class_exists('Woocommerce')) {
    Redux::setSection($opt_name, array(
        'title'  => esc_html__('Shop', 'dailyfit'),
        'icon'   => 'el el-shopping-cart',
    ));

    Redux::setSection($opt_name, array(
        'title' => esc_html__('Product Archive', 'dailyfit'),
        'icon'  => 'el-icon-pencil',
        'subsection' => true,
        'fields'     => array_merge(
            dailyfit_sidebar_pos_opts([ 'prefix' => 'shop_']),
            array(
                array(
                    'title'         => esc_html__('Products displayed per row', 'dailyfit'),
                    'id'            => 'products_columns',
                    'type'          => 'slider',
                    'subtitle'      => esc_html__('Number product to show per row', 'dailyfit'),
                    'default'       => 3,
                    'min'           => 2,
                    'step'          => 1,
                    'max'           => 5,
                    'display_value' => 'text',
                ),
                array(
                    'title'         => esc_html__('Products displayed per page', 'dailyfit'),
                    'id'            => 'product_per_page',
                    'type'          => 'slider',
                    'subtitle'      => esc_html__('Number product to show', 'dailyfit'),
                    'default'       => 9,
                    'min'           => 3,
                    'step'          => 1,
                    'max'           => 50,
                    'display_value' => 'text'
                ),
            ),
            
        )
    ));

    Redux::setSection($opt_name, array(
        'title'      => esc_html__('Single Product', 'dailyfit'),
        'icon'       => 'el-icon-pencil',
        'subsection' => true,
        'fields'     => array_merge(
            
            array(
                array(
                    'id'      => 'header_layout_product',
                    'type'    => 'select',
                    'title'   => esc_html__('Main Header Layout', 'dailyfit'),
                    'desc'    => sprintf(esc_html__('Please create your layout before choosing. %sClick Here%s','dailyfit'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=exp-template' ) ) . '">','</a>'),
                    'options' => dailyfit_get_templates_option('header','false'),
                    'default' => ''
                ),
                array(
                    'id'           => 'pt_mode_product',
                    'type'         => 'button_set',
                    'title'        => esc_html__( 'Page Title', 'dailyfit' ),
                    'options' => [
                        'df'  => esc_html__('Default', 'dailyfit'),
                        'none'  => esc_html__('Disable', 'dailyfit')
                    ], 
                    'default' => 'none'
                ),
                array(
                    'id'       => 'sg_product_ptitle',
                    'type'     => 'button_set',
                    'title'    => esc_html__('Page Title Type', 'dailyfit'),
                    'options'  => array(
                        'default'     => esc_html__('Default', 'dailyfit'),
                        'custom_text' => esc_html__('Custom Text', 'dailyfit'),
                    ),
                    'default'  => 'default',
                ),
                array(
                    'id'      => 'sg_product_ptitle_text',
                    'type'    => 'text',
                    'title'   => esc_html__('Page Title Text', 'dailyfit'),
                    'default' => 'Shop Details',
                    'required' => array( 'sg_product_ptitle', 'equals', 'custom_text' ),
                ),
                array(
                    'id'       => 'product_title',
                    'type'     => 'switch',
                    'title'    => esc_html__('Product Title', 'dailyfit'),
                    'default'  => false
                ),
                array(
                    'id'       => 'product_social_share',
                    'type'     => 'switch',
                    'title'    => esc_html__('Social Share', 'dailyfit'),
                    'default'  => false
                ),
                array(
                    'id'             => 'content_spacing_sg_product',
                    'type'           => 'spacing',
                    'output'         => array( '.single-product #exp-wapper #exp-main' ),
                    'right'          => false,
                    'left'           => false,
                    'mode'           => 'padding',
                    'units'          => array( 'px' ),
                    'units_extended' => 'false',
                    'title'          => esc_html__( 'Content Spacing Top/Bottom', 'dailyfit' ),
                    'default'        => array(
                        'padding-top'    => '',
                        'padding-bottom' => '',
                        'units'          => 'px',
                    )
                ),
            )
        )
    ));
    
}


/*--------------------------------------------------------------
# Typography
--------------------------------------------------------------*/
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Typography', 'dailyfit'),
    'icon'   => 'el-icon-text-width',
    'fields' => array(
        array(
            'id'       => 'exp_body_typography',
            'type'     => 'select',
            'title'    => esc_html__('Body Font Type', 'dailyfit'),
            'options'  => array(
                'google-font'  => esc_html__('Google Font', 'dailyfit'),
                'gt-walsheim-pro'  => esc_html__('GT Walsheim Pro', 'dailyfit'),
                'glacial-indifference'  => esc_html__('Glacial Indifference', 'dailyfit'),
            ),
            'default'  => 'google-font',
        ),

        array(
            'id'          => 'font_body',
            'type'        => 'typography',
            'title'       => esc_html__('Body Google Font', 'dailyfit'),
            'google'      => true,
            'font-backup' => false,
            'all_styles'  => true,
            'line-height'  => true,
            'font-size'  => true,
            'text-align'  => false,
            'output'      => array('body'),
            'units'       => 'px',
            'required' => array( 0 => 'exp_body_typography', 1 => 'equals', 2 => 'google-font' ),
            'force_output' => true
        ),

        array(
            'id'       => 'exp_heading_typography',
            'type'     => 'select',
            'title'    => esc_html__('Heading Font Type', 'dailyfit'),
            'options'  => array(
                'google-font'  => esc_html__('Google Font', 'dailyfit'),
                'gt-walsheim-pro'  => esc_html__('GT Walsheim Pro', 'dailyfit'),
                'glacial-indifference'  => esc_html__('Glacial Indifference', 'dailyfit'),
                'chronicle-display'  => esc_html__('Chronicle Display', 'dailyfit'),
            ),
            'default'  => 'google-font',
        ),
        
        array(
            'id'          => 'font_heading',
            'type'        => 'typography',
            'title'       => esc_html__('Heading Google Font', 'dailyfit'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'line-height'  => false,
            'font-size'  => false,
            'font-backup'  => false,
            'font-style'  => false,
            'output'      => array('h1,h2,h3,h4,h5,h6,.ft-heading-default'),
            'units'       => 'px',
            'required' => array( 0 => 'exp_heading_typography', 1 => 'equals', 2 => 'google-font' ),
            'force_output' => true
        ),

        array(
            'id'          => 'theme_default',
            'type'        => 'typography',
            'title'       => esc_html__('Theme Default', 'dailyfit'),
            'google'      => true,
            'font-backup' => false,
            'all_styles'  => false,
            'line-height'  => false,
            'font-size'  => false,
            'color'  => false,
            'font-style'  => false,
            'font-weight'  => false,
            'text-align'  => false,
            'units'       => 'px',
            'required' => array( 0 => 'exp_heading_typography', 1 => 'equals', 2 => 'google-font' ),
            'force_output' => true
        ),

    )
));