<?php
 
add_action( 'exp_post_metabox_register', 'dailyfit_page_options_register' );
function dailyfit_page_options_register( $metabox ) {
	$panels = [
		'post' => [
			'opt_name'            => 'post_option',
			'display_name'        => esc_html__( 'Post Options', 'dailyfit' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'post_settings' => [
					'title'  => esc_html__( 'Post Options', 'dailyfit' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						dailyfit_sidebar_pos_opts(['prefix' => 'post_', 'default' => true, 'default_value' => '-1']),
						array(
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#exp-wapper #exp-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'dailyfit' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
							array(
					            'id'=> 'blog_excerpt',
					            'type' => 'textarea',
					            'title' => esc_html__('Excerpt', 'dailyfit'),
					            'validate' => 'html_custom',
					            'default' => '',
					        ),
							array(
					            'id'          => 'post_color',
					            'type'        => 'color',
					            'title'       => esc_html__('Color', 'dailyfit'),
					            'transparent' => false,
					            'default'     => ''
					        ),
					        array(
					            'id'=> 'post_video_link',
					            'type' => 'text',
					            'title' => esc_html__('Video Link', 'dailyfit'),
					            'validate' => 'url',
					            'default' => '',
					        ),
					        array(
					            'id'       => 'post_slider',
						        'type'     => 'gallery',
						        'title'    => esc_html__('Image Slider', 'dailyfit'),
					        ),
					    )
					)
				],
				'header' => [
					'title'  => esc_html__( 'Header', 'dailyfit' ),
					'icon'   => 'eicon-header',
					'fields' => array_merge(
				        dailyfit_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
					        array(
				                'id'       => 'p_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu', 'dailyfit' ),
				                'options'  => dailyfit_get_nav_menu_slug(),
				                'default' => '',
				                'description' => 'When you select Custom Menu. The custom menu will apply to the entire layout when you use Case Nav Menu widget in Elementor and Menu on header layout in Mobile.'
				            ),
					    ),
					    array(
				            array(
				                'id'       => 'sticky_scroll',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Sticky Scroll', 'dailyfit'),
				                'options'  => array(
				                    '-1' => esc_html__('Inherit', 'dailyfit'),
				                    'exp-sticky-stt' => esc_html__('Scroll To Top', 'dailyfit'),
				                    'exp-sticky-stb'  => esc_html__('Scroll To Bottom', 'dailyfit'),
				                ),
				                'default'  => '-1',
				            ),
				            array(
				                'id'       => 'header_margin',
				                'type'     => 'spacing',
				                'mode'     => 'margin',
				                'title'    => esc_html__('Margin', 'dailyfit'),
				                'width'    => false,
				                'unit'     => 'px',
				                'output'    => array('#exp-header-elementor .exp-header-elementor-main'),
				            ),
				        )
				    )
					 
				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'dailyfit' ),
					'icon'   => 'el el-pencil',
					'fields' => array_merge(
				        dailyfit_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
				    )
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'dailyfit' ),
					'icon'   => 'eicon-footer',
					'fields' => array_merge(
				        dailyfit_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
				                'id'       => 'footer_display',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Footer Display', 'dailyfit'),
				                'options'  => array(
				                    'show' => esc_html__('Show', 'dailyfit'),
				                    'hide'  => esc_html__('Hide', 'dailyfit'),
				                ),
				                'default'  => 'show',
				            ),
							array(
				                'id'       => 'p_footer_fixed',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Footer Fixed', 'dailyfit'),
				                'options'  => array(
				                    'inherit' => esc_html__('Inherit', 'dailyfit'),
				                    'on' => esc_html__('On', 'dailyfit'),
				                    'off' => esc_html__('Off', 'dailyfit'),
				                ),
				                'default'  => 'inherit',
				            ),
						),
				    )
					 
				],
			]
		],
		'page' => [
			'opt_name'            => 'exp_page_options',
			'display_name'        => esc_html__( 'Page Options', 'dailyfit' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'Header', 'dailyfit' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
				        dailyfit_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
					        array(
				                'id'       => 'p_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu', 'dailyfit' ),
				                'options'  => dailyfit_get_nav_menu_slug(),
				                'default' => '',
				            ),
					    ),
					    array(
				            array(
				                'id'       => 'sticky_scroll',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Sticky Scroll', 'dailyfit'),
				                'options'  => array(
				                    '-1' => esc_html__('Inherit', 'dailyfit'),
				                    'exp-sticky-stt' => esc_html__('Scroll To Top', 'dailyfit'),
				                    'exp-sticky-stb'  => esc_html__('Scroll To Bottom', 'dailyfit'),
				                ),
				                'default'  => '-1',
				            ),
				        )
				    )
					 
				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'dailyfit' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        dailyfit_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'content' => [
					'title'  => esc_html__( 'Content', 'dailyfit' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						dailyfit_sidebar_pos_opts(['prefix' => 'page_', 'default' => false, 'default_value' => '0']),
						array(
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#exp-wapper #exp-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'dailyfit' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							), 
					    )
					)
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'dailyfit' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        dailyfit_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
				                'id'       => 'footer_display',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Footer Display', 'dailyfit'),
				                'options'  => array(
				                    'show' => esc_html__('Show', 'dailyfit'),
				                    'hide'  => esc_html__('Hide', 'dailyfit'),
				                ),
				                'default'  => 'show',
				            ),
							array(
				                'id'       => 'p_footer_fixed',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Footer Fixed', 'dailyfit'),
				                'options'  => array(
				                    'inherit' => esc_html__('Inherit', 'dailyfit'),
				                    'on' => esc_html__('On', 'dailyfit'),
				                    'off' => esc_html__('Off', 'dailyfit'),
				                ),
				                'default'  => 'inherit',
				            ),
						)
				    )
				],
				
				
			]
		],
		'portfolio' => [
			'opt_name'            => 'exp_portfolio_options',
			'display_name'        => esc_html__( 'Portfolio Options', 'dailyfit' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'general' => [
					'title'  => esc_html__( 'General', 'dailyfit' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
							array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#exp-wapper #exp-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'dailyfit' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
							array(
					            'id'=> 'portfolio_excerpt',
					            'type' => 'textarea',
					            'title' => esc_html__('Excerpt', 'dailyfit'),
					            'validate' => 'html_custom',
					            'default' => '',
					        ),
							array(
					            'id'=> 'portfolio_external_link',
					            'type' => 'text',
					            'title' => esc_html__('External Link', 'dailyfit'),
					            'validate' => 'url',
					            'default' => '',
					        ),
						)
				    )
				],
				'header' => [
					'title'  => esc_html__( 'Header', 'dailyfit' ),
					'icon'   => 'eicon-header',
					'fields' => array_merge(
				        dailyfit_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
					        array(
				                'id'       => 'p_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu', 'dailyfit' ),
				                'options'  => dailyfit_get_nav_menu_slug(),
				                'default' => '',
				                'description' => 'When you select Custom Menu. The custom menu will apply to the entire layout when you use Case Nav Menu widget in Elementor and Menu on header layout in Mobile.'
				            ),
				            array(
				                'id'       => 'sticky_scroll',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Sticky Scroll', 'dailyfit'),
				                'options'  => array(
				                    '-1' => esc_html__('Inherit', 'dailyfit'),
				                    'exp-sticky-stt' => esc_html__('Scroll To Top', 'dailyfit'),
				                    'exp-sticky-stb'  => esc_html__('Scroll To Bottom', 'dailyfit'),
				                ),
				                'default'  => '-1',
				            ),
				            array(
				                'id'       => 'header_margin',
				                'type'     => 'spacing',
				                'mode'     => 'margin',
				                'title'    => esc_html__('Margin', 'dailyfit'),
				                'width'    => false,
				                'unit'     => 'px',
				                'output'    => array('#exp-header-elementor .exp-header-elementor-main'),
				            ),
					    ),
				    ) 
				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'dailyfit' ),
					'icon'   => 'el el-pencil',
					'fields' => array_merge(
				        dailyfit_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
				    )
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'dailyfit' ),
					'icon'   => 'eicon-footer',
					'fields' => array_merge(
				        dailyfit_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
    						array(
    			                'id'       => 'footer_display',
    			                'type'     => 'button_set',
    			                'title'    => esc_html__('Footer Display', 'dailyfit'),
    			                'options'  => array(
    			                    'show' => esc_html__('Show', 'dailyfit'),
    			                    'hide'  => esc_html__('Hide', 'dailyfit'),
    			                ),
    			                'default'  => 'show',
    			            ),
    						array(
    			                'id'       => 'p_footer_fixed',
    			                'type'     => 'button_set',
    			                'title'    => esc_html__('Footer Fixed', 'dailyfit'),
    			                'options'  => array(
    			                    'inherit' => esc_html__('Inherit', 'dailyfit'),
    			                    'on' => esc_html__('On', 'dailyfit'),
    			                    'off' => esc_html__('Off', 'dailyfit'),
    			                ),
    			                'default'  => 'inherit',
    			            ),
    			        ),
				    )
					 
				],
			]
		],
		'service' => [
			'opt_name'            => 'exp_service_options',
			'display_name'        => esc_html__( 'Service Options', 'dailyfit' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'general' => [
					'title'  => esc_html__( 'General', 'dailyfit' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
					        array(
					            'id'       => 'service_icon_type',
					            'type'     => 'button_set',
					            'title'    => esc_html__('Icon Type', 'dailyfit'),
					            'options'  => array(
					                'icon'  => esc_html__('Icon', 'dailyfit'),
					                'image'  => esc_html__('Image', 'dailyfit'),
					            ),
					            'default'  => 'icon'
					        ),
					        array(
					            'id'       => 'service_icon_font',
					            'type'     => 'exp_iconpicker',
					            'title'    => esc_html__('Icon', 'dailyfit'),
					            'required' => array( 0 => 'service_icon_type', 1 => 'equals', 2 => 'icon' ),
            					'force_output' => true
					        ),
					        array(
					            'id'       => 'service_icon_img',
					            'type'     => 'media',
					            'title'    => esc_html__('Icon Image', 'dailyfit'),
					            'default' => '',
					            'required' => array( 0 => 'service_icon_type', 1 => 'equals', 2 => 'image' ),
				            	'force_output' => true
					        ),
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#exp-wapper #exp-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'dailyfit' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
							
							array(
					            'id'=> 'service_excerpt',
					            'type' => 'textarea',
					            'title' => esc_html__('Excerpt', 'dailyfit'),
					            'validate' => 'html_custom',
					            'default' => '',
					        ),
							array(
					            'id'=> 'service_external_link',
					            'type' => 'text',
					            'title' => esc_html__('External Link', 'dailyfit'),
					            'validate' => 'url',
					            'default' => '',
					        ),
						)
				    )
				],
				'header' => [
					'title'  => esc_html__( 'Header', 'dailyfit' ),
					'icon'   => 'eicon-header',
					'fields' => array_merge(
				        dailyfit_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
					        array(
				                'id'       => 'p_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu', 'dailyfit' ),
				                'options'  => dailyfit_get_nav_menu_slug(),
				                'default' => '',
				                'description' => 'When you select Custom Menu. The custom menu will apply to the entire layout when you use Case Nav Menu widget in Elementor and Menu on header layout in Mobile.'
				            ),
				            array(
				                'id'       => 'sticky_scroll',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Sticky Scroll', 'dailyfit'),
				                'options'  => array(
				                    '-1' => esc_html__('Inherit', 'dailyfit'),
				                    'exp-sticky-stt' => esc_html__('Scroll To Top', 'dailyfit'),
				                    'exp-sticky-stb'  => esc_html__('Scroll To Bottom', 'dailyfit'),
				                ),
				                'default'  => '-1',
				            ),
				            array(
				                'id'       => 'header_margin',
				                'type'     => 'spacing',
				                'mode'     => 'margin',
				                'title'    => esc_html__('Margin', 'dailyfit'),
				                'width'    => false,
				                'unit'     => 'px',
				                'output'    => array('#exp-header-elementor .exp-header-elementor-main'),
				            ),
					    ),
				    ) 
				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'dailyfit' ),
					'icon'   => 'el el-pencil',
					'fields' => array_merge(
				        dailyfit_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
				    )
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'dailyfit' ),
					'icon'   => 'eicon-footer',
					'fields' => array_merge(
				        dailyfit_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
    						array(
    			                'id'       => 'footer_display',
    			                'type'     => 'button_set',
    			                'title'    => esc_html__('Footer Display', 'dailyfit'),
    			                'options'  => array(
    			                    'show' => esc_html__('Show', 'dailyfit'),
    			                    'hide'  => esc_html__('Hide', 'dailyfit'),
    			                ),
    			                'default'  => 'show',
    			            ),
    						array(
    			                'id'       => 'p_footer_fixed',
    			                'type'     => 'button_set',
    			                'title'    => esc_html__('Footer Fixed', 'dailyfit'),
    			                'options'  => array(
    			                    'inherit' => esc_html__('Inherit', 'dailyfit'),
    			                    'on' => esc_html__('On', 'dailyfit'),
    			                    'off' => esc_html__('Off', 'dailyfit'),
    			                ),
    			                'default'  => 'inherit',
    			            ),
    			        ),
				    )
					 
				],
			]
		],
		'team' => [
			'opt_name'            => 'exp_team_options',
			'display_name'        => esc_html__( 'Team Options', 'dailyfit' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'general' => [
					'title'  => esc_html__( 'General', 'dailyfit' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
						    array(
            					'id'        => 'social_media_tabs',
            					'type'      => 'repeater',
            					'icon' => 'el-icon-thumbs-up',
            					'title'     => __('Add Social Media', 'dailyfit'),
            					'group_values' => true,
            					'sortable' => true,
            					'fields'    => array(
            					    array(
                                        'id'       => 'select_social_media',
                                        'type'     => 'exp_iconpicker',
                                        'title'    => esc_html__('Icon', 'dailyfit'),
                                    	'force_output' => true
                                    ),
            						array(
            							'id'      => 'link_social_media',
            							'type'    => 'text',
            							'title'   => __('Text', 'dailyfit'),
            						),
            					)
            				),
						    array(
					            'id'=> 'designation',
					            'type' => 'text',
					            'title' => esc_html__('Designation', 'dailyfit'),
					            'default' => '',
					        ),
							array(
					            'id'=> 'team_excerpt',
					            'type' => 'textarea',
					            'title' => esc_html__('Excerpt', 'dailyfit'),
					            'validate' => 'html_custom',
					            'default' => '',
					        ),
							array(
					            'id'=> 'team_external_link',
					            'type' => 'text',
					            'title' => esc_html__('External Link', 'dailyfit'),
					            'validate' => 'url',
					            'default' => '',
					        ),
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#exp-wapper #exp-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'dailyfit' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
						)
				    )
				],
				'header' => [
					'title'  => esc_html__( 'Header', 'dailyfit' ),
					'icon'   => 'eicon-header',
					'fields' => array_merge(
				        dailyfit_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
					        array(
				                'id'       => 'p_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu', 'dailyfit' ),
				                'options'  => dailyfit_get_nav_menu_slug(),
				                'default' => '',
				                'description' => 'When you select Custom Menu. The custom menu will apply to the entire layout when you use Case Nav Menu widget in Elementor and Menu on header layout in Mobile.'
				            ),
				            array(
				                'id'       => 'sticky_scroll',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Sticky Scroll', 'dailyfit'),
				                'options'  => array(
				                    '-1' => esc_html__('Inherit', 'dailyfit'),
				                    'exp-sticky-stt' => esc_html__('Scroll To Top', 'dailyfit'),
				                    'exp-sticky-stb'  => esc_html__('Scroll To Bottom', 'dailyfit'),
				                ),
				                'default'  => '-1',
				            ),
				            array(
				                'id'       => 'header_margin',
				                'type'     => 'spacing',
				                'mode'     => 'margin',
				                'title'    => esc_html__('Margin', 'dailyfit'),
				                'width'    => false,
				                'unit'     => 'px',
				                'output'    => array('#exp-header-elementor .exp-header-elementor-main'),
				            ),
					    ),
				    ) 
				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'dailyfit' ),
					'icon'   => 'el el-pencil',
					'fields' => array_merge(
				        dailyfit_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
				    )
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'dailyfit' ),
					'icon'   => 'eicon-footer',
					'fields' => array_merge(
				        dailyfit_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
    						array(
    			                'id'       => 'footer_display',
    			                'type'     => 'button_set',
    			                'title'    => esc_html__('Footer Display', 'dailyfit'),
    			                'options'  => array(
    			                    'show' => esc_html__('Show', 'dailyfit'),
    			                    'hide'  => esc_html__('Hide', 'dailyfit'),
    			                ),
    			                'default'  => 'show',
    			            ),
    						array(
    			                'id'       => 'p_footer_fixed',
    			                'type'     => 'button_set',
    			                'title'    => esc_html__('Footer Fixed', 'dailyfit'),
    			                'options'  => array(
    			                    'inherit' => esc_html__('Inherit', 'dailyfit'),
    			                    'on' => esc_html__('On', 'dailyfit'),
    			                    'off' => esc_html__('Off', 'dailyfit'),
    			                ),
    			                'default'  => 'inherit',
    			            ),
    			        ),
				    )
					 
				],
			]
		],
		'mp-event' => [
    		'opt_name'            => 'exp_event_options',
    		'display_name'        => esc_html__( 'Event Options', 'dailyfit' ),
    		'show_options_object' => false,
    		'context'  => 'default',
    		'priority' => 'high',
    		'sections'  => [
    			'header' => [
    				'title'  => esc_html__( 'Header', 'dailyfit' ),
    				'icon'   => 'eicon-header',
    				'fields' => array_merge(
    			        dailyfit_header_opts([
    						'default'         => true,
    						'default_value'   => '-1'
    					]),
    					array(
    				        array(
    			                'id'       => 'p_menu',
    			                'type'     => 'select',
    			                'title'    => esc_html__( 'Menu', 'dailyfit' ),
    			                'options'  => dailyfit_get_nav_menu_slug(),
    			                'default' => '',
    			                'description' => 'When you select Custom Menu. The custom menu will apply to the entire layout when you use Case Nav Menu widget in Elementor and Menu on header layout in Mobile.'
    			            ),
    			            array(
    			                'id'       => 'sticky_scroll',
    			                'type'     => 'button_set',
    			                'title'    => esc_html__('Sticky Scroll', 'dailyfit'),
    			                'options'  => array(
    			                    '-1' => esc_html__('Inherit', 'dailyfit'),
    			                    'exp-sticky-stt' => esc_html__('Scroll To Top', 'dailyfit'),
    			                    'exp-sticky-stb'  => esc_html__('Scroll To Bottom', 'dailyfit'),
    			                ),
    			                'default'  => '-1',
    			            ),
    			            array(
    			                'id'       => 'header_margin',
    			                'type'     => 'spacing',
    			                'mode'     => 'margin',
    			                'title'    => esc_html__('Margin', 'dailyfit'),
    			                'width'    => false,
    			                'unit'     => 'px',
    			                'output'    => array('#exp-header-elementor .exp-header-elementor-main'),
    			            ),
    				    ),
    			    ) 
    			],
    			'page_title' => [
    				'title'  => esc_html__( 'Page Title', 'dailyfit' ),
    				'icon'   => 'el el-pencil',
    				'fields' => array_merge(
    			        dailyfit_page_title_opts([
    						'default'         => true,
    						'default_value'   => '-1'
    					]),
    			    )
    			],
    			'footer' => [
    				'title'  => esc_html__( 'Footer', 'dailyfit' ),
    				'icon'   => 'eicon-footer',
    				'fields' => array_merge(
    			        dailyfit_footer_opts([
    						'default'         => true,
    						'default_value'   => '-1'
    					]),
    					array(
    						array(
    			                'id'       => 'footer_display',
    			                'type'     => 'button_set',
    			                'title'    => esc_html__('Footer Display', 'dailyfit'),
    			                'options'  => array(
    			                    'show' => esc_html__('Show', 'dailyfit'),
    			                    'hide'  => esc_html__('Hide', 'dailyfit'),
    			                ),
    			                'default'  => 'show',
    			            ),
    						array(
    			                'id'       => 'p_footer_fixed',
    			                'type'     => 'button_set',
    			                'title'    => esc_html__('Footer Fixed', 'dailyfit'),
    			                'options'  => array(
    			                    'inherit' => esc_html__('Inherit', 'dailyfit'),
    			                    'on' => esc_html__('On', 'dailyfit'),
    			                    'off' => esc_html__('Off', 'dailyfit'),
    			                ),
    			                'default'  => 'inherit',
    			            ),
    			        ),
    			    )
    				 
    			],
    		]
    	],
		'exp-template' => [ //post_type
			'opt_name'            => 'exp_hidden_template_options',
			'display_name'        => esc_html__( 'Template Options', 'dailyfit' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'dailyfit' ),
					'icon'   => 'el-icon-website',
					'fields' => array(
						array(
							'id'    => 'template_type',
							'type'  => 'select',
							'title' => esc_html__('Type', 'dailyfit'),
				            'options' => [
				            	'df'       	   => esc_html__('Select Type', 'dailyfit'), 
								'header'       => esc_html__('Header Desktop', 'dailyfit'),
							    'header-mobile'=> esc_html__('Header Mobile', 'dailyfit'),
							    'footer'       => esc_html__('Footer', 'dailyfit'), 
							    'mega-menu'    => esc_html__('Mega Menu', 'dailyfit'),
							    'widget'       => esc_html__('Widget Sidebar', 'dailyfit'),
								'page-title'   => esc_html__('Page Title', 'dailyfit'),
								'tab' => esc_html__('Tab', 'dailyfit'),
								'hidden-panel' => esc_html__('Hidden Panel', 'dailyfit'),
								'popup' => esc_html__('Popup', 'dailyfit'),
								'widget' => esc_html__('Widget Sidebar', 'dailyfit'),
				            ],
				            'default' => 'df',
				        ),
				        array(
							'id'    => 'header_type',
							'type'  => 'select',
							'title' => esc_html__('Header Type', 'dailyfit'),
				            'options' => [
				            	'px-header--default'       	   => esc_html__('Default', 'dailyfit'), 
								'px-header--transparent'       => esc_html__('Transparent', 'dailyfit'),
								'px-header--left_sidebar'       => esc_html__('Left Sidebar', 'dailyfit'),
				            ],
				            'default' => 'px-header--default',
				            'indent' => true,
                			'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'header' ),
				        ),
				        array(
				            'id'          => 'hidden_panel_bg',
				            'type'        => 'color',
				            'title'       => esc_html__('Hidden Panel Box Color', 'dailyfit'),
				            'transparent' => false,
				            'default'     => '',
				            'force_output' => true,
				            'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'hidden-panel' ),
				        ),
				        array(
				            'id'          => 'hidden_panel_width',
				            'type'        => 'text',
				            'title'       => esc_html__('Hidden Panel Width', 'dailyfit'),
				            'subtitle'       => esc_html__('Enter number.', 'dailyfit'),
				            'transparent' => false,
				            'default'     => '',
				            'force_output' => true,
				            'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'hidden-panel' ),
				        ),
				        array(
				            'id'          => 'header_sidebar_width',
				            'type'        => 'slider',
				            'title'       => esc_html__('Header Sidebar Width', 'dailyfit'),
				            "default"   => 300,
						    "min"       => 50,
						    "step"      => 1,
						    "max"       => 900,
				            'force_output' => true,
				            'required' => array( 0 => 'header_type', 1 => 'equals', 2 => 'px-header--left_sidebar' ),
				        ),
					),
				    
				],
			]
		],
	];
	$metabox->add_meta_data( $panels );
}