<?php 
/**
 * Actions Hook for the theme
 *
 * @package Expert Themes
 */
add_action('after_setup_theme', 'dailyfit_setup');
function dailyfit_setup(){

    //Set the content width in pixels, based on the theme's design and stylesheet.
    $GLOBALS['content_width'] = apply_filters( 'dailyfit_content_width', 1200 );

    // Make theme available for translation.
    load_theme_textdomain( 'dailyfit', get_template_directory() . '/languages' );

    // Custom Header
    add_theme_support( 'custom-header' );

    // Add default posts and comments RSS feed links to head.
    add_theme_support( 'automatic-feed-links' );

    // Let WordPress manage the document title.
    add_theme_support( 'title-tag' );

    // Enable support for Post Thumbnails on posts and pages.
    add_theme_support( 'post-thumbnails' );

    set_post_thumbnail_size( 1170, 710 );

    // This theme uses wp_nav_menu() in one location.
    register_nav_menus( array(
        'primary' => esc_html__( 'Primary', 'dailyfit' ),
    ) );

    // Add theme support for selective refresh for widgets.
    add_theme_support( 'customize-selective-refresh-widgets' );

    // Add support for core custom logo.
    add_theme_support( 'custom-logo', array(
        'height'      => 250,
        'width'       => 250,
        'flex-width'  => true,
        'flex-height' => true,
    ) );
    add_theme_support( 'post-formats', array (
        '',
    ) );

    // Enable support for Post Thumbnails on posts and pages.
    add_theme_support('post-thumbnails');
    add_image_size( 'dailyfit-thumb-small', 150, 176, true );
    add_image_size( 'dailyfit-thumb-xs', 120, 104, true );
    add_image_size( 'dailyfit-medium', 960, 380, true );
    add_image_size( 'dailyfit-portfolio', 600, 600, true );

    add_theme_support( 'woocommerce' );
    add_theme_support( 'wc-product-gallery-zoom' );
    add_theme_support( 'wc-product-gallery-lightbox' );
    add_theme_support( 'wc-product-gallery-slider' );
    remove_theme_support('widgets-block-editor');

}

/**
 * Register Widgets Position.
 */
add_action( 'widgets_init', 'dailyfit_widgets_position' );
function dailyfit_widgets_position() {
	register_sidebar( array(
		'name'          => esc_html__( 'Blog Sidebar', 'dailyfit' ),
		'id'            => 'sidebar-blog',
		'before_widget' => '<section id="%1$s" class="widget %2$s"><div class="widget-content">',
		'after_widget'  => '</div></section>',
		'before_title'  => '<div class="sidebar-title"><h4>',
		'after_title'   => '</h4></div>',
	) );

	if (class_exists('ReduxFramework')) {
		register_sidebar( array(
			'name'          => esc_html__( 'Page Sidebar', 'dailyfit' ),
			'id'            => 'sidebar-page',
			'before_widget' => '<section id="%1$s" class="widget %2$s"><div class="widget-content">',
			'after_widget'  => '</div></section>',
			'before_title'  => '<h2 class="widget-title"><span>',
			'after_title'   => '</span></h2>',
		) );
		register_sidebar( array(
			'name'          => esc_html__( 'Service Sidebar', 'dailyfit' ),
			'id'            => 'sidebar-service',
			'before_widget' => '<section id="%1$s" class="service-widget %2$s"><div class="widget-content">',
			'after_widget'  => '</div></section>',
			'before_title'  => '<h2 class="widget-title"><span>',
			'after_title'   => '</span></h2>',
		) );
	}

	if ( class_exists( 'Woocommerce' ) ) {
		register_sidebar( array(
			'name'          => esc_html__( 'Shop Sidebar', 'dailyfit' ),
			'id'            => 'sidebar-shop',
			'before_widget' => '<section id="%1$s" class="widget %2$s"><div class="widget-content">',
			'after_widget'  => '</div></section>',
			'before_title'  => '<h2 class="widget-title"><span>',
			'after_title'   => '</span></h2>',
		) );
	}
	
	if ( class_exists( 'Mp_Time_Table' ) ) {
		register_sidebar( array(
			'name'          => esc_html__( 'Event Sidebar', 'dailyfit' ),
			'id'            => 'sidebar-event',
			'before_widget' => '<section id="%1$s" class="widget %2$s"><div class="widget-content">',
			'after_widget'  => '</div></section>',
			'before_title'  => '<h2 class="widget-title"><span>',
			'after_title'   => '</span></h2>',
		) );
	}
}

/**
 * Enqueue Styles Scripts : Front-End
 */
add_action( 'wp_enqueue_scripts', 'dailyfit_scripts' );
function dailyfit_scripts() {  
    $dailyfit_version = wp_get_theme( get_template() );

    wp_enqueue_style( 'dailyfit-bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.css', array(), $dailyfit_version->get( 'Version' ) );
    wp_enqueue_style( 'dailyfit-font-awesome', get_template_directory_uri() . '/assets/css/font-awesome.css', array(), $dailyfit_version->get( 'Version' ));
    wp_enqueue_style( 'dailyfit-flaticon', get_template_directory_uri() . '/assets/css/flaticon.css', array(), $dailyfit_version->get( 'Version' ) );
    wp_enqueue_style( 'animate', get_template_directory_uri() . '/assets/css/animate.css', array(), $dailyfit_version->get( 'Version' ) );
    wp_enqueue_style( 'owl', get_template_directory_uri() . '/assets/css/owl.css', array(), $dailyfit_version->get( 'Version' ) );
    wp_enqueue_style( 'animation', get_template_directory_uri() . '/assets/css/animation.css', array(), $dailyfit_version->get( 'Version' ) );
	wp_enqueue_style( 'jquery-ui', get_template_directory_uri() . '/assets/css/jquery-ui.css', array(), $dailyfit_version->get( 'Version' ) );
    wp_enqueue_style( 'dailyfit-swiper', get_template_directory_uri() . '/assets/css/swiper.min.css', array(), $dailyfit_version->get( 'Version' ) );	
    wp_enqueue_style( 'custom-animate', get_template_directory_uri() . '/assets/css/custom-animate.css', array(), $dailyfit_version->get( 'Version' ) );
	wp_enqueue_style( 'jquery-fancybox', get_template_directory_uri() . '/assets/css/jquery.fancybox.min.css', array(), $dailyfit_version->get( 'Version' ) );
    wp_enqueue_style( 'bootstrap-touchspin', get_template_directory_uri() . '/assets/css/jquery.bootstrap-touchspin.css', array(), $dailyfit_version->get( 'Version' ) );
	wp_enqueue_style( 'msustomscrollbar', get_template_directory_uri() . '/assets/css/jquery.mCustomScrollbar.min.css', array(), $dailyfit_version->get( 'Version' ) );
    wp_enqueue_style( 'custom-header-style', get_template_directory_uri() . '/assets/admin/css/custom-header.css', array(), $dailyfit_version->get( 'Version' ) );
    wp_enqueue_style( 'main-style', get_template_directory_uri() . '/assets/css/style.css', array(), $dailyfit_version->get( 'Version' ) );
    wp_enqueue_style( 'custom', get_template_directory_uri() . '/assets/css/custom.css', array(), $dailyfit_version->get( 'Version' ) );
	wp_enqueue_style( 'custom-admin', get_template_directory_uri() . '/assets/admin/css/custom.css', array(), $dailyfit_version->get( 'Version' ) );
	wp_enqueue_style( 'responsive', get_template_directory_uri() . '/assets/css/responsive.css', array(), $dailyfit_version->get( 'Version' ) );
	wp_enqueue_style( 'default-theme', get_template_directory_uri() . '/assets/css/color-themes/default-theme.css', array(), $dailyfit_version->get( 'Version' ) );
	wp_enqueue_style( 'woocommerce', get_template_directory_uri() . '/assets/admin/css/shop.css', array(), $dailyfit_version->get( 'Version' ) );
	wp_enqueue_style( 'exp-base', get_template_directory_uri() . '/style.css', array(), $dailyfit_version->get( 'Version' ) );
	
	wp_add_inline_style( 'main-style', dailyfit_inline_styles() );
    wp_enqueue_style( 'exp-google-fonts', dailyfit_fonts_url(), array(), null );
	
	//TUT Style
	wp_enqueue_style( 'dailyfit-tut', get_template_directory_uri() . '/assets/css/tut.css', array(), $dailyfit_version->get( 'Version' ) );
	

	wp_enqueue_script( 'popper', get_template_directory_uri() . '/assets/js/popper.min.js', array(), $dailyfit_version->get( 'Version' ), true );
    wp_enqueue_script( 'bootstrap-min', get_template_directory_uri() . '/assets/js/bootstrap.min.js', array(), $dailyfit_version->get( 'Version' ), true );
    wp_enqueue_script( 'jquery-mcustomscrollbar', get_template_directory_uri() . '/assets/js/jquery.mCustomScrollbar.concat.min.js', array(), $dailyfit_version->get( 'Version' ), true );
    wp_enqueue_script( 'fancybox', get_template_directory_uri() . '/assets/js/jquery.fancybox.js', array(), $dailyfit_version->get( 'Version' ), true );
    wp_enqueue_script( 'appear', get_template_directory_uri() . '/assets/js/appear.js', array(), $dailyfit_version->get( 'Version' ), true );
    wp_enqueue_script( 'parallax', get_template_directory_uri() . '/assets/js/parallax.min.js', array(), $dailyfit_version->get( 'Version' ), true );
    wp_enqueue_script( 'tilt-jquery', get_template_directory_uri() . '/assets/js/tilt.jquery.min.js', array(), $dailyfit_version->get( 'Version' ), true );
    wp_enqueue_script( 'jquery-paroller', get_template_directory_uri() . '/assets/js/jquery.paroller.min.js', array(), $dailyfit_version->get( 'Version' ), true );        
    wp_enqueue_script( 'jquery.countdown', get_template_directory_uri() . '/assets/js/jquery.countdown.js', array(), $dailyfit_version->get( 'Version' ), true );
	wp_enqueue_script( 'owl', get_template_directory_uri() . '/assets/js/owl.js', array(), $dailyfit_version->get( 'Version' ), true );
	wp_enqueue_script( 'wow', get_template_directory_uri() . '/assets/js/wow.js', array(), $dailyfit_version->get( 'Version' ), true );
	wp_enqueue_script( 'nav-tool', get_template_directory_uri() . '/assets/js/nav-tool.js', array(), $dailyfit_version->get( 'Version' ), true );
	wp_enqueue_script( 'mixitup', get_template_directory_uri() . '/assets/js/mixitup.js', array(), $dailyfit_version->get( 'Version' ), true );
	wp_enqueue_script( 'jquery-ui', get_template_directory_uri() . '/assets/js/jquery-ui.js', array(), $dailyfit_version->get( 'Version' ), true );
	wp_enqueue_script( 'themepanel', get_template_directory_uri() . '/assets/js/themepanel.js', array(), $dailyfit_version->get( 'Version' ), true );
	wp_enqueue_script( 'marquee-min', get_template_directory_uri() . '/assets/js/marquee.min.js', array(), $dailyfit_version->get( 'Version' ), true );
	wp_enqueue_script( 'swiper-bundle', get_template_directory_uri() . '/assets/js/swiper-bundle.min.js', array(), $dailyfit_version->get( 'Version' ), true );	
	wp_enqueue_script( 'admin-custom-js', get_template_directory_uri() . '/assets/admin/js/custom.js', array(), $dailyfit_version->get( 'Version' ), true );
	wp_enqueue_script( 'main-script', get_template_directory_uri() . '/assets/js/script.js', array(), $dailyfit_version->get( 'Version' ), true );
    wp_enqueue_script( 'elementor-header', get_template_directory_uri() . '/assets/admin/js/elementor-header.js', array(), $dailyfit_version->get( 'Version' ), true );
    wp_enqueue_script( 'elementor-sticky-header', get_template_directory_uri() . '/assets/admin/js/sticky.js', array(), $dailyfit_version->get( 'Version' ), true );
    wp_enqueue_script( 'elementor-shop', get_template_directory_uri() . '/assets/admin/js/shop.js', array(), $dailyfit_version->get( 'Version' ), true );
    /* Cookie */
    wp_register_script( 'exp-cookie', get_template_directory_uri() . '/assets/admin/js/cookie.js', array( 'jquery' ), '1.4.1', true );



    wp_localize_script( 'main-script', 'main_data', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
    do_action( 'dailyfit_scripts');
}

/**
 * Enqueue Styles Scripts : Back-End
 */
add_action('admin_enqueue_scripts', 'dailyfit_admin_style');
function dailyfit_admin_style() {
    $theme = wp_get_theme( get_template() );
    wp_enqueue_style( 'dailyfit-admin-style', get_template_directory_uri() . '/assets/css/admin.css', array(), $theme->get( 'Version' ) );
    wp_enqueue_style('flaticon', get_template_directory_uri() . '/assets/css/flaticon.css');
}

add_action( 'elementor/editor/before_enqueue_scripts', function() {
    wp_enqueue_style( 'admin-flaticon', get_template_directory_uri() . '/assets/css/flaticon.css');
    wp_enqueue_style( 'dailyfit-admin-style', get_template_directory_uri() . '/assets/css/admin.css');
} );

/* Favicon */
add_action('wp_head', 'dailyfit_site_favicon');
function dailyfit_site_favicon(){
    $favicon = dailyfit()->get_theme_opt( 'favicon' );
    if(!empty($favicon['url']))
        echo '<link rel="icon" type="image/png" href="'.esc_url($favicon['url']).'"/>';
}

/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
add_action( 'wp_head', 'dailyfit_pingback_header' );
function dailyfit_pingback_header(){
    if ( is_singular() && pings_open() ) {
        echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
    }
}

/* Hidden Panel */
add_action( 'exp_anchor_target', 'dailyfit_hook_anchor_templates_hidden_panel');
function dailyfit_hook_anchor_templates_hidden_panel(){

    $hidden_templates = dailyfit_get_templates_slug('hidden-panel');
    if(empty($hidden_templates)) return;

    foreach ($hidden_templates as $slug => $values){
        $args = [
            'slug' => $slug,
            'post_id' => $values['post_id']
        ];
        if( did_action('exp_anchor_target_hidden_panel_'.$values['post_id']) <= 0){  
            do_action( 'exp_anchor_target_hidden_panel_'.$values['post_id'], $args );  
        }
    } 
}
if(!function_exists('dailyfit_hook_anchor_hidden_panel')){
    function dailyfit_hook_anchor_hidden_panel($args){
       $hidden_panel_position = get_post_meta( $args['post_id'], 'hidden_panel_position', true );
        $hidden_panel_boxcolor = get_post_meta( $args['post_id'], 'hidden_panel_boxcolor', true );
        $hidden_panel_height = get_post_meta( $args['post_id'], 'hidden_panel_height', true ); ?>
        <div class="exp-hidden-panel-popup exp-hidden-template-<?php echo esc_attr($args['post_id'])?> exp-pos-<?php echo esc_attr($hidden_panel_position); ?>">
            <div class="exp-popup--overlay exp-cursor--cta"></div>
            <div class="exp-popup--conent" style="height:<?php echo esc_attr($hidden_panel_height).'px'; ?>; background-color:<?php echo esc_attr($hidden_panel_boxcolor); ?>;">
                <div class="exp-conent-elementor">
                    <?php echo Elementor\Plugin::$instance->frontend->get_builder_content_for_display( (int)$args['post_id']); ?>
                </div>
            </div>
        </div>
    <?php }
}

/* Elementor Popup */
add_action( 'exp_anchor_target', 'dailyfit_hook_anchor_templates_popup');
function dailyfit_hook_anchor_templates_popup(){

    $popup_templates = dailyfit_get_templates_slug('popup');
    if(empty($popup_templates)) return;

    foreach ($popup_templates as $slug => $values){
        $args = [
            'slug' => $slug,
            'post_id' => $values['post_id']
        ];
        if( did_action('exp_anchor_target_popup_'.$values['post_id']) <= 0){  
            do_action( 'exp_anchor_target_popup_'.$values['post_id'], $args );  
        }
    } 
}
if(!function_exists('dailyfit_hook_anchor_popup')){
    function dailyfit_hook_anchor_popup($args){ ?>
        <div id="exp-popup-elementor" class="exp-popup-elementor-wrap">
            <div class="exp-item--overlay exp-cursor--cta">
                <div class="exp-item--flip exp-item--flip1"></div>
                <div class="exp-item--flip exp-item--flip2"></div>
                <div class="exp-item--flip exp-item--flip3"></div>
                <div class="exp-item--flip exp-item--flip4"></div>
                <div class="exp-item--flip exp-item--flip5"></div>
            </div>
            <div class="exp-item--close exp-close exp-cursor--cta"></div>
            <div class="exp-item--conent">
                <div class="exp-conent-elementor">
                    <?php echo Elementor\Plugin::$instance->frontend->get_builder_content_for_display( (int)$args['post_id']); ?>
                </div>
            </div>
        </div>
    <?php }
}

/* Search Popup */
if(!function_exists('dailyfit_hook_anchor_search')){
    function dailyfit_hook_anchor_search(){ ?>
        <div id="exp-search-popup" class="exp-popup-wrap">
            <div class="exp-item--overlay exp-cursor--cta"></div>
            <div class="exp-item--conent">
                <div class="exp-item--close exp-close exp-cursor--cta"></div>
                <form role="search" method="get" action="<?php echo esc_url(home_url( '/' )); ?>">
                    <input type="text" placeholder="<?php esc_attr_e('Type Your Search Words...', 'dailyfit'); ?>" name="s" class="search-field" />
                    <button type="submit" class="search-submit rm-style-default"><i class="flaticon flaticon-search-2"></i></button>
                    <div class="exp--search-divider"></div>
                </form>
            </div>
        </div>
    <?php }
}       

/* Cart Sidebar */
if(!function_exists('dailyfit_hook_anchor_cart')){
    function dailyfit_hook_anchor_cart(){ ?>
        <div id="exp-cart-sidebar" class="exp-popup-wrap">
            <div class="exp-item--overlay exp-cursor--cta"></div>
            <div class="exp-item--conent exp-widget-cart-sidebar">
                <div class="widget_shopping_cart">
                    <div class="widget_shopping_head">
                        <div class="exp-item--close exp-close exp-cursor--cta"></div>
                        <div class="widget_shopping_title">
                            <?php echo esc_html__( 'Cart', 'dailyfit' ); ?> <span class="widget_cart_counter">(<?php echo sprintf (_n( '%d item', '%d items', WC()->cart->cart_contents_count, 'dailyfit' ), WC()->cart->cart_contents_count ); ?>)</span>
                        </div>
                    </div>
                    <div class="widget_shopping_cart_content">
                        <?php woocommerce_mini_cart(); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php }
}