<?php

if (!class_exists('Dailyfit_Page')) {

    class Dailyfit_Page
    {
        public function get_site_loader(){
            $background_loader = dailyfit()->get_theme_opt('background_loader');
            if($background_loader){
                $background_loader = ($background_loader['url']) ? $background_loader['url'] : get_template_directory_uri().'/assets/images/icons/preloader.svg';
            } else {
                $background_loader = get_template_directory_uri().'/assets/images/icons/preloader.svg';
            }
            if(dailyfit()->get_theme_opt('loader_switch') == 'image' || dailyfit()->get_theme_opt('loader_switch') == 'text' || dailyfit()->get_theme_opt('loader_switch') == 'prebuild'){
                if(dailyfit()->get_theme_opt('loader_switch') == 'image') { ?>
                    <div id="dailyfit-loading">
                            <div id="dailyfit-loading-center">
                              
                                <img src="<?php echo esc_url($background_loader); ?>" alt="<?php esc_attr_e('loading','dailyfit'); ?>">
                                
                            </div>
                        </div>
                <?php } 
                else if(dailyfit()->get_theme_opt('loader_switch') == 'text'){
                if(dailyfit()->get_theme_opt('loader_tag')){
                        $tag = dailyfit()->get_theme_opt('loader_tag')
                    ?>
         
                        <div id="dailyfit-loading">
                            <div id="dailyfit-loading-center">
                              
                                <<?php echo esc_html($tag); ?> class="dailyfit-loader-text"><?php echo esc_html(dailyfit()->get_theme_opt('loader_text')) ?></<?php echo esc_html($tag); ?>>
                                
                            </div>
                        </div>
            <?php }
            }
        
            else if(dailyfit()->get_theme_opt('loader_switch') == 'prebuild') {
                $loader_style = dailyfit()->get_theme_opt('loading_type');
            ?>
            <div id="ct-loadding" class="ct-loader <?php echo esc_attr($loader_style); ?>">
            <?php
                switch($loader_style){
                    case 's1':  ?>
                        <div class="ct-spinner2"></div>
                        <?php break;
                    case 's2': ?>
                        <div class="ct-spinner3">
                          <div class="double-bounce1"></div>
                          <div class="double-bounce2"></div>
                        </div>
                        <?php break;
                    case 's3': ?>
                        <div class="ct-spinner4">
                          <div class="rect1"></div>
                          <div class="rect2"></div>
                          <div class="rect3"></div>
                          <div class="rect4"></div>
                          <div class="rect5"></div>
                        </div>
                        <?php break;
                    case 's4': ?>
                        <div class="ct-spinner5">
                          <div class="bounce1"></div>
                          <div class="bounce2"></div>
                          <div class="bounce3"></div>
                        </div>
                        <?php break;
                    case 's5': ?>
                        <div class="ct-cube-grid">
                          <div class="ct-cube ct-cube1"></div>
                          <div class="ct-cube ct-cube2"></div>
                          <div class="ct-cube ct-cube3"></div>
                          <div class="ct-cube ct-cube4"></div>
                          <div class="ct-cube ct-cube5"></div>
                          <div class="ct-cube ct-cube6"></div>
                          <div class="ct-cube ct-cube7"></div>
                          <div class="ct-cube ct-cube8"></div>
                          <div class="ct-cube ct-cube9"></div>
                        </div>
                        <?php break;
                    case 's6': ?>
                        <div class="ct-folding-cube">
                          <div class="ct-cube1 ct-cube"></div>
                          <div class="ct-cube2 ct-cube"></div>
                          <div class="ct-cube4 ct-cube"></div>
                          <div class="ct-cube3 ct-cube"></div>
                        </div>
                        <?php break;
                    case 's7': ?>
                        <div class="ct-loading-stairs">
                            <div class="loader-bar"></div>
                            <div class="loader-bar"></div>
                            <div class="loader-bar"></div>
                            <div class="loader-bar"></div>
                            <div class="loader-bar"></div>
                            <div class="loader-ball"></div>
                        </div>
                        <?php break;
        
                    case 's8': ?>
                        <div class="ct-dual-ring">
                        </div>
                        <?php break;
        
                    case 's9': ?>
                        <div class="ct-dot-square">
                        </div>
                        <?php break;
        
                    case 's10': ?>
                        <div class="loading-spinner">
                        </div>
                        <?php break;
        
                    case 's11': ?>
                        <div class="loading-ring">
                        </div>
                        <?php break;
        
                    case 's12': ?>
                        <div class="loading-infinity">
                            <div>
                                <span></span>
                            </div>
                            <div>
                                <span></span>
                            </div>
                            <div>
                                <span></span>
                            </div>
                        </div>
                        <?php break;
        
                    default: ?>
                        <div class="loading-spin">
                            <div class="spinner">
                                <div class="right-side"><div class="bar"></div></div>
                                <div class="left-side"><div class="bar"></div></div>
                            </div>
                            <div class="spinner color-2">
                                <div class="right-side"><div class="bar"></div></div>
                                <div class="left-side"><div class="bar"></div></div>
                            </div>
                        </div>
                        <?php break;
                }
        
                ?>
            </div>
                <?php
            }
        
        
        
        
        
            } else { ?>
                <div class="dailyfit-loading display-none"></div>
            <?php }
                    
            }

        public function get_link_pages() {
            wp_link_pages( array(
                'before'      => '<div class="page-links">',
                'after'       => '</div>',
                'link_before' => '<span>',
                'link_after'  => '</span>',
            ) ); 
        }
        

        public function get_page_title(){
            
            $titles = $this->get_title();
            $pt_mode = dailyfit()->get_opt('pt_mode');
            if(is_singular('product' ) && dailyfit()->get_opt('pt_mode_product') == 'none'){
                return;
            }
            $ptitle_layout = (int)dailyfit()->get_opt('ptitle_layout');
            if ($pt_mode == 'bd' && $ptitle_layout > 0 && class_exists('exptheme_Core') && is_callable( 'Elementor\Plugin::instance' )) { ?>
                <div id="exp-page-title-elementor">
                    <?php echo Elementor\Plugin::$instance->frontend->get_builder_content_for_display( $ptitle_layout);?>
                </div>
                <?php 
            }elseif($pt_mode == 'df') {
                $ptitle_breadcrumb_on = dailyfit()->get_opt( 'ptitle_breadcrumb_on', '1' ); 
                $bd_img = dailyfit()->get_opt( 'breadcrumbs_default_img');
                if($bd_img){
                    $bd_img = $bd_img['url'];
                } else {
                    $bd_img = '';
                }
                ?>
                <!-- ==== banner start ==== -->
                     <section class="page-title">
                        <div class="pattern-layer-one" style="background-image: url('<?php echo esc_url($bd_img); ?>')"></div>
                        <div class="auto-container">
                           <h2><?php echo dailyfit_html($titles['title']) ?></h2>
                           <?php if($ptitle_breadcrumb_on == '1') : ?>
                                <?php $this->get_breadcrumb(); ?>
                            <?php endif; ?>
                        </div>
                     </section>
                     <!-- ==== / banner end ==== -->
            <?php } 
        } 

        public function get_title() {
            $title = '';
            // Default titles
            if ( ! is_archive() ) {
                // Posts page view
                if ( is_home() ) {
                    // Only available if posts page is set.
                    if ( ! is_front_page() && $page_for_posts = get_option( 'page_for_posts' ) ) {
                        $title = get_post_meta( $page_for_posts, 'custom_title', true );
                        if ( empty( $title ) ) {
                            $title = get_the_title( $page_for_posts );
                        }
                    }
                    if ( is_front_page() ) {
                        $title = esc_html__( 'Blog', 'dailyfit' );
                    }
                } // Single page view
                elseif ( is_page() ) {
                    $title = get_post_meta( get_the_ID(), 'custom_title', true );
                    if ( ! $title ) {
                        $title = get_the_title();
                    }
                } elseif ( is_404() ) {
                    $title = esc_html__( '404', 'dailyfit' );
                } elseif ( is_search() ) {
                    $title = esc_html__( 'Search results', 'dailyfit' );
                } elseif ( is_singular('lp_course') ) {
                    $title = esc_html__( 'Course', 'dailyfit' );
                } else {
                    $title = get_post_meta( get_the_ID(), 'custom_title', true );
                    if ( ! $title ) {
                        $title = get_the_title();
                    }
                }
            } else {
                $title = get_the_archive_title();
                if( (class_exists( 'WooCommerce' ) && is_shop()) ) {
                    $title = get_post_meta( wc_get_page_id('shop'), 'custom_title', true );
                    if(!$title) {
                        $title = get_the_title( get_option( 'woocommerce_shop_page_id' ) );
                    }
                }
            }

            return array(
                'title' => $title,
            );
        }

        public function get_breadcrumb(){

            if ( ! class_exists( 'EXPERT_Breadcrumb' ) )
            {
                return;
            }

            $breadcrumb = new EXPERT_Breadcrumb();
            $entries = $breadcrumb->get_entries();

            if ( empty( $entries ) )
            {
                return;
            }

            ob_start();

            foreach ( $entries as $entry )
            {
                $entry = wp_parse_args( $entry, array(
                    'label' => '',
                    'url'   => ''
                ) );

                $entry_label = $entry['label'];

                if(!empty($_GET['blog_title'])) {
                    $blog_title = $_GET['blog_title'];
                    $custom_title = explode('_', $blog_title);
                    foreach ($custom_title as $index => $value) {
                        $arr_str_b[$index] = $value;
                    }
                    $str = implode(' ', $arr_str_b);
                    $entry_label = $str;
                }

                if ( empty( $entry_label ) )
                {
                    continue;
                }

                echo '<li>';

                if ( ! empty( $entry['url'] ) )
                {
                    printf(
                        '<a class="breadcrumb-entry" href="%1$s">%2$s</a>',
                        esc_url( $entry['url'] ),
                        esc_attr( $entry_label )
                    );
                }
                else
                {
                    printf( '<span class="breadcrumb-entry" >%s</span>', esc_html( $entry_label ) );
                }

                echo '</li>';
            }

            $output = ob_get_clean();

            if ( $output )
            {
                printf( '<ul class="breadcrumb">%s</ul>', wp_kses_post($output));
            }
        }

        public function get_pagination( $query = null, $ajax = false ){

            if($ajax){
                add_filter('paginate_links', 'dailyfit_ajax_paginate_links');
            }

            $classes = array();

            if ( empty( $query ) )
            {
                $query = $GLOBALS['wp_query'];
            }

            if ( empty( $query->max_num_pages ) || ! is_numeric( $query->max_num_pages ) || $query->max_num_pages < 2 )
            {
                return;
            }

            $paged = $query->get( 'paged', '' );

            if ( ! $paged && is_front_page() && ! is_home() )
            {
                $paged = $query->get( 'page', '' );
            }

            $paged = $paged ? intval( $paged ) : 1;

            $pagenum_link = html_entity_decode( get_pagenum_link() );
            $query_args   = array();
            $url_parts    = explode( '?', $pagenum_link );

            if ( isset( $url_parts[1] ) )
            {
                wp_parse_str( $url_parts[1], $query_args );
            }

            $pagenum_link = remove_query_arg( array_keys( $query_args ), $pagenum_link );
            $pagenum_link = trailingslashit( $pagenum_link ) . '%_%';
            $paginate_links_args = array(
                'base'     => $pagenum_link,
                'total'    => $query->max_num_pages,
                'current'  => $paged,
                'type'     => 'list',
                'mid_size' => 1,
                'add_args' => array_map( 'urlencode', $query_args ),
                'prev_text' => '<i class="fa fa-angle-left"></i>',
                'next_text' => '<i class="fa fa-angle-right"></i>',
            );
            if($ajax){
                $paginate_links_args['format'] = '?page=%#%';
            }
            $links = paginate_links( $paginate_links_args );
            if ( $links ):
            ?>
            <div class="pagination styled-pagination <?php echo esc_attr($ajax?'ajax':''); ?>">
                <?php
                    printf($links);
                ?>
            </div>
            <?php
            endif;
        }
    }
}
