<?php

if (!class_exists('Dailyfit_Footer')) {

    class Dailyfit_Footer
    {
        public function getFooter()
        {
            if(is_singular('elementor_library')) return;
            
            $footer_layout = (int)dailyfit()->get_opt('footer_layout');
            
            if ($footer_layout <= 0 || !class_exists('Exptheme_Core') || !is_callable( 'Elementor\Plugin::instance' )) {
                get_template_part( 'template-parts/footer/default');
            } else {
                $args = [
                    'footer_layout' => $footer_layout
                ];
                get_template_part( 'template-parts/footer/elementor','', $args );
            } 

            // Back To Top
            $back_totop_on = dailyfit()->get_theme_opt('back_to_top', true);
            if ($back_totop_on == 'yes') :
                // Go to Top
                echo dailyfit_go_to_top();
             endif;
            ?>
            
            
        <?php
            // Mouse Move Animation
            dailyfit_mouse_move_animation();
            
            // Cookie Policy
            dailyfit_cookie_policy();

            // Subscribe Popup
            dailyfit_subscribe_popup();

            // Page Popup
            dailyfit_page_popup();
        }
 
    }
}
 