<?php
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: Menu
 */
class Dailyfit_Breadcrumbs extends Widget_Base{

 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'ibreadcrumbs';
	}

	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return __( 'EXPERT Breadcrumbs', 'dailyfit' );
	}

	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'eicon-product-breadcrumbs';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'category_dailyfit_header' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Beadcrumb', 'dailyfit' ),
			]
		);


		$this->add_control(
			'text_color',
			[
				'label' => __( 'Text Color', 'dailyfit' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .breadcrumb li' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'active_color',
			[
				'label' => __( 'Active Color', 'dailyfit' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .breadcrumb li a.breadcrumb-entry' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .breadcrumb li span' => 'color: {{VALUE}} !important;',
				]
			]
		);
		$this->add_control(
			'hover_color',
			[
				'label' => __( 'Hover Color', 'dailyfit' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .breadcrumb li a:hover' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'label' => esc_html__('Text Typography', 'dailyfit' ),
				'selector' => '{{WRAPPER}} .breadcrumb',
			]
		);
		$this->add_control( 
		    'arrow_style',
		    [
                'label' => esc_html__('Arrow Style', 'dailyfit' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'arrow-style1',
                'options' => [
                    'arrow-style1' => esc_html__('Style 1', 'dailyfit' ),
                    'arrow-style2' => esc_html__('Style 2', 'dailyfit' ),
                ]
            ],
        );
        $this->add_control(
			'arrow_color',
			[
				'label' => __( 'Arrow Color', 'dailyfit' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .breadcrumb li::after' => 'color: {{VALUE}};text-fill-color: {{VALUE}};-webkit-text-fill-color: {{VALUE}};background-image: none;',
				]
			]
		);
	}


	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
		
		

		<!-- ==== banner start ==== -->
		
		<div class="exp-breadcrumb-wrap <?php echo esc_attr($settings['arrow_style']); ?>">
        	<?php dailyfit()->page->get_breadcrumb(); ?>
        </div>
		

		<!-- ==== / banner end ==== -->
			
	    <?php
	}

}
// After the Dailyfit_Menu class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register( new Dailyfit_Breadcrumbs() );