<?php
// Load the theme's custom Widgets so that they appear in the Elementor element panel.
add_action( 'elementor/widgets/register', 'dailyfit_register_elementor_widgets' );
function dailyfit_register_elementor_widgets() {
    
    require_once( get_template_directory() . '/inc/backend/elementor/widgets/header/widgets.php' );

}

// Add a custom 'category_dailyfit' category for to the Elementor element panel so that our theme's widgets have their own category.
add_action( 'elementor/init', function() {
    \Elementor\Plugin::$instance->elements_manager->add_category( 
        'category_dailyfit',
        [
            'title' => __( 'Dailyfit', 'dailyfit' ),
            'icon' => 'fa fa-plug', //default icon
        ],
        1 // position
    );
    \Elementor\Plugin::$instance->elements_manager->add_category( 
        'category_dailyfit_header',
        [
            'title' => __( 'Dailyfit Header', 'dailyfit' ),
            'icon' => 'fa fa-plug', //default icon
        ],
        2 // position
    );
});


// Upload SVG for Elementor
function dailyfit_unfiltered_files_upload() {
    
    //if exists, assign to $cpt_support var
    $cpt_support = get_option( 'elementor_unfiltered_files_upload' );
    
    //check if option DOESN'T exist in db
    if( ! $cpt_support ) {
        $cpt_support = '1'; //create string value default to enable upload svg
        update_option( 'elementor_unfiltered_files_upload', $cpt_support ); //write it to the database
    }
}
add_action( 'elementor/init', 'dailyfit_unfiltered_files_upload' );

/**
 * Elementor Add News Custom Fonts
 */

add_filter( 'elementor/fonts/groups', function( $font_groups ) {
    $font_groups['dailyfit_fonts'] = __( 'Dailyfit Fonts', 'dailyfit' );
    return $font_groups;
} );

// Filters the fonts used by Elementor to add additional fonts. //
add_filter( 'elementor/fonts/additional_fonts', function ( $additional_fonts ) {
    $additional_fonts['THICCCBOI'] = 'dailyfit_fonts';
    $additional_fonts['Space Grotesk Dailyfit'] = 'dailyfit_fonts';
    return $additional_fonts;
} );

/*Fix Elementor Pro*/
function dailyfit_register_elementor_locations( $elementor_theme_manager ) {

    $elementor_theme_manager->register_all_core_location();

}
add_action( 'elementor/theme/register_locations', 'dailyfit_register_elementor_locations' );

/*** add options to sections ***/
add_action('elementor/element/section/section_structure/after_section_end', function( $section, $args ) {

    /* header options */
    $section->start_controls_section(
        'section_custom_class',
        [
            'label' => __( 'For Header', 'dailyfit' ),
            'tab'   => \Elementor\Controls_Manager::TAB_LAYOUT,
        ]
    );
    $section->add_control(
        'sticky_class',
        [
            'label'        => __( 'Sticky On/Off', 'dailyfit' ),
            'type'         => Elementor\Controls_Manager::SWITCHER,
            'return_value' => 'is-fixed',
            'prefix_class' => '',
        ]
    );
    $section->add_control(
        'sticky_background',
        [
            'label'     => __( 'Background Scroll', 'dailyfit' ),
            'type'      => Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.elementor-section.is-stuck' => 'background: {{VALUE}};',
            ],
            'condition' => [
                'sticky_class' => 'is-fixed',
            ],
        ]
    );
    $section->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
            'name' => 'sticky_shadow',
            'label' => esc_html__( 'Box Shadow', 'dailyfit' ),
            'selector' => '{{WRAPPER}}.is-stuck',
            'condition' => [
                'sticky_class' => 'is-fixed',
            ],
        ]  
    );
    $section->add_responsive_control(
        'offset_space',
        [
            'label' => __( 'Offset', 'dailyfit' ),
            'type' => Elementor\Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 200,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}}.is-stuck' => 'top: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'sticky_class' => 'is-fixed',
            ],
        ]
    );

    $section->end_controls_section();

}, 10, 2 );

/*** add options to columns ***/
if ( did_action( 'elementor/loaded' ) ) {
    require get_template_directory() . '/inc/backend/elementor/elementor-custom-module.php';
}