<?php
use Elementor\Controls_Stack;
use Elementor\Controls_Manager;
use Elementor\Element_Column;
use Elementor\Core\Base\Module;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Experts_Dailyfit_Effect extends Module {

	public function __construct() {

		$this->add_actions();
	}

	public function get_name() {
		return 'dailyfit-effect';
	}

	/**
	 * @param $element
	 */
	public function register_controls( $element ) {

		$element->start_controls_section(
			'dailyfit_ani_effect',
			[
				'label' => __( 'Dailyfit Effects', 'dailyfit' ),
				'tab'   => Controls_Manager::TAB_ADVANCED,
			]
		);

		$element->add_control(
			'dailyfit_ani_name',
			[
				'label'     => __( 'Animation Name', 'dailyfit' ),
				'type'      => Controls_Manager::SELECT2,
				'default'   => '',
				'label_block' => true,
				'render_type' => 'template',
				'options'   => [
					''					=> __( 'Default', 'dailyfit' ),
					'sbFadeIn'          => __( 'Fade In', 'dailyfit' ),
					'sbSlideInLeft'     => __( 'Slide In Left', 'dailyfit' ),
					'sbSlideInRight'    => __( 'Slide In Right', 'dailyfit' ),
					'sbSlideInDown'     => __( 'Slide In Down', 'dailyfit' ),
					'sbSlideInUp'       => __( 'Slide In Up', 'dailyfit' ),
					'sbZoomIn'          => __( 'Zoom In', 'dailyfit' ),
					'sbZoomOut'         => __( 'Zoom Out', 'dailyfit' ),
					'sbRotateIn'    	=> __( 'Rotate In', 'dailyfit' ),
					'sbBounceIn'   		=> __( 'Bounce In', 'dailyfit' ),
					'sbBounceInLeft' 	=> __( 'Bounce In Left', 'dailyfit' ),
					'sbBounceInRight' 	=> __( 'Bounce In Right', 'dailyfit' ),
					'sbBounceInDown' 	=> __( 'Bounce In Down', 'dailyfit' ),
					'sbBounceInUp' 		=> __( 'Bounce In Up', 'dailyfit' ),
					'sbFlipInX' 		=> __( 'Flip In X', 'dailyfit' ),
					'sbFlipInY' 		=> __( 'Flip In Y', 'dailyfit' ),
				],
			]
		);
		$element->add_control(
			'dailyfit_ani_duration',
			[
				'label'     => __( 'Animation Duration (ms)', 'dailyfit' ),
				'type'      => Controls_Manager::NUMBER,
				'min' => 100,
				'max' => 10000,
				'step' => 50,
				'default' => 700,
				'condition' => [
					'dailyfit_ani_name!'     => '',
				],
			]
		);

		$element->add_control(
			'dailyfit_ani_delay',
			[
				'label'     => __( 'Animation Delay (ms)', 'dailyfit' ),
				'type'      => Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 10000,
				'step' => 50,
				'default' => 300,
				'condition' => [
					'dailyfit_ani_name!'     => '',
				],

			]
		);

		$element->end_controls_section();
	}

	/**
	 * Render Dailyfit Effects output on the frontend.
	 *
	 * Written in PHP and used to collect cursor settings and add it as an element attribute.
	 *
	 * @access public
	 * @param object $element for current element.
	 */
	public function before_render( $element ) {
		$data = $element->get_data();

		$type = $data['elType'];

		$settings = $element->get_settings_for_display();

		if ( 'widget' === $type && ! empty( $settings['dailyfit_ani_name'] ) ) {
			
			$element->add_render_attribute( '_wrapper', 'data-cue', $settings['dailyfit_ani_name'] );
			if( !empty($settings['dailyfit_ani_duration']) ){
				$element->add_render_attribute( '_wrapper', 'data-duration', $settings['dailyfit_ani_duration'] );
			}
			if( !empty($settings['dailyfit_ani_delay']) ){
				$element->add_render_attribute( '_wrapper', 'data-delay', $settings['dailyfit_ani_delay'] );
			}
		}
	}

	protected function add_actions() {
		// Creates Dailyfit Effects tab at the end of advanced tab.
		add_action( 'elementor/element/common/_section_style/after_section_end', [ $this, 'register_controls' ], 10 );
		// Insert data before widget rendering.
		add_action( 'elementor/frontend/widget/before_render', [ $this, 'before_render' ] );
	}
}

new Experts_Dailyfit_Effect();
