<?php
add_action( 'wp_head', 'dailyfit_loader_style');

function dailyfit_loader_style() {

	$css = array();
	
	if(dailyfit()->get_theme_opt('back_top_background_color')){
	    $data = dailyfit()->get_theme_opt('back_top_background_color');
	    $css[] = array (
		'element' => '.te-icon',
		'property' => 'background',
		'value' => $data.'!important'
		);
	}
	
	if(dailyfit()->get_theme_opt('back_top_background_color_hover')){
	    $data = dailyfit()->get_theme_opt('back_top_background_color_hover');
	    $css[] = array (
		'element' => '.te-icon:hover',
		'property' => 'background',
		'value' => $data.'!important'
		);
	}
	
	if(dailyfit()->get_theme_opt('back_top_icon_size')){
	    $data = dailyfit()->get_theme_opt('back_top_icon_size');
	    $css[] = array (
		'element' => '.te-icon',
		'property' => 'font-size',
		'value' => $data.'px !important'
		);
	}
	
	if(dailyfit()->get_theme_opt('back_top_border_radius')){
	    $data = dailyfit()->get_theme_opt('back_top_border_radius');
	    $css[] = array (
		'element' => '.te-icon',
		'property' => 'border-radius',
		'value' => $data.'px !important'
		);
	}
	
	if(dailyfit()->get_theme_opt('back_top_icon_color')){
	    $data = dailyfit()->get_theme_opt('back_top_icon_color');
	    $css[] = array (
		'element' => '.te-icon i',
		'property' => 'color',
		'value' => $data.'!important'
		);
	}
	
	if(dailyfit()->get_theme_opt('back_top_icon_hover_color')){
	    $data = dailyfit()->get_theme_opt('back_top_icon_hover_color');
	    $css[] = array (
		'element' => '.te-icon:hover i',
		'property' => 'color',
		'value' => $data.'!important'
		);
	}
	
	
	
	if(dailyfit()->get_theme_opt('mouse_cursor_color')){
	    $data = dailyfit()->get_theme_opt('mouse_cursor_color');
	    $css[] = array (
		'element' => '.exp-cursor .exp-cursor--follower',
		'property' => 'border',
		'value' => '1px solid '.$data.'!important'
		);
	}
	
	if(dailyfit()->get_theme_opt('mouse_cursor_color')){
	    $data = dailyfit()->get_theme_opt('mouse_cursor_color');
	    $css[] = array (
		'element' => '.exp-cursor .exp-cursor--follower:before',
		'property' => 'background-color',
		'value' => $data.'!important'
		);
	}
	
	if(dailyfit()->get_theme_opt('mouse_cursor_color')){
	    $data = dailyfit()->get_theme_opt('mouse_cursor_color');
	    $css[] = array (
		'element' => '.exp-cursor.is-active .exp-cursor--follower',
		'property' => 'background-color',
		'value' => $data.'!important'
		);
	}
	
	if(dailyfit()->get_theme_opt('mouse_cursor_color')){
	    $data = dailyfit()->get_theme_opt('mouse_cursor_color');
	    $css[] = array (
		'element' => '.exp-cursor.is-active.has-label .exp-cursor--follower',
		'property' => 'background-color',
		'value' => $data.'!important'
		);
	}
	
	
	
	
	
	if(dailyfit()->get_theme_opt('progress_bar_color')){
	    $data = dailyfit()->get_theme_opt('progress_bar_color');
	    $css[] = array (
		'element' => '.exp-scroll-top .exp-scroll-progress-circle path',
		'property' => 'stroke',
		'value' => $data.'!important'
		);
	}
	
	
	
	
	
	
	
	

	if( dailyfit()->get_theme_opt('loader_background_color1') ) {
        $data = dailyfit()->get_theme_opt('loader_background_color1');
    	$css[] = array (
		'element' => '#dailyfit-loading',
		'property' => 'background',
		'value' => $data.'!important'
		);
    }

    if( dailyfit()->get_theme_opt('loader_switch') == 'text' ) {
	     if( dailyfit()->get_theme_opt('loader_background_color')) {
	        $data = dailyfit()->get_theme_opt('loader_background_color');
	    	$css[] = array (
			'element' => '#dailyfit-loading',
			'property' => 'background',
			'value' => $data.'!important'
			);
	     }
	}
	

	if( dailyfit()->get_theme_opt('loader_switch') ) {
    	if( dailyfit()->get_theme_opt('loader_switch') == 'text' ) {
        	if( dailyfit()->get_theme_opt('loader_text') ) {
            	$data = dailyfit()->get_theme_opt('loader_color');
            	$css[] = array (
				'element' => '#dailyfit-loading .dailyfit-loader-text',
				'property' => 'color',
				'value' => $data.'!important'
				);
            }
        }

     	if( dailyfit()->get_theme_opt('loader_switch') == 'image' ) {
        	$background_loader = dailyfit()->get_theme_opt('background_loader');
        	$loader_dimensions = dailyfit()->get_theme_opt('loader_dimensions');
            if( $background_loader ) {
            	if( ( $loader_dimensions['height'] ) && preg_match( '~[0-9]+~',$loader_dimensions['height'] ) ){
            		$data = $loader_dimensions['height'];
            		$css[] = array (
					'element' => '#dailyfit-loading img',
					'property' => 'height',
					'value' => $data.'!important'
					);
            	}

            	if( ( $loader_dimensions['width'] ) && preg_match( '~[0-9]+~',$loader_dimensions['width'] ) ) {
            		$data = $loader_dimensions['width'];
            		$css[] = array (
					'element' => '#dailyfit-loading img',
					'property' => 'width',
					'value' => $data.'!important'
					);
            	}
            }
        }

    }

    if(count($css))
	{
		dailyfit_print_css($css);	
	}
}


function dailyfit_print_css($css)
{
	$str_result = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
$id = substr(str_shuffle(md5($str_result)),0, 5); 
	
	echo '<style id="dailyfit-custom-style-'.$id.'">';
	foreach ( $css as $val ) {
        if ( ! empty( $val[ 'element' ] ) ) {
            echo "\n" . esc_attr($val[ 'element' ]) . "{\n";
            echo esc_attr($val[ 'property' ]) . ":" . esc_attr($val[ 'value' ]) . ";\n";
            echo "}\n\n";
        }
        }
	echo '</style>';
}