<?php
/**
 * Merlin WP configuration file.
 *
 * @package   Merlin WP
 * @version   @@pkg.version
 * @link      https://merlinwp.com/
 * @author    Rich Tabor, from ThemeBeans.com & the team at ProteusThemes.com
 * @copyright Copyright (c) 2018, Merlin WP of Inventionn LLC
 * @license   Licensed GPLv3 for Open Source Use
 */

if ( ! class_exists( 'Merlin' ) ) {
	return;
}

/**
 * Set directory locations, text strings, and settings.
 */
$exp_server_info = apply_filters( 'exp_server_info', ['docs_url' => 'https://expert-themes.com/documentation/dailyfit', 'support_url' => 'https://expert-themes.com/support/'] ) ; 
$wizard = new Merlin(

	$config = array(
		'directory'            => 'merlin', // Location / directory where Merlin WP is placed in your theme.
		'merlin_url'           => 'expert-setup', // The wp-admin page slug where Merlin WP loads.
		'parent_slug'          => 'expert', // The wp-admin parent page slug for the admin menu item.
		'capability'           => 'manage_options', // The capability required for this menu to be displayed to the user.
		'child_action_btn_url' => 'https://codex.wordpress.org/child_themes', // URL for the 'child-action-link'.
		'edd_remote_api_url'   => '', // EDD_Theme_Updater_Admin remote_api_url.
		'edd_item_name'        => '', // EDD_Theme_Updater_Admin item_name.
		'edd_theme_slug'       => '', // EDD_Theme_Updater_Admin item_slug.
		'ready_big_button_url' => home_url( '/' ), // Link for the big button on the ready step.
	),
	$strings = array(
		'admin-menu'               => esc_html__( 'Setup Wizard', 'dailyfit' ),

		'title%s%s%s%s'            => esc_html__( '%1$s%2$s Themes &lsaquo; Theme Setup: %3$s%4$s', 'dailyfit' ),
		'return-to-dashboard'      => esc_html__( 'Return to the dashboard', 'dailyfit' ),
		'ignore'                   => esc_html__( 'Disable this wizard', 'dailyfit' ),

		'btn-skip'                 => esc_html__( 'Skip', 'dailyfit' ),
		'btn-next'                 => esc_html__( 'Next', 'dailyfit' ),
		'btn-start'                => esc_html__( 'Start', 'dailyfit' ),
		'btn-no'                   => esc_html__( 'Cancel', 'dailyfit' ),
		'btn-plugins-install'      => esc_html__( 'Install', 'dailyfit' ),
		'btn-child-install'        => esc_html__( 'Install', 'dailyfit' ),
		'btn-content-install'      => esc_html__( 'Install', 'dailyfit' ),
		'btn-import'               => esc_html__( 'Import', 'dailyfit' ),
		'btn-license-activate'     => esc_html__( 'Activate', 'dailyfit' ),
		'btn-license-skip'         => esc_html__( 'Later', 'dailyfit' ),


		/* translators: Theme Name */
		'welcome-header%s'         => esc_html__( 'Welcome to %s', 'dailyfit' ),
		'welcome-header-success%s' => esc_html__( 'Hi. Welcome back', 'dailyfit' ),
		'welcome%s'                => esc_html__( 'This wizard will set up your theme, install plugins, and import content. It is optional & should take only a few minutes.', 'dailyfit' ),
		'welcome-success%s'        => esc_html__( 'You may have already run this theme setup wizard. If you would like to proceed anyway, click on the "Start" button below.', 'dailyfit' ),

		'child-header'             => esc_html__( 'Install Child Theme', 'dailyfit' ),
		'child-header-success'     => esc_html__( 'You\'re good to go!', 'dailyfit' ),
		'child'                    => esc_html__( 'Let\'s build & activate a child theme so you may easily make theme changes.', 'dailyfit' ),
		'child-success%s'          => esc_html__( 'Your child theme has already been installed and is now activated, if it wasn\'t already.', 'dailyfit' ),
		'child-action-link'        => esc_html__( 'Learn about child themes', 'dailyfit' ),
		'child-json-success%s'     => esc_html__( 'Awesome. Your child theme has already been installed and is now activated.', 'dailyfit' ),
		'child-json-already%s'     => esc_html__( 'Awesome. Your child theme has been created and is now activated.', 'dailyfit' ),

		'plugins-header'           => esc_html__( 'Install Plugins', 'dailyfit' ),
		'plugins-header-success'   => esc_html__( 'Plugins are all installed', 'dailyfit' ),
		'plugins'                  => esc_html__( 'Let\'s install some essential WordPress plugins to get you started.', 'dailyfit' ),
		'plugins-success%s'        => esc_html__( 'The required WordPress plugins are all installed and up to date. Press "Next" to continue the setup wizard.', 'dailyfit' ),
		'plugins-action-link'      => esc_html__( 'View Plugins', 'dailyfit' ),

		'import-header'            => esc_html__( 'Import a Demo', 'dailyfit' ),
		'import'                   => esc_html__( 'Choose a demo for importing to your website', 'dailyfit' ),
		'import-action-link'       => esc_html__( 'Advanced', 'dailyfit' ),

		'ready-header'             => esc_html__( 'All done. Have fun!', 'dailyfit' ),

		/* translators: Theme Author */
		'ready%s'                  => esc_html__( 'Your theme has been all set up. Enjoy your new theme by %s.', 'dailyfit' ),
		'ready-action-link'        => esc_html__( 'Extras', 'dailyfit' ),
		'ready-big-button'         => esc_html__( 'View your website', 'dailyfit' ),
		'ready-link-1'             => sprintf( '<a href="%1$s" target="_blank">%2$s</a>', $exp_server_info['docs_url'], esc_html__( 'Help center', 'dailyfit' ) ),
		'ready-link-2'             => sprintf( '<a href="%1$s" target="_blank">%2$s</a>', $exp_server_info['support_url'], esc_html__( 'Get Theme Support', 'dailyfit' ) ),
		'ready-link-3'             => sprintf( '<a href="%1$s">%2$s</a>', admin_url( 'admin.php?page=expert-theme-options' ), esc_html__( 'Theme Options', 'dailyfit' ) ),
	)
);