<?php
/**
 * Theme functions: init, enqueue scripts and styles, include required files and widgets.
 *
 * @package Expert Themes
 * @since Dailyfit 1.0
 */

if(!defined('THEME_DEV_MODE_ELEMENTS') && is_user_logged_in()){
    define('THEME_DEV_MODE_ELEMENTS', true);
}

require_once get_template_directory() . '/inc/classes/class-main.php';

if ( is_admin() ){
	require_once get_template_directory() . '/inc/admin/admin-init.php'; }

/**
 * Theme Require
*/
dailyfit()->require_folder('inc');
dailyfit()->require_folder('inc/classes');
dailyfit()->require_folder('inc/theme-options');
dailyfit()->require_folder('template-parts/widgets');
if(class_exists('Woocommerce')){
    dailyfit()->require_folder('woocommerce');
}


/**
 * Functions which add more to backend.
 */
require get_template_directory() . '/inc/backend/admin-functions.php';

require get_template_directory() . '/inc/backend/custom-style.php';

/**
 * Elementor functions.
 */
if ( did_action( 'elementor/loaded' ) ) {
    require get_template_directory() . '/inc/backend/elementor/elementor.php';
}

//require get_template_directory() . '/inc/post-like.php';

/** side panel **/
if ( ! function_exists( 'dailyfit_sidepanel_builder' ) ) {
    function dailyfit_sidepanel_builder (){
        
        $panel_builder = dailyfit()->get_opt('header_sidepanel');

        if( !$panel_builder ) {
            return;
        }else{
            if ( did_action( 'elementor/loaded' ) ) {               
                echo \Elementor\Plugin::$instance->frontend->get_builder_content( $panel_builder ); 
            }
        }
    }
}