<?php
exp_add_custom_widget(
    array(
        'name' => 'testimonial_grid',
        'title' => esc_html__('Dailyfit Testimonial Grid', 'dailyfit'),
        'icon' => 'eicon-lock-user',
        'categories' => array('exptheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dailyfit' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/testimonial_grid/layout1.jpg'
                                ],                                
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'dailyfit'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'testimonials',
                            'label' => esc_html__('Testimonials', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'default' => [],
                            'controls' => array(                                								
                                array(
                                    'name' => 'desc',
                                    'label' => esc_html__('Description', 'dailyfit' ),
                                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                                    'rows' => 10,
                                    'show_label' => false,
                                ),
                                array(
                                    'name' => 'star',
                                    'label' => esc_html__('Icon Star', 'dailyfit' ),
                                    'type' => \Elementor\Controls_Manager::SELECT,
                                    'options' => [
                                        '5' => '5 Star',
                                        '4' => '4 Star',
                                        '3' => '3 Star',
                                        '2' => '2 Star',
                                        '1' => '1 Star',
                                    ],
                                    'default' => '5',
                                ),
                                array(
                                    'name' => 'title',
                                    'label' => esc_html__('Title', 'dailyfit'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'designation',
                                    'label' => esc_html__('Designation', 'dailyfit'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'image',
                                    'label' => esc_html__('Choose Image Url', 'dailyfit' ),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                ),
                            ),
                            'title_field' => '{{{ title }}}',
                        ),
                    ),
                ),
                array(
                    'name' => 'section_settings',
                    'label' => esc_html__('Grid', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(                        
                        array(
                            'name' => 'exp_animate',
                            'label' => esc_html__('Expert Animate', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => dailyfit_widget_animate(),
                            'default' => '',
                        ),
                        array(
                            'name' => 'col_xs',
                            'label' => esc_html__('Columns XS Devices', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '1',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_sm',
                            'label' => esc_html__('Columns SM Devices', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '2',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_md',
                            'label' => esc_html__('Columns MD Devices', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_lg',
                            'label' => esc_html__('Columns LG Devices', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '4',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_xl',
                            'label' => esc_html__('Columns XL Devices', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '4',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                            ],
                        ),
                    ),
                ),
                
                //Rating Style   
                array(
                    'name' => 'section_style_rating',
                    'label' => esc_html__('Rating Style', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'rating_color',
                            'label' => esc_html__('Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .te-rating' => 'color: {{VALUE}} !important;',
                                '{{WRAPPER}} .te-rating i' => 'color: {{VALUE}} !important;',
                                '{{WRAPPER}} .te-rating span' => 'color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'icon_font_size',
                            'label' => __( 'icon Font Size', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 500,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .te-rating i' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                                '{{WRAPPER}} .te-rating span' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                            ],
                        ),
                    ),
                ),
                
                //Title Style
				array(
					'name' => 'section_style_title',
					'label' => esc_html__('Title', 'dailyfit' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'controls' => array(
						array(
							'name' => 'title_color',
							'label' => esc_html__('Title Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .te-title' => 'color: {{VALUE}} !important;',
							],
						),
						array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-title',
                        ),
                        array(
							'name' => 'title_margin',
							'label' => __( 'Margin', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .te-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
							],
							'separator'  => 'before',
						),
						array(
							'name' => 'title_padding',
							'label' => __( 'Padding', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .te-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
							],
							'separator'  => 'before',
						),
					),
				),
				
				
				//Text Style
				array(
					'name' => 'section_style_text',
					'label' => esc_html__('Text', 'dailyfit' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'controls' => array(
						array(
							'name' => 'text_color',
							'label' => esc_html__('Text Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .te-text' => 'color: {{VALUE}} !important;',
							],
						),
						array(
                            'name' => 'text_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-text',
                        ),
                        array(
							'name' => 'text_margin',
							'label' => __( 'Margin', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .te-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
							],
							'separator'  => 'before',
						),
						array(
							'name' => 'text_padding',
							'label' => __( 'Padding', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .te-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
							],
							'separator'  => 'before',
						),
					),
				),
                
                //Text Style
				array(
					'name' => 'section_style_name',
					'label' => esc_html__('Designation', 'dailyfit' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'controls' => array(
						array(
							'name' => 'name_color',
							'label' => esc_html__('Name Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .te-designation' => 'color: {{VALUE}} !important;',
							],
						),
						array(
                            'name' => 'name_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-designation',
                        ),
					),
				),
				
            ),
        ),
    ),
    dailyfit_get_class_widget_path()
);