<?php
//Register Counter Widget
 exp_add_custom_widget(
    array(
        'name' => 'skills',
        'title' => esc_html__('Dailyfit Skills', 'dailyfit'),
        'icon' => 'eicon-counter-circle',
        'categories' => array('exptheme-core'),
        'scripts' => array(
            'exp-counter',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dailyfit' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/skills/layout1.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'dailyfit'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(						
                        array(
							'name' => 'counter_stop',
							'label' => esc_html__('Counter Stop Value', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            'dynamic'     => [
                                'active' => true,
                            ],
                            'default' => esc_html__( '85', 'dailyfit' ),
						),
                        array(
							'name' => 'alphabet_letter',
							'label' => esc_html__('Alphabet Letter', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            'dynamic'     => [
                                'active' => true,
                            ],
                            'default' => esc_html__( '%', 'dailyfit' ),
						),
                        array(
							'name' => 'block_title',
							'label' => esc_html__('Title', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            'dynamic'     => [
                                'active' => true,
                            ],
						),                        						
					),
				),
                
                array(
                    'name' => 'section_style_title',
                    'label' => esc_html__('Bar Title Style', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .skills .skill-item .skill-header .skill-title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_typography',
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .skills .skill-item .skill-header .skill-title',
                        ),
                    ),
                ),
                                
                array(
                    'name' => 'section_number',
                    'label' => esc_html__('Bar Counter Style', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(                        
                        array(
                            'name' => 'number_color',
                            'label' => esc_html__('Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .skills .skill-item .skill-header .skill-percentage' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'number_typography',
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .skills .skill-item .skill-header .skill-percentage',
                        ),
                        
                    ),
                ),
                
                array(
                    'name' => 'section_alpha',
                    'label' => esc_html__('Skill Bar Style', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'alpha_bg_color',
                            'label' => esc_html__('Background Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .skills .skill-item .skill-bar .bar-inner' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'progress_bar_dot_color',
                            'label' => esc_html__('Background Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .skills .skill-item .skill-bar .bar-inner .bar:before' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'progress_bar_dot_border_color',
                            'label' => esc_html__('Progress Bar Dot Border Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .skills .skill-item .skill-bar .bar-inner .bar:before' => 'border-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'progress_bar_fill_color',
                            'label' => esc_html__('Progress Bar Fill Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .skills .skill-item .skill-bar .bar-inner .bar' => 'border-color: {{VALUE}};',
                            ],
                        ),
                        
                    ),
                ),
                
                dailyfit_widget_animation_settings(),
            ),
        ),
    ),
    dailyfit_get_class_widget_path()
);