<?php
$menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
$dailyfit_menus = array(
    '' => esc_html__('Default', 'dailyfit')
);
if ( is_array( $menus ) && ! empty( $menus ) ) {
    foreach ( $menus as $value ) {
        if ( is_object( $value ) && isset( $value->name, $value->slug ) ) {
            $dailyfit_menus[ $value->slug ] = $value->name;
        }
    }
} else {
    $dailyfit_menus = '';
}
exp_add_custom_widget(
    array(
        'name' => 'menu',
        'title' => esc_html__('Expert Nav Menu', 'dailyfit'),
        'icon' => 'eicon-nav-menu',
        'categories' => array('category_dailyfit_header'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'dailyfit'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'menu',
                            'label' => esc_html__('Select Menu', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => $dailyfit_menus,
                        ),
                    ),
                ),
                array(
                    'name' => 'style_menu_section',
                    'label' => esc_html__('Menu Parents', 'dailyfit'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'text_color',
                            'label' => esc_html__('Text Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .main-navigation ul > li > a' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'text_hover_color',
                            'label' => esc_html__('Color Hover', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .main-navigation ul > li > a:hover, 
                                 {{WRAPPER}} .main-navigation > ul > li.dropdown > a:hover:after,
                                 {{WRAPPER}} .main-navigation > ul > li.menu-item-has-children > a:hover:after,
                                 {{WRAPPER}} .main-navigation > ul > li > a.mPS2id-highlight' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'menu_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .main-navigation ul, {{WRAPPER}} .elementor-icon-list-text',
                        ),
                        array(
                            'name' => 'menu_padding',
                            'label' => esc_html__('Padding', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', 'em', '%', 'rem' ],
                            'selectors' => [
                                '{{WRAPPER}} .main-navigation > ul > li > a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'is_arrow',
                            'label' => esc_html__('Arrows', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                        ),
                        array(
                            'name' => 'arrow_color',
                            'label' => esc_html__('Arrow Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .main-navigation > ul > li.dropdown > a:after,
                                {{WRAPPER}} .main-navigation > ul > li.menu-item-has-children > a:after' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'is_arrow' => ['yes'],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'style_smenu_section',
                    'label' => esc_html__('Dropdown Menus', 'dailyfit'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'smenu_width',
                            'label' => esc_html__('Width', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'range' => [
                                'px' => [
                                    'min' => 200,
                                    'max' => 500,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .main-navigation ul li ul' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                        ),
						array(
                            'name' => 'smenu_padding',
                            'label' => esc_html__('Padding', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', 'em', '%', 'rem' ],
                            'selectors' => [
                                '{{WRAPPER}}  .main-navigation ul li ul' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'bg_s_color',
                            'label' => esc_html__('Background Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .main-navigation ul ul' => 'background: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'text_s_color',
                            'label' => esc_html__('Text Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .main-navigation ul ul a, 
                                 {{WRAPPER}} .main-navigation ul ul > li.menu-item-has-children > a:after,
                                 {{WRAPPER}} .main-navigation ul ul > li.dropdown > a:after' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'text_s_hover_color',
                            'label' => esc_html__('Text Hover Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .main-navigation ul ul a:hover, 
                                 {{WRAPPER}} .main-navigation ul ul li.dropdown > a:hover:after,
                                 {{WRAPPER}} .main-navigation ul ul li.menu-item-has-children > a:hover:after, 
                                 {{WRAPPER}} .elementor-icon-list-text:hover, 
                                 {{WRAPPER}} ul li h5' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'smenu_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'selector' => '{{WRAPPER}} .main-navigation ul ul a, {{WRAPPER}} .elementor-icon-list-text',
                        ),
                    ),
                ),


                array(
                    'name' => 'style_scmenu_section',
                    'label' => esc_html__('Menu Scroll', 'dailyfit'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'text_sccolor',
                            'label' => esc_html__('Text Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .scrolled > ul > li > a' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'text_hover_sccolor',
                            'label' => esc_html__('Text Hover Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .scrolled > ul > li > a:hover, 
                                 {{WRAPPER}} .scrolled > ul > li.dropdown > a:after,
                                 {{WRAPPER}} .scrolled > ul > li.dropdown > a:hover:after
                                 {{WRAPPER}} .scrolled > ul > li.menu-item-has-children > a:after, 
                                 {{WRAPPER}} .scrolled > ul > li.menu-item-has-children > a:hover:after' => 'color: {{VALUE}};',
                            ],
                        ),
                    ),
                ),
            ),
        ),
    ),
    dailyfit_get_class_widget_path()
);