<?php
exp_add_custom_widget(
    array(
        'name' => 'link_scroll_section',
        'title' => esc_html__('Dailyfit Link Scroll', 'dailyfit'),
        'icon' => 'eicon-editor-link',
        'categories' => array('exptheme-core'),
        'params' => array(
            'sections' => array(
                
                array(
                    'name' => 'tab_layout',
                    'label' => esc_html__('Layout', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dailyfit' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/scroll/onepage-styleone.png'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/scroll/onepage-styletwo.png'
                                ],
                            ],
                        ),
                    ),
                ),
                
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'dailyfit'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'items',
                            'label' => esc_html__('Items', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'text',
                                    'label' => esc_html__('Text', 'dailyfit'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'link',
                                    'label' => esc_html__('Link', 'dailyfit'),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'exp_icon',
                                    'label' => esc_html__('Icon', 'dailyfit' ),
                                    'type' => \Elementor\Controls_Manager::ICONS,
                                    'fa4compatibility' => 'icon',
                                    'description' => 'Work only in Layout Style Two',
                                ),
                                array(
                                    'name' => 'offset',
                                    'label' => esc_html__('Offset Top', 'dailyfit'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                    'description' => 'Enter number. Default 0',
                                ),
                            ),
                            'title_field' => '{{{ text }}}',
                        ),
                        array(
                            'name' => 'position',
                            'label' => esc_html__('Position', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'ps-right-center' => 'Right Center',
                                'ps-left-center' => 'Left Center',
                            ],
                            'default' => 'ps-right-center',
                        ),
                        array(
                            'name' => 'hidden_on_mobile',
                            'label' => esc_html__('Hidden on Mobile', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'no' => 'No',
                                'yes' => 'Yes',
                            ],
                            'default' => 'no',
                        ),
					),
				),
				
				//Dot Style
				array(
					'name' => 'section_style_dot',
					'label' => esc_html__('Dot', 'dailyfit' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'controls' => array(
						array(
							'name' => 'dot_color',
							'label' => esc_html__('Dot Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .exp-link-scroll1 .exp--item a.exp-onepage-active::after' => 'background-color: {{VALUE}};',
								'{{WRAPPER}} .exp-link-scroll2 .exp--item a.exp-onepage-active::after' => 'background-color: {{VALUE}};',
							],
						),
						array(
							'name' => 'dot_size',
							'label' => __( 'Dot Size', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::SLIDER,
							'size_units' => [ 'px' ],
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 500,
								],
							],
							'selectors' => [
								'{{WRAPPER}} .exp-link-scroll1 .exp--item a::after' => 'width: {{SIZE}}{{UNIT}};',
								'{{WRAPPER}} .exp-link-scroll2 .exp--item a::after' => 'width: {{SIZE}}{{UNIT}};'
							],
						),
						array(
							'name' => 'dot_height',
							'label' => __( 'Dot Height', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::SLIDER,
							'size_units' => [ 'px' ],
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 500,
								],
							],
							'selectors' => [
								'{{WRAPPER}} .exp-link-scroll1 .exp--item a::after' => 'height: {{SIZE}}{{UNIT}};',
								'{{WRAPPER}} .exp-link-scroll2 .exp--item a::after' => 'height: {{SIZE}}{{UNIT}};'
							],
						),
						array(
							'name' => 'dot_border_type',
							'label' => esc_html__( 'Border Type', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::SELECT,
							'options' => [
								'' => esc_html__( 'None', 'dailyfit' ),
								'solid' => esc_html__( 'Solid', 'dailyfit' ),
								'double' => esc_html__( 'Double', 'dailyfit' ),
								'dotted' => esc_html__( 'Dotted', 'dailyfit' ),
								'dashed' => esc_html__( 'Dashed', 'dailyfit' ),
								'groove' => esc_html__( 'Groove', 'dailyfit' ),
							],
							'selectors' => [
								'{{WRAPPER}} .exp-link-scroll1 .exp--item a::before' => 'border-style: {{VALUE}} !important;',
								'{{WRAPPER}} .exp-link-scroll2 .exp--item a::before' => 'border-style: {{VALUE}} !important;'
							],
						),
						array(
							'name' => 'dot_border_width',
							'label' => esc_html__( 'Border Width', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::DIMENSIONS,
							'selectors' => [
								'{{WRAPPER}} .exp-link-scroll1 .exp--item a::before' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
								'{{WRAPPER}} .exp-link-scroll2 .exp--item a::before' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
							],
							'condition' => [
								'dot_border_type!' => '',
							],
							'responsive' => true,
						),
						array(
							'name' => 'dot_border_color',
							'label' => esc_html__( 'Border Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'default' => '',
							'selectors' => [
								'{{WRAPPER}} .exp-link-scroll1 .exp--item a::before' => 'border-color: {{VALUE}} !important;',
								'{{WRAPPER}} .exp-link-scroll2 .exp--item a::before' => 'border-color: {{VALUE}} !important;',
							],
							'condition' => [
								'dot_border_type!' => '',
							],
						),
						array(
							'name' => 'dot_radius',
							'label' => __( 'Border Radius', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%' ],
							'selectors' => [
								'{{WRAPPER}} .exp-link-scroll1 .exp--item a::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .exp-link-scroll2 .exp--item a::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						),
					),
				),
				
				//Dot Title Style
				array(
					'name' => 'section_style_title',
					'label' => esc_html__('Title', 'dailyfit' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'controls' => array(
						array(
							'name' => 'title_bg_color',
							'label' => esc_html__('Title BG Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .exp-link-scroll1 .exp--item a span' => 'background-color: {{VALUE}};',
								'{{WRAPPER}} .exp-link-scroll2 .exp--item a span' => 'background-color: {{VALUE}};',
							],
						),
						array(
							'name' => 'arrow_shape_color',
							'label' => esc_html__('Arrow Shape Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .exp-link-scroll1 .exp--item a span:before' => 'border-color: transparent transparent transparent {{VALUE}} !important;',
								'{{WRAPPER}} .exp-link-scroll2 .exp--item a span:before' => 'border-color: transparent transparent transparent {{VALUE}} !important;',
							],
						),
						array(
							'name' => 'title_color',
							'label' => esc_html__('Title Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .exp-link-scroll1 .exp--item a span' => 'color: {{VALUE}};',
								'{{WRAPPER}} .exp-link-scroll2 .exp--item a span' => 'color: {{VALUE}};',
							],
						),
						array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .exp-link-scroll1 .exp--item a span',
                        ),
						array(
							'name' => 'title_padding',
							'label' => __( 'Padding', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .exp-link-scroll1 .exp--item a span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .exp-link-scroll2 .exp--item a span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
						array(
							'name' => 'title_border_type',
							'label' => esc_html__( 'Border Type', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::SELECT,
							'options' => [
								'' => esc_html__( 'None', 'dailyfit' ),
								'solid' => esc_html__( 'Solid', 'dailyfit' ),
								'double' => esc_html__( 'Double', 'dailyfit' ),
								'dotted' => esc_html__( 'Dotted', 'dailyfit' ),
								'dashed' => esc_html__( 'Dashed', 'dailyfit' ),
								'groove' => esc_html__( 'Groove', 'dailyfit' ),
							],
							'selectors' => [
								'{{WRAPPER}} .exp-link-scroll1 .exp--item a span' => 'border-style: {{VALUE}} !important;',
								'{{WRAPPER}} .exp-link-scroll2 .exp--item a span' => 'border-style: {{VALUE}} !important;',
							],
						),
						array(
							'name' => 'title_border_width',
							'label' => esc_html__( 'Border Width', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::DIMENSIONS,
							'selectors' => [
								'{{WRAPPER}} .exp-link-scroll1 .exp--item a span' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
								'{{WRAPPER}} .exp-link-scroll2 .exp--item a span' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
							],
							'condition' => [
								'title_border_type!' => '',
							],
							'responsive' => true,
						),
						array(
							'name' => 'title_border_color',
							'label' => esc_html__( 'Border Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'default' => '',
							'selectors' => [
								'{{WRAPPER}} .exp-link-scroll1 .exp--item a span' => 'border-color: {{VALUE}} !important;',
								'{{WRAPPER}} .exp-link-scroll2 .exp--item a span' => 'border-color: {{VALUE}} !important;',
							],
							'condition' => [
								'title_border_type!' => '',
							],
						),
						array(
							'name' => 'title_box_radius',
							'label' => __( 'Border Radius', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%' ],
							'selectors' => [
								'{{WRAPPER}} .exp-link-scroll1 .exp--item a span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .exp-link-scroll2 .exp--item a span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						),
					),
				),
				
				dailyfit_widget_animation_settings(),
            ),
		 ),
    ),
    dailyfit_get_class_widget_path()
);