<?php
exp_add_custom_widget(
    array(
        'name' => 'icon_box',
        'title' => esc_html__('Dailyfit Icon Box', 'dailyfit' ),
        'icon' => 'eicon-posts-ticker',
        'categories' => array('exptheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_layout',
                    'label' => esc_html__('Layout', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dailyfit' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/icon_box/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/icon_box/layout2.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_source',
                    'label' => esc_html__('Source', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                       array(
							'name' => 'icon_type',
							'label' => esc_html__('Icon Type', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::SELECT,
							'options' => [
								'icon' => 'Icon',
								'image' => 'Image',
							],
							'default' => 'icon',
						),
						array(
							'name' => 'exp_icon',
							'label' => esc_html__('Icon', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::ICONS,
							'fa4compatibility' => 'icon',
							'condition' => [
								'icon_type' => 'icon',
							],
						),
						array(
							'name' => 'icon_image',
							'label' => esc_html__( 'Icon Image', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::MEDIA,
							'description' => esc_html__('Select image icon.', 'dailyfit'),
							'condition' => [
								'icon_type' => 'image',
							],
						),
						array(
							'name' => 'title',
							'label' => esc_html__( 'Title', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::TEXT,
							'label_block' => true,
							'default' => esc_html__( '40 Courses a Week', 'dailyfit' ),
						),
						array(
							'name' => 'text',
							'label' => esc_html__( 'Text', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::TEXTAREA,
							'label_block' => true,
							'default' => esc_html__( 'Enter The Description', 'dailyfit' ),
						),
					),
                ),
                
				//Style
				array(
                    'name' => 'section_style',
                    'label' => esc_html__('Style', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
						array(
                            'name' => 'icon_bg_color',
							'label' => esc_html__( 'Icon BG Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .te-icons' => 'background-color: {{VALUE}};',
							],
						),
						array(
                            'name' => 'icon_color',
							'label' => esc_html__( 'Icon Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .te-icons i' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .te-icons span' => 'color: {{VALUE}};',
								'{{WRAPPER}} .te-icons svg' => 'fill: {{VALUE}};',
								'{{WRAPPER}} .te-icons svg g' => 'fill: {{VALUE}};',
							],
						),
						array(
                            'name' => 'icon__margin',
							'label'      => esc_html__( 'Icon Margin', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .te-icons' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
						array(
                            'name' => 'icon_padding',
							'label'      => esc_html__( 'Icon Padding', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .te-icons' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
						array(
                            'name' => 'icon_font_size',
							'label' => __( 'icon Font Size', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::SLIDER,
							'size_units' => [ 'px' ],
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 500,
								],
							],
							'selectors' => [
								'{{WRAPPER}} .te-icons i' => 'font-size: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .te-icons span' => 'font-size: {{SIZE}}{{UNIT}};',
								'{{WRAPPER}} .te-icons svg' => 'width: {{SIZE}}{{UNIT}};',
								'{{WRAPPER}} .te-icons img' => 'width: {{SIZE}}{{UNIT}};',
							],
						),
					),
                ),                
                array(
                    'name' => 'section_style_title',
                    'label' => esc_html__('Title', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .te-title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_typography',
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-title',
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_text',
                    'label' => esc_html__('Text', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'text_color',
                            'label' => esc_html__('Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .te-text' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'text_typography',
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-text',
                        ),
                    ),
                ),
                
			),
        ),
    ),
    dailyfit_get_class_widget_path()
);