<?php
exp_add_custom_widget(
    array(
        'name' => 'heading',
        'title' => esc_html__('Dailyfit Heading', 'dailyfit' ),
        'icon' => 'eicon-heading',
        'categories' => array('exptheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_layout',
                    'label' => esc_html__('Layout', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dailyfit' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/heading/layout1.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
				
				array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                    	//subTitle Section
						array(
                            'name' => 'subtitle_show',
                            'label'        => esc_html__( 'Enable Sub Title', 'dailyfit' ),
							'type'         => \Elementor\Controls_Manager::SWITCHER,
							'label_on'     => esc_html__( 'On', 'dailyfit' ),
							'label_off'    => esc_html__( 'Off', 'dailyfit' ),
							'return_value' => 'yes',
							'default'      => 'no',
						),
						array(
                            'name' => 'subtitle',
                            'label' => esc_html__( 'Sub Title', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::TEXTAREA,
							'label_block' => true,
							'placeholder' => esc_html__( 'Enter your sub title', 'dailyfit' ),
							'default' => esc_html__( 'Add Your Sub Title Here', 'dailyfit' ),
							'condition'   => [ 
								'subtitle_show' => 'yes' 
							]
                        ),
                    	
                    	//Title Section
						array(
                            'name' => 'title_show',
                            'label'        => esc_html__( 'Enable Title', 'dailyfit' ),
							'type'         => \Elementor\Controls_Manager::SWITCHER,
							'label_on'     => esc_html__( 'On', 'dailyfit' ),
							'label_off'    => esc_html__( 'Off', 'dailyfit' ),
							'return_value' => 'yes',
							'default'      => 'no',
						),
						array(
                            'name' => 'title',
                            'label' => esc_html__( 'Title', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::TEXTAREA,
							'label_block' => true,
							'placeholder' => esc_html__( 'Enter your title', 'dailyfit' ),
							'default' => esc_html__( 'Add Your Heading Text Here', 'dailyfit' ),
							'condition'   => [ 
								'title_show' => 'yes' 
							]
                        ),
                        
						
						//Text Section
						array(
                            'name' => 'text_show',
                            'label'        => esc_html__( 'Enable Text', 'dailyfit' ),
							'type'         => \Elementor\Controls_Manager::SWITCHER,
							'label_on'     => esc_html__( 'On', 'dailyfit' ),
							'label_off'    => esc_html__( 'Off', 'dailyfit' ),
							'return_value' => 'yes',
							'default'      => 'no',
						),
						array(
                            'name' => 'text',
                            'label' => esc_html__( 'Text', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::TEXTAREA,
							'label_block' => true,
							'placeholder' => esc_html__( 'Enter your Text', 'dailyfit' ),
							'default' => esc_html__( 'There are many variations of passages of lorem ipsum available the majority have suffered alteration in some form by injected humour. Duis aute irure dolor lipsum is simply free text available in the local markets in reprehenderit.', 'dailyfit' ),
							'condition'   => [ 
								'text_show' => 'yes' 
							]
                        ),
						
						//Align
                        array(
                          'name' => 'align',
                            'label' => esc_html__( 'Alignment', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::CHOOSE,
                            'control_type' => 'responsive',
                            'options' => [
                                'left' => [
                                    'title' => esc_html__( 'Left', 'dailyfit' ),
                                    'icon' => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'dailyfit' ),
                                    'icon' => 'eicon-text-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'dailyfit' ),
                                    'icon' => 'eicon-text-align-right',
                                ],
                            ],
                            'prefix_class' => 'elementor-align-',
                            'default' => 'left',
                            'selectors' => [
                                '{{WRAPPER}} .main-title-section' => 'text-align: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'h_width',
                            'label' => esc_html__('Max Width', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .main-title-section' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                    ),
                ),
				
				
				//subTitle Style
                array(
                    'name' => 'section_style_subtitle',
                    'label' => esc_html__('Sub Title', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'subtitle_color',
                            'label' => esc_html__('Sub Title Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .te-subtitle' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'subtitle_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-subtitle',
                        ),
                        array(
                            'name'         => 'subtitle_box_shadow',
                            'label' => esc_html__( 'Sub Title Shadow', 'dailyfit' ),
                            'type'         => \Elementor\Group_Control_Text_Shadow::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .te-subtitle'
                        ),
                        array(
                            'name' => 'subtitle_space_bottom',
                            'label'      => esc_html__( 'Margin', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
                            'selectors' => [
                                '{{WRAPPER}} .te-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                            ],
                            'separator' => 'after',
                        ),
                        array(
                            'name' => 'subtitle_space_paddings',
                            'label'      => esc_html__( 'Padding', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
                            'selectors' => [
                                '{{WRAPPER}} .te-subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                            ],
                            'separator' => 'after',
                        ),
                        array(
                            'name'         => 'subtitle_text_stroke',
                            'type'         => \Elementor\Group_Control_Text_Stroke::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .te-subtitle'
                        ),
                        array(
                            'name'         => 'subtitle_shadow',
                            'label' => esc_html__( 'Title Shadow', 'dailyfit' ),
                            'type'         => \Elementor\Group_Control_Text_Shadow::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .te-subtitle'
                        ),
                    ),
                ),
								
				//Title Style
                array(
                    'name' => 'section_style_title',
                    'label' => esc_html__('Title', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .te-title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-title',
                        ),
                        array(
                            'name' => 'title_space_bottom',
                            'label'      => esc_html__( 'Margin', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
                            'selectors' => [
                                '{{WRAPPER}} .te-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                            ],
                            'separator' => 'after',
                        ),
                        array(
                            'name' => 'title_space_paddings',
                            'label'      => esc_html__( 'Padding', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
                            'selectors' => [
                                '{{WRAPPER}} .te-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                            ],
                            'separator' => 'after',
                        ),
                        array(
                            'name'         => 'title_text_stroke',
                            'type'         => \Elementor\Group_Control_Text_Stroke::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .te-title'
                        ),
                        array(
                            'name'         => 'title_shadow',
                            'label' => esc_html__( 'Title Shadow', 'dailyfit' ),
                            'type'         => \Elementor\Group_Control_Text_Shadow::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .te-title'
                        ),
                    ),
                ),
				
                
                //Text Style
                array(
                    'name' => 'section_style_text',
                    'label' => esc_html__('Text', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'text_color',
                            'label' => esc_html__('Text Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .te-text' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'text_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-text',
                        ),
                        array(
                            'name'         => 'text_box_shadow',
                            'label' => esc_html__( 'Text Shadow', 'dailyfit' ),
                            'type'         => \Elementor\Group_Control_Text_Shadow::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .te-text'
                        ),
                        array(
                            'name' => 'text_space_bottom',
                            'label'      => esc_html__( 'Margin', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
                            'selectors' => [
                                '{{WRAPPER}} .te-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                            ],
                            'separator' => 'after',
                        ),
                        array(
                            'name'         => 'text_text_stroke',
                            'type'         => \Elementor\Group_Control_Text_Stroke::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .te-text'
                        ),
                        array(
                            'name'         => 'text_shadow',
                            'label' => esc_html__( 'Title Shadow', 'dailyfit' ),
                            'type'         => \Elementor\Group_Control_Text_Shadow::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .te-text'
                        ),
                    ),
                ),
               
            ),
        ),
    ),
    dailyfit_get_class_widget_path()
);