<?php
exp_add_custom_widget(
    array(
        'name' => 'faqs',
        'title' => esc_html__('Dailyfit Faqs', 'dailyfit' ),
        'icon' => 'eicon-accordion',
        'categories' => array('exptheme-core'),
        'scripts' => array(
            'exp-faqs'
        ),
        'params' => array(
            'sections' => array(
                
                array(
                    'name' => 'tab_layout',
                    'label' => esc_html__('Layout', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dailyfit' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/faqs/layout1.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'active',
                            'label' => esc_html__('Active', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'separator' => 'after',
                            'default' => '1',
                        ),
                        array(
                            'name' => 'accordion',
                            'label' => esc_html__('Accordion', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'title',
                                    'label' => esc_html__('Title', 'dailyfit' ),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'desc',
                                    'label' => esc_html__('Content', 'dailyfit' ),
                                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                                    'rows' => 10,
                                ),
                            ),
                        ),
                    ),
                ),
                
                array(
                    'name' => 'section_style_extra',
                    'label' => esc_html__('Extra', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'box_color',
                            'label' => esc_html__('Box color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .accordion-box .block' => 'background-color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
							'name' => 'box_margin',
							'label' => __( 'Margin', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .accordion-box .block' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
						array(
							'name' => 'box_padding',
							'label' => __( 'Padding', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .accordion-box .block' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
                        array(
							'name' => 'box_border_type',
							'label' => esc_html__( 'Border Type', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::SELECT,
							'options' => [
								'' => esc_html__( 'None', 'dailyfit' ),
								'solid' => esc_html__( 'Solid', 'dailyfit' ),
								'double' => esc_html__( 'Double', 'dailyfit' ),
								'dotted' => esc_html__( 'Dotted', 'dailyfit' ),
								'dashed' => esc_html__( 'Dashed', 'dailyfit' ),
								'groove' => esc_html__( 'Groove', 'dailyfit' ),
							],
							'selectors' => [
								'{{WRAPPER}} .accordion-box .block' => 'border-style: {{VALUE}} !important;',
							],
						),
						array(
							'name' => 'box_border_width',
							'label' => esc_html__( 'Border Width', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::DIMENSIONS,
							'selectors' => [
								'{{WRAPPER}} .accordion-box .block' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
							],
							'condition' => [
								'box_border_type!' => '',
							],
							'responsive' => true,
						),
						array(
							'name' => 'box_border_color',
							'label' => esc_html__( 'Border Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'default' => '',
							'selectors' => [
								'{{WRAPPER}} .accordion-box .block' => 'border-color: {{VALUE}} !important;',
							],
							'condition' => [
								'box_border_type!' => '',
							],
						),
						array(
							'name' => 'box_radius',
							'label' => __( 'Border Radius', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%' ],
							'selectors' => [
								'{{WRAPPER}} .accordion-box .block' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						),
                    ),
                ),
                //Plus Icon Style
                array(
                    'name' => 'section_style_plus_icon',
                    'label' => esc_html__('Plus Icon', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'plus_icon_bg_color',
                            'label' => esc_html__('Background color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .accordion-box .block .icon-outer' => 'background-color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'plus_icon_color',
                            'label' => esc_html__('Icon color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [ 
                                '{{WRAPPER}} .accordion-box .block .icon-outer .icon' => 'color: {{VALUE}} !important;;',
                            ],
                        ),
                        array(
                            'name' => 'plus_icon_bgcolor',
                            'label' => esc_html__('Icon Background Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [ 
                                '{{WRAPPER}} .accordion-box .block .icon-outer .icon' => 'background-color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'plus_icon_active_color',
                            'label' => esc_html__('Active Icon color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [ 
                                '{{WRAPPER}} .accordion-box .block .acc-btn.active .icon-outer .icon' => 'color: {{VALUE}} !important;;',
                            ],
                        ),
                        array(
                            'name' => 'plus_icon_active_bgcolor',
                            'label' => esc_html__('Active Icon Background Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [ 
                                '{{WRAPPER}} .accordion-box .block .acc-btn.active .icon-outer .icon-minus' => 'background-color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'plus_icon_font_size',
							'label' => __( 'icon Font Size', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::SLIDER,
							'size_units' => [ 'px' ],
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 500,
								],
							],
							'selectors' => [
								'{{WRAPPER}} .accordion-box .block .icon-outer .icon' => 'font-size: {{SIZE}}{{UNIT}} !important;;',
							],
						),
                        array(
							'name' => 'plus_icon_border_type',
							'label' => esc_html__( 'Border Type', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::SELECT,
							'options' => [
								'' => esc_html__( 'None', 'dailyfit' ),
								'solid' => esc_html__( 'Solid', 'dailyfit' ),
								'double' => esc_html__( 'Double', 'dailyfit' ),
								'dotted' => esc_html__( 'Dotted', 'dailyfit' ),
								'dashed' => esc_html__( 'Dashed', 'dailyfit' ),
								'groove' => esc_html__( 'Groove', 'dailyfit' ),
							],
							'selectors' => [
								'{{WRAPPER}} .accordion-box .block .icon-outer' => 'border-style: {{VALUE}} !important;',
							],
						),
						array(
							'name' => 'plus_icon_border_width',
							'label' => esc_html__( 'Border Width', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::DIMENSIONS,
							'selectors' => [
								'{{WRAPPER}} .accordion-box .block .icon-outer' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
							],
							'condition' => [
								'plus_icon_border_type!' => '',
							],
							'responsive' => true,
						),
						array(
							'name' => 'plus_icon_border_color',
							'label' => esc_html__( 'Border Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'default' => '',
							'selectors' => [
								'{{WRAPPER}} .accordion-box .block .icon-outer' => 'border-color: {{VALUE}} !important;',
							],
							'condition' => [
								'plus_icon_border_type!' => '',
							],
						),
						array(
							'name' => 'plus_icon_radius',
							'label' => __( 'Border Radius', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%' ],
							'selectors' => [
								'{{WRAPPER}} .accordion-box .block .icon-outer' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						),
                    ),
                ),
                
                //Title Style
				array(
					'name' => 'section_style_title',
					'label' => esc_html__('Title', 'dailyfit' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'controls' => array(
						array(
							'name' => 'title_color',
							'label' => esc_html__('Title Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .accordion-box .block .acc-btn' => 'color: {{VALUE}} !important;',
                                '{{WRAPPER}} .te-title' => 'color: {{VALUE}} !important;',
							],
						),
						array(
							'name' => 'title_active_color',
							'label' => esc_html__('Active Title Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .accordion-box .block .acc-btn.active' => 'color: {{VALUE}} !important;',
							],
						),
						array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .accordion-box .block .acc-btn,
                                                       .te-title',
                        ),
                        array(
							'name' => 'title_margin',
							'label' => __( 'Margin', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .accordion-box .block .acc-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .te-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
						array(
							'name' => 'title_padding',
							'label' => __( 'Padding', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .accordion-box .block .acc-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .te-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
					),
				),
				
				
				//Text Style
				array(
					'name' => 'section_style_text',
					'label' => esc_html__('Text', 'dailyfit' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'controls' => array(
						array(
							'name' => 'text_color',
							'label' => esc_html__('Text Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .te-text' => 'color: {{VALUE}} !important;',
							],
						),
						array(
							'name' => 'active-text_color',
							'label' => esc_html__('Active Text Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .accordion-box .block .acc-content.current .te-text' => 'color: {{VALUE}} !important;',
							],
						),
						array(
                            'name' => 'text_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-text',
                        ),
                        array(
							'name' => 'text_margin',
							'label' => __( 'Margin', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .te-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
						array(
							'name' => 'text_padding',
							'label' => __( 'Padding', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .te-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
					),
				),
                
                dailyfit_widget_animation_settings(),
            ),
        ),
    ),
    dailyfit_get_class_widget_path()
);