<?php
exp_add_custom_widget(
    array(
        'name' => 'coming_soon',
        'title' => esc_html__('Dailyfit Coming Soon', 'dailyfit' ),
        'icon' => 'eicon-posts-ticker',
        'categories' => array('exptheme-core'),
        'scripts' => [
            'dailyfit-coming_counter'
        ],
		'params' => array(
            'sections' => array(
                array(
                    'name' => 'tab_layout',
                    'label' => esc_html__('Layout', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dailyfit' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/coming-soon/layout1.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_source',
                    'label' => esc_html__('Source', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                       	array(
                            'name' => 'logo_img',
							'label' => __( 'Logo Image', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::MEDIA,
						),
						array(
                            'name' => 'counter_value',
							'label'       => __( 'Counter Value', 'dailyfit' ),
							'type'        => \Elementor\Controls_Manager::TEXT,
							'dynamic'     => [
								'active' => true,
							],
							'placeholder' => __( 'Enter your Counter Value', 'dailyfit' ),
							'default' => esc_html__('2026-12-31', 'dailyfit'),
						),
						
						//Title
						array(
                            'name' => 'title',
                            'label' => esc_html__( 'Title', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::TEXTAREA,
							'label_block' => true,
							'default' => esc_html__( 'Our Website is under construction.', 'dailyfit' ),
						),
						
						//Text
						array(
                            'name' => 'text',
                            'label' => esc_html__( 'Text', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::TEXTAREA,
							'label_block' => true,
							'default' => esc_html__( 'stay tuned for something amazing! Subscribe to be notified', 'dailyfit' ),
						),
						//Switcher
						array(
                            'name' => 'show_search_form',
                            'label'        => esc_html__( 'Enable Search Form', 'dailyfit' ),
							'type'         => \Elementor\Controls_Manager::SWITCHER,
							'label_on'     => esc_html__( 'On', 'dailyfit' ),
							'label_off'    => esc_html__( 'Off', 'dailyfit' ),
							'return_value' => 'yes',
							'default'      => 'no',
						),
                        //Text
						array(
                            'name' => 'form_id',
                            'label' => esc_html__( 'Form Url', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::TEXT,
							'label_block' => true,
                            'condition'   => [
                                    'show_search_form' => 'yes',  
                            ],
						),
						//Social Icons
						array(
                            'name' => 'social_icon',
                            'label' => esc_html__('Social Icon', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
							'controls' => array(
								array(
									'name' => 'social_icons',
									'label' => esc_html__('Icon', 'dailyfit' ),
									'type' => \Elementor\Controls_Manager::ICONS,
									'fa4compatibility' => 'icon',
								),
								array(
									'name' => 'social_link',
									'label' => esc_html__('Link', 'dailyfit' ),
									'type' => \Elementor\Controls_Manager::URL,
									'default' => [
										'url' => '#',
									],
								),
							),
						),
						
					),
				),
				
				
				
				//Title Style
                array(
                    'name' => 'section_style_title',
                    'label' => esc_html__('Title', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .te-title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-title',
                        ),
                        
                    ),
                ),
                				
                //Text Style
                array(
                    'name' => 'section_style_text',
                    'label' => esc_html__('Text', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'text_color',
                            'label' => esc_html__('Text Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .te-text' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'text_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-text',
                        ),
                    ),
                ),
				
				
			),
        ),
    ),
    dailyfit_get_class_widget_path()
);