<?php

exp_add_custom_widget(
    array(
        'name' => 'calculate_bmi',
        'title' => esc_html__('Dailyfit Calculate BMI', 'dailyfit' ),
        'icon' => 'eicon-posts-ticker',
        'categories' => array('exptheme-core'),
        'scripts' => array(
            'exp-bmi',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dailyfit' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/calculate_bmi/bmi-layout1.png'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/calculate_bmi/bmi-layout2.png'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'dailyfit'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'bg_img',
                            'label' => esc_html__('Background Image', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                            'condition' => [ 'layout' => ['1'], ],
                        ),
                        array(
                            'name' => 'title',
                            'label' => esc_html__('Title', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('CALCULATE YOUR BODY MASS INDEX', 'dailyfit'),
                        ),
                        array(
                            'name' => 'subtitle',
                            'label' => esc_html__('Sub Title', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('CALCULATE BMI', 'dailyfit'),
                        ),
                        array(
                            'name' => 'btn_title',
                            'label' => esc_html__('Button Title', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('Calculate', 'dailyfit'),
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_display',
                    'label' => esc_html__('Display', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'show_title',
                            'label' => esc_html__('Show Title', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'label_on'     => esc_html__( 'On', 'dailyfit' ),
                            'label_off'    => esc_html__( 'Off', 'dailyfit' ),
                            'return_value' => 'yes',
                            'default'      => 'yes',
                        ),
                        array(
                            'name' => 'show_subtitle',
                            'label' => esc_html__('Show Sub Title', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'label_on'     => esc_html__( 'On', 'dailyfit' ),
                            'label_off'    => esc_html__( 'Off', 'dailyfit' ),
                            'return_value' => 'yes',
                            'default'      => 'yes',
                        ),
                        array(
                            'name' => 'show_height',
                            'label' => esc_html__('Show Height', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'label_on'     => esc_html__( 'On', 'dailyfit' ),
                            'label_off'    => esc_html__( 'Off', 'dailyfit' ),
                            'return_value' => 'yes',
                            'default'      => 'yes',
                        ),
                        array(
                            'name' => 'show_weight',
                            'label' => esc_html__('Show Weight', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'label_on'     => esc_html__( 'On', 'dailyfit' ),
                            'label_off'    => esc_html__( 'Off', 'dailyfit' ),
                            'return_value' => 'yes',
                            'default'      => 'yes',
                        ),
                        array(
                            'name' => 'show_age',
                            'label' => esc_html__('Show Age', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'label_on'     => esc_html__( 'On', 'dailyfit' ),
                            'label_off'    => esc_html__( 'Off', 'dailyfit' ),
                            'return_value' => 'yes',
                            'default'      => 'yes',
                        ),
                        array(
                            'name' => 'show_gender',
                            'label' => esc_html__('Show Gender', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'label_on'     => esc_html__( 'On', 'dailyfit' ),
                            'label_off'    => esc_html__( 'Off', 'dailyfit' ),
                            'return_value' => 'yes',
                            'default'      => 'yes',
                        ),
                        array(
                            'name' => 'show_activity',
                            'label' => esc_html__('Show Activity', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'label_on'     => esc_html__( 'On', 'dailyfit' ),
                            'label_off'    => esc_html__( 'Off', 'dailyfit' ),
                            'return_value' => 'yes',
                            'default'      => 'yes',
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_title',
                    'label' => esc_html__('Title', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .sec-title h2' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Title Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .sec-title h2',
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_subtitle',
                    'label' => esc_html__('Sub Title', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'subtitle_color',
                            'label' => esc_html__('Sub Title Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .sec-title .title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'subtitle_typography',
                            'label' => esc_html__('Sub Title Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .sec-title .title',
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_style_input',
                    'label' => esc_html__('Input Text', 'dailyfit'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'condition' => ['layout'      => ['1'] ],
                    'controls' => array(
                        array(
                            'name' => 'input_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .default-form.style-three .form-group input',
                        ),
                        array(
                            'name' => 'input_color',
                            'label' => esc_html__('Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .default-form.style-three input::placeholder' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'input_bg_color',
                            'label' => esc_html__('Background Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .default-form.style-three .form-group input' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'input_padding',
                            'label' => esc_html__('Padding Input', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .default-form.style-three .form-group input' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name' => 'input_border_radius',
                            'label' => esc_html__('Border Radius', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .default-form.style-three .form-group input' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name'         => 'input_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'dailyfit' ),
                            'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .default-form.style-three .form-group input'
                        ),
                        array(
                            'name' => 'border_type',
                            'label' => esc_html__( 'Border Type', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                '' => esc_html__( 'None', 'dailyfit' ),
                                'solid' => esc_html__( 'Solid', 'dailyfit' ),
                                'double' => esc_html__( 'Double', 'dailyfit' ),
                                'dotted' => esc_html__( 'Dotted', 'dailyfit' ),
                                'dashed' => esc_html__( 'Dashed', 'dailyfit' ),
                                'groove' => esc_html__( 'Groove', 'dailyfit' ),
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .default-form.style-three .form-group input' => 'border-style: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'border_width',
                            'label' => esc_html__( 'Border Width', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .default-form.style-three .form-group input' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                            ],
                            'condition' => [
                                'border_type!' => '',
                            ],
                            'responsive' => true,
                        ),
                        array(
                            'name' => 'border_color',
                            'label' => esc_html__( 'Border Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .default-form.style-three .form-group input' => 'border-color: {{VALUE}} !important;',
                            ],
                            'condition' => [
                                'border_type!' => '',
                            ],
                        ),
                        array(
                            'name' => 'input_height',
                            'label' => esc_html__('Input Height', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .default-form.style-three .form-group input' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_style_dropdown',
                    'label' => esc_html__('Dropdown', 'dailyfit'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'condition' => ['layout'      => ['1'] ],
                    'controls' => array(
                        array(
                            'name' => 'dropdown_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .default-form.style-three .form-group .ui-selectmenu-button.ui-button',
                        ),
                        array(
                            'name' => 'dropdown_color',
                            'label' => esc_html__('Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .default-form.style-three .form-group .ui-selectmenu-button.ui-button' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .form-group .ui-button .ui-icon:before' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'dropdown_bg_color',
                            'label' => esc_html__('Background Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .default-form.style-three .form-group .ui-selectmenu-button.ui-button' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'dropdown_padding',
                            'label' => esc_html__('Padding Input', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .form-group .ui-selectmenu-button.ui-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name' => 'dropdown_border_radius',
                            'label' => esc_html__('Border Radius', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .form-group .ui-selectmenu-button.ui-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name'         => 'dropdown_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'dailyfit' ),
                            'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .form-group .ui-selectmenu-button.ui-button'
                        ),
                        array(
                            'name' => 'dropdown_border_type',
                            'label' => esc_html__( 'Border Type', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                '' => esc_html__( 'None', 'dailyfit' ),
                                'solid' => esc_html__( 'Solid', 'dailyfit' ),
                                'double' => esc_html__( 'Double', 'dailyfit' ),
                                'dotted' => esc_html__( 'Dotted', 'dailyfit' ),
                                'dashed' => esc_html__( 'Dashed', 'dailyfit' ),
                                'groove' => esc_html__( 'Groove', 'dailyfit' ),
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .form-group .ui-selectmenu-button.ui-button' => 'border-style: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'dropdown_border_width',
                            'label' => esc_html__( 'Border Width', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .form-group .ui-selectmenu-button.ui-button' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                            ],
                            'condition' => [
                                'dropdown_border_type!' => '',
                            ],
                            'responsive' => true,
                        ),
                        array(
                            'name' => 'dropdown_border_color',
                            'label' => esc_html__( 'Border Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .form-group .ui-selectmenu-button.ui-button' => 'border-color: {{VALUE}} !important;',
                            ],
                            'condition' => [
                                'dropdown_border_type!' => '',
                            ],
                        ),
                        array(
                            'name' => 'dropdown_height',
                            'label' => esc_html__('Input Height', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 300,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .form-group .ui-selectmenu-button.ui-button' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'tab_style_button',
                    'label' => esc_html__('Button', 'dailyfit'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'button_typography',
                            'label' => esc_html__('Button Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .btn-style-two',
                        ),
                        array(
                            'name' => 'button_color',
                            'label' => esc_html__('Button Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-two' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'button_bg_color',
                            'label' => esc_html__('Button Background Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-two' => 'background-color: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'button_padding',
                            'label' => esc_html__('Padding', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-two' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name' => 'button_margin',
                            'label' => esc_html__('Margin', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-two' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name' => 'button_border_radius',
                            'label' => esc_html__('Border Radius', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-two' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name'         => 'button_box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'dailyfit' ),
                            'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .btn-style-two'
                        ),
                        array(
                            'name' => 'button_border_color',
                            'label' => esc_html__( 'Border Color', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .btn-two-outer:before' => 'border-color: {{VALUE}} !important;',
                                '{{WRAPPER}} .btn-two-outer:after' => 'border-color: {{VALUE}} !important;',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_button_hover',
                    'label' => esc_html__('Button Hover', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'button_bg_color_hover',
                            'label' => esc_html__('Button Background Color Hover', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-two:before' => 'border-bottom: 55px solid {{VALUE}};',
                                '{{WRAPPER}} .btn-style-two:after' => 'border-bottom: 55px solid {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'button_color_hover',
                            'label' => esc_html__('Button Color Hover', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .btn-style-two:hover' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'button_border_color_hover',
                            'label' => esc_html__( 'Border Color Hover', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .btn-two-outer:after' => 'border-color: {{VALUE}} !important;',
                            ],
                            'condition' => [
                                'button_border_type!' => '',
                            ],
                        ),
                    ),
                ),
            ),
        ),
    ),
    dailyfit_get_class_widget_path()
);