<?php

exp_add_custom_widget(
    array(
        'name' => 'banner_carousel',
        'title' => esc_html__('Dailyfit Banner Carousel', 'dailyfit'),
        'icon' => 'eicon-posts-ticker',
        'categories' => array('exptheme-core'),
        'scripts' => array(
            'swiper',
            'exp-swiper',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'dailyfit' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'dailyfit' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/banner_carousel/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'dailyfit' ),
                                    'image' => get_template_directory_uri() . '/elements/widgets/img-layout/banner_carousel/layout2.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'dailyfit'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(                        
                        
                        //Banner Carousel One
                        array(
                            'name' => 'banner_slide',
                            'label' => esc_html__('Banner Slide', 'dailyfit'),
                            'condition' => [ 'layout' => ['1'], ],
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'bg_image',
                                    'label' => esc_html__('Banner BG Image', 'dailyfit' ),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                ),  
                                array(
                                    'name' => 'pattern_img',
                                    'label' => esc_html__('Banner Pattern Image', 'dailyfit' ),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                ),
                                array(
                                    'name' => 'dots_img',
                                    'label' => esc_html__('Banner Dots Image', 'dailyfit' ),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                ),
                                array(
                                    'name' => 'subtitle',
                                    'label'       => __( 'Sub Title ', 'dailyfit' ),
									'label_block' => true,
									'type'        => \Elementor\Controls_Manager::TEXT,
									'dynamic'     => [
										'active' => true,
									],
									'placeholder' => __( 'Enter your subtitle', 'dailyfit' ),
                                ),
								array(
                                    'name' => 'title',
                                    'label'       => __( 'Title ', 'dailyfit' ),
									'label_block' => true,
									'type'        => \Elementor\Controls_Manager::TEXTAREA,
									'dynamic'     => [
										'active' => true,
									],
									'placeholder' => __( 'Enter your title', 'dailyfit' ),
                                ),
                                //Button Option	
                                array(
                                    'name' => 'btn_title',
                                    'label'       => __( 'Button Title ', 'dailyfit' ),
									'label_block' => true,
									'type'        => \Elementor\Controls_Manager::TEXT,
									'dynamic'     => [
										'active' => true,
									],
									'placeholder' => __( 'Enter your Button Title', 'dailyfit' ),
                                ),
								array(
                                    'name' => 'link_option',
                                    'label'   => esc_html__( 'Select link Option', 'dailyfit' ),
									'label_block' => true,
									'type'    => \Elementor\Controls_Manager::SELECT,
									'default' => 'extranal',
									'options' => array(
										'extranal' => esc_html__( 'Extranal ', 'dailyfit'),
										'page' => esc_html__( 'Page ', 'dailyfit'),
									),
                                ),
                                array(
                                    'name' => 'link',
                                    'label' => __( 'External Link', 'dailyfit' ),
                    				'type' => \Elementor\Controls_Manager::URL,
                    				'label_block' => true, 
                    				'placeholder' => __( 'https://your-link.com', 'dailyfit' ),
                    				'show_external' => true,
                    				'default' => [
                    					'url' => '',
                    					'is_external' => true,
                    					'nofollow' => true,
                    				],
                    				'condition'   => [
                    					'link_option' => 'extranal'
                    				]
                                ),
                                array(
                                    'name' => 'page_select',
                                    'label' => esc_html__('Select Page', 'dailyfit' ),
                                    'label_block' => true, 
                                    'type' => \Elementor\Controls_Manager::SELECT2,
                                    'default' => 'extranal',
                    				'options' => dailyfit_page_list(),
                    				'condition'   => [
                    					'link_option' => 'page'
                    				]
                                ),
                                //Video Link Option	
        						array(
                                    'name' => 'video_option',
                                    'label' => __( 'Select Video Type', 'dailyfit' ),
        							'label_block' => true, 
        							'type' => \Elementor\Controls_Manager::SELECT,
        							'default' => 'src_url',
        							'options' => array(
        								'src_url'       => esc_html__( 'Source URL', 'dailyfit' ),
        								'src_media'      => esc_html__( 'Source Media', 'dailyfit' ),
        							),
                                ),
        						//Video Link
        						array(
                                    'name' => 'video_link',
                                    'label' => __( 'Video Source Url', 'dailyfit' ),
        							'type' => \Elementor\Controls_Manager::URL,
        							'label_block' => true, 
        							'placeholder' => __( 'https://your-link.com', 'dailyfit' ),
        							'show_external' => true,
        							'default' => [
        								'url' => '',
        							],
        							'condition' => [
        								'video_option'      => 'src_url'
        							],
                                ),
        						//Video Image
        						array(
                                    'name' => 'video_source_image',
                                    'label' => __( 'Video Source Media', 'dailyfit' ),
        							'type' => \Elementor\Controls_Manager::MEDIA,
        							'media_types' => ['video'],
        							'condition' => [
        								'video_option'      => 'src_media'
        							],
                                ),
							),
                        ),
                        
                        //Banner Carousel Two
                        array(
                            'name' => 'banner_slide_v2',
                            'label' => esc_html__('Banner Slide', 'dailyfit'),
                            'condition' => [ 'layout' => ['2'], ],
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'bg_image',
                                    'label' => esc_html__('Banner BG Image', 'dailyfit' ),
                                    'type' => \Elementor\Controls_Manager::MEDIA,
                                ),  
                                array(
                                    'name' => 'subtitle',
                                    'label'       => __( 'Sub Title ', 'dailyfit' ),
									'label_block' => true,
									'type'        => \Elementor\Controls_Manager::TEXT,
									'dynamic'     => [
										'active' => true,
									],
									'placeholder' => __( 'Enter your subtitle', 'dailyfit' ),
                                ),
								array(
                                    'name' => 'title',
                                    'label'       => __( 'Title ', 'dailyfit' ),
									'label_block' => true,
									'type'        => \Elementor\Controls_Manager::TEXT,
									'dynamic'     => [
										'active' => true,
									],
									'placeholder' => __( 'Enter your title', 'dailyfit' ),
                                ),
                                array(
                                    'name' => 'text',
                                    'label'       => __( 'Description ', 'dailyfit' ),
									'label_block' => true,
									'type'        => \Elementor\Controls_Manager::TEXTAREA,
									'dynamic'     => [
										'active' => true,
									],
									'placeholder' => __( 'Enter your Description', 'dailyfit' ),
                                ),
                                //Button Option	
                                array(
                                    'name' => 'btn_title',
                                    'label'       => __( 'Button Title ', 'dailyfit' ),
									'label_block' => true,
									'type'        => \Elementor\Controls_Manager::TEXT,
									'dynamic'     => [
										'active' => true,
									],
									'placeholder' => __( 'Enter your Button Title', 'dailyfit' ),
                                ),
								array(
                                    'name' => 'link_option',
                                    'label'   => esc_html__( 'Select link Option', 'dailyfit' ),
									'label_block' => true,
									'type'    => \Elementor\Controls_Manager::SELECT,
									'default' => 'extranal',
									'options' => array(
										'extranal' => esc_html__( 'Extranal ', 'dailyfit'),
										'page' => esc_html__( 'Page ', 'dailyfit'),
									),
                                ),
                                array(
                                    'name' => 'link',
                                    'label' => __( 'External Link', 'dailyfit' ),
                    				'type' => \Elementor\Controls_Manager::URL,
                    				'label_block' => true, 
                    				'placeholder' => __( 'https://your-link.com', 'dailyfit' ),
                    				'show_external' => true,
                    				'default' => [
                    					'url' => '',
                    					'is_external' => true,
                    					'nofollow' => true,
                    				],
                    				'condition'   => [
                    					'link_option' => 'extranal'
                    				]
                                ),
                                array(
                                    'name' => 'page_select',
                                    'label' => esc_html__('Select Page', 'dailyfit' ),
                                    'label_block' => true, 
                                    'type' => \Elementor\Controls_Manager::SELECT2,
                                    'default' => 'extranal',
                    				'options' => dailyfit_page_list(),
                    				'condition'   => [
                    					'link_option' => 'page'
                    				]
                                ),
                            ),
                        ),
                        
                        array(
                            'name' => 'icon_list',
                            'label' => esc_html__('Social Icons', 'dailyfit'),
                            'condition' => [ 'layout' => ['1','2'], ],
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
        							'name' => 'social_icon',
        							'label' => esc_html__('Social Icon', 'dailyfit' ),
        							'type' => \Elementor\Controls_Manager::ICONS,
        							'fa4compatibility' => 'icon',
        						),
                                array(
                                    'name' => 'social_link',
                                    'label' => __( 'External Link', 'dailyfit' ),
                    				'type' => \Elementor\Controls_Manager::URL,
                    				'label_block' => true, 
                    				'placeholder' => __( 'https://your-link.com', 'dailyfit' ),
                    				'default' => [
                    					'url' => '',
                    					'is_external' => true,
                    					'nofollow' => true,
                    				],
                                ),
                            ),
                        ),
					),
                ),
                
                
                
                //Dailyfit Layout Style
				array(
					'name' => 'dailyfit_layout_style',
					'label' => esc_html__('Dailyfit Layout Setting', 'dailyfit' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'controls' => array(						
                        array(
							'name' => 'dailyfit_layout_margin',
							'label' => __( 'Margin', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .main-slider-two' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .main-slider-three' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
						array(
							'name' => 'dailyfit_layout_padding',
							'label' => __( 'Padding', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .main-slider-two' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .main-slider-three' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						), 
						array(
							'name' => 'dailyfit_layout_bgcolor',
							'label' => esc_html__('BG Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .main-slider-two' => 'background-color: {{VALUE}};',
								'{{WRAPPER}} .main-slider-three' => 'background-color: {{VALUE}};',
							],
						),
					),
				),
                
                //SubTitle Style
				array(
					'name' => 'section_style_subtitle',
					'label' => esc_html__('Sub Title', 'dailyfit' ),
                    'condition'   => [
                        'layout' => ['1','2'],
                    ],
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'controls' => array(
						array(
							'name' => 'subtitle_color',
							'label' => esc_html__('Sub Title Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .te-subtitle' => 'color: {{VALUE}};',
							],
						),
						array(
                            'name' => 'subtitle_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-subtitle',
                        ),
                        array(
							'name' => 'subtitle_margin',
							'label' => __( 'Margin', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .te-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
						array(
							'name' => 'subtitle_padding',
							'label' => __( 'Padding', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .te-subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
					),
				),
                
				//Title Style
				array(
					'name' => 'section_style_title',
					'label' => esc_html__('Title', 'dailyfit' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'controls' => array(
						array(
							'name' => 'title_color',
							'label' => esc_html__('Title Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .te-title' => 'color: {{VALUE}};',
								'{{WRAPPER}} .te-title span' => 'color: {{VALUE}};',
							],
						),
						array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-title,
                                                       .te-title span',
                        ),
                        array(
							'name' => 'title_margin',
							'label' => __( 'Margin', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .te-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
						array(
							'name' => 'title_padding',
							'label' => __( 'Padding', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .te-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
					),
				),
				
				
				//Text Style
				array(
					'name' => 'section_style_text',
					'label' => esc_html__('Text', 'dailyfit' ),
					'condition'   => [
                        'layout' => ['2'],
                    ],
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'controls' => array(
						array(
							'name' => 'text_color',
							'label' => esc_html__('Text Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .te-text' => 'color: {{VALUE}};',
							],
						),
						array(
                            'name' => 'text_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .te-text',
                        ),
                        array(
							'name' => 'text_margin',
							'label' => __( 'Margin', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .te-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
						array(
							'name' => 'text_padding',
							'label' => __( 'Padding', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .te-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
					),
				),
                
				//Button Style
				array(
					'name' => 'section_style_btn',
					'label' => esc_html__('Button', 'dailyfit' ),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'controls' => array(
						array(
							'name' => 'btn_bg_color',
							'label' => esc_html__('Background Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .yt-btn' => 'background-color: {{VALUE}};',
							],
						),
						array(
							'name' => 'btn_color',
							'label' => esc_html__('Button Text Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .yt-btn-title-v1' => 'color: {{VALUE}};',
								'{{WRAPPER}} .yt-btn-title-v1 span.txt' => 'color: {{VALUE}};',
							],
						),
						array(
                            'name' => 'btn_typography',
                            'label' => esc_html__('Typography', 'dailyfit' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .yt-btn-title-v1',
                        ),
                        array(
							'name' => 'btn_margin',
							'label' => __( 'Margin', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .yt-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
						array(
							'name' => 'btn_padding',
							'label' => __( 'Padding', 'dailyfit' ),
							'type'       => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors'  => [
								'{{WRAPPER}} .yt-btn a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'separator'  => 'before',
						),
						array(
							'name' => 'btn_border_type',
							'label' => esc_html__( 'Border Type', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::SELECT,
							'options' => [
								'' => esc_html__( 'None', 'dailyfit' ),
								'solid' => esc_html__( 'Solid', 'dailyfit' ),
								'double' => esc_html__( 'Double', 'dailyfit' ),
								'dotted' => esc_html__( 'Dotted', 'dailyfit' ),
								'dashed' => esc_html__( 'Dashed', 'dailyfit' ),
								'groove' => esc_html__( 'Groove', 'dailyfit' ),
							],
							'selectors' => [
								'{{WRAPPER}} .yt-btn a' => 'border-style: {{VALUE}} !important;',
							],
						),
						array(
							'name' => 'btn_border_width',
							'label' => esc_html__( 'Border Width', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::DIMENSIONS,
							'selectors' => [
								'{{WRAPPER}} .yt-btn a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
							],
							'condition' => [
								'btn_border_type!' => '',
							],
							'responsive' => true,
						),
						array(
							'name' => 'btn_border_color',
							'label' => esc_html__( 'Border Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'default' => '',
							'selectors' => [
								'{{WRAPPER}} .yt-btn a' => 'border-color: {{VALUE}} !important;',
							],
							'condition' => [
								'btn_border_type!' => '',
							],
						),
						array(
							'name' => 'btn_radius',
							'label' => __( 'Border Radius', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%' ],
							'selectors' => [
								'{{WRAPPER}} .yt-btn a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						),
					),
				),
				
				//Button Hover Style
				array(
					'name' => 'section_style_hover_btn',
					'label' => esc_html__('Button Hover Style', 'dailyfit' ),
                    'condition' => [ 'layout' => ['3'], ],
					'tab' => \Elementor\Controls_Manager::TAB_STYLE,
					'controls' => array(
						array(
							'name' => 'btn_bg_hover_color',
							'label' => esc_html__('Background Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .yt-btn a:hover' => 'background-color: {{VALUE}};',
								'{{WRAPPER}} .yt-btn a:hover:before' => 'background-color: {{VALUE}};',
							],
						),
						array(
							'name' => 'btn_hover_color',
							'label' => esc_html__('Text Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .yt-btn-title-v1:hover' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .yt-btn a:hover .yt-btn-title-v1' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .yt-btn a:hover .yt-btn-title-v1 .txt' => 'color: {{VALUE}};',
							],
						),
						array(
							'name' => 'btn_border_hover_color',
							'label' => esc_html__( 'Border Color', 'dailyfit' ),
							'type' => \Elementor\Controls_Manager::COLOR,
							'default' => '',
							'selectors' => [
								'{{WRAPPER}} .yt-btn a:hover' => 'border-color: {{VALUE}} !important;',
							],
						),
					),
				),
                
                array(
                    'name' => 'section_carousel',
                    'label' => esc_html__('Carousel', 'dailyfit'),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'exp_animate',
                            'label' => esc_html__('Dailyfit Animate', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => dailyfit_widget_animate(),
                            'default' => '',
                        ),
                        array(
                            'name' => 'col_xs',
                            'label' => esc_html__('Columns XS Devices', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '1',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_sm',
                            'label' => esc_html__('Columns SM Devices', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '2',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_md',
                            'label' => esc_html__('Columns MD Devices', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_lg',
                            'label' => esc_html__('Columns LG Devices', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_xl',
                            'label' => esc_html__('Columns XL Devices', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'col_xxl',
                            'label' => esc_html__('Columns XXL Devices', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'inherit',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                                'inherit' => 'Inherit',
                            ],
                        ),

                        array(
                            'name' => 'slides_to_scroll',
                            'label' => esc_html__('Slides to scroll', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '1',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                            ],
                        ),                        
                        array(
                            'name' => 'arrows',
                            'label' => esc_html__('Show Arrows', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'false',
                        ),
                        array(
                            'name' => 'pagination',
                            'label' => esc_html__('Show Pagination', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'false',
                        ),
                        array(
                            'name' => 'pagination_type',
                            'label' => esc_html__('Pagination Type', 'dailyfit' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'bullets',
                            'options' => [
                                'bullets' => 'Bullets',
                                'fraction' => 'Fraction',
                            ],
                            'condition' => [
                                'pagination' => 'true'
                            ]
                        ),

                        array(
                            'name' => 'pause_on_hover',
                            'label' => esc_html__('Pause on Hover', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                        ),
                        array(
                            'name' => 'center',
                            'label' => esc_html__('Center', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'false',                            
                        ),
                        array(
                            'name' => 'autoplay',
                            'label' => esc_html__('Autoplay', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'false',
                        ),
                        array(
                            'name' => 'autoplay_speed',
                            'label' => esc_html__('Autoplay Speed', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 5000,
                            'condition' => [
                                'autoplay' => 'false'
                            ]
                        ),
                        array(
                            'name' => 'infinite',
                            'label' => esc_html__('Infinite Loop', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                        ),
                        array(
                            'name' => 'speed',
                            'label' => esc_html__('Animation Speed', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 500,
                        ),
                        array(
                            'name' => 'drap',
                            'label' => esc_html__('Show Scroll Drap', 'dailyfit'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'false',                            
                        ),                                                                                          
                        
                    ),
                ),
                
                dailyfit_widget_animation_settings(),
            ),
        ),
    ),
    dailyfit_get_class_widget_path()
);
