<?php
	$html_id = exp_get_element_id($settings);
	$layout = $settings[ 'layout' ];
	
	$video_option = $settings[ 'video_option' ];
	if( $video_option == 'src_url' ){
		$video = $settings[ 'video_link' ][ 'url' ];
	}elseif( $video_option == 'src_media' ){
		$video = $settings[ 'video_source_image' ]['url'];
	}else{
		$video = esc_html__( 'There is no Video', 'dailyfit' );
	}
?>
	
    <!-- Video Section -->
    <section class="video-section <?php echo esc_attr($settings['exp_animate']); ?>">
        <?php if($settings['title']){ ?><div class="side-text"><?php echo wp_kses($settings['title'], true); ?></div><?php } ?>
        <div class="outer-container">
            <div class="inner-container">
                <!--Video Box-->
                <div class="video-box">
                    <?php if($settings['video_img']){ ?>
                    <figure class="video-image">
                        <img src="<?php echo esc_url(wp_get_attachment_url($settings['video_img']['id'])); ?>" alt="<?php bloginfo( 'name' ); ?>">
                    </figure>
                    <?php } ?>
                    
                    <?php if($video){ ?>
                    <a href="<?php echo esc_url( $video );?>" class="lightbox-image overlay-box"><span class="flaticon-play-arrow"><i class="ripple"></i></span></a>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>
    <!-- Video Section --> 