<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');

$col_xl = 12 / intval($col_xl);
$col_lg = 12 / intval($col_lg);
$col_md = 12 / intval($col_md);
$col_sm = 12 / intval($col_sm);
$col_xs = 12 / intval($col_xs);

$grid_sizer = "col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
$item_class = "exp-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
?>
<?php if(isset($settings['testimonials']) && !empty($settings['testimonials']) && count($settings['testimonials'])): ?>
    
    <!-- ==== team section start ==== -->
    <section class="testimonial-page-section exp-team-grid <?php echo esc_attr($settings['exp_animate']); ?>">        
       	<div class="row gaper justify-content-center gutter-40">          
			<?php foreach ($settings['testimonials'] as $key => $value):
				$image = isset($value['image']) ? $value['image'] : '';
                $desc = isset($value['desc']) ? $value['desc'] : '';
                $title = isset($value['title']) ? $value['title'] : '';
                $designation = isset($value['designation']) ? $value['designation'] : '';
            ?>
          	<div class="testimonial-block-three <?php echo esc_attr($item_class); ?>">
                <div class="inner-box">
                    <div class="text te-text"><?php echo exp_print_html($desc); ?></div>
                    <div class="rating te-rating">
                        <?php
							$ratting = wp_kses($value['star'], true ); 
							for ($x = 1; $x <= 5; $x++) {
							if($x <= $ratting) echo '<span class="fa fa-star"></span>'; else echo '<span class="fa fa-star-o"></span>'; 
							}
						?>
                    </div>
                    <h4 class="te-title"><?php echo exp_print_html($title); ?></h4>
                    <div class="designation te-designation"><?php echo exp_print_html($designation); ?></div>
                    <div class="author-image">
                        <?php if(!empty($image['id'])) { 
							$img = exp_get_image_by_size( array(
								'attach_id'  => $image['id'],
								'thumb_size' => '133x133',
								'class' => 'no-lazyload',
							));
							$thumbnail = $img['thumbnail'];
						?>
						<div class="image">
							<?php echo wp_kses_post($thumbnail); ?>
						</div>
						<?php } ?>
                        <span class="quote-icon flaticon-quote"></span>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
       	</div>
    </section>
    <!-- ==== / team section end ==== -->
    
<?php endif; ?>
