<?php

$html_id = exp_get_element_id($settings);

$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$autoplay = $widget->get_setting('autoplay');
$autoplay_speed = $widget->get_setting('autoplay_speed');
$infinite = $widget->get_setting('infinite');

$changed_atts = array(
	'infinite'       => $infinite,
	'autoplay'       => $autoplay,
	'autoplaySpeed'  => $autoplay_speed,
	'dots' 			 => $dots,
	'nav' 		     => $arrows
);

$slider_atts = 'data-slider';

$widget->add_render_attribute( 'carousel', $slider_atts , wp_json_encode( $changed_atts ) );

if(isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): ?>
    
<!-- ==== testimonial section start ==== -->
<section id="testimonials" class="testimonial-section">
    <div class="testimonial-column">
        <div class="inner-column">
            
            <div class="client-testimonial-carousel owl-carousel owl-theme <?php if( $dots == 'true' ) echo 'owl-dots-none';?> <?php echo esc_attr( $arrows == 'true' ) ? 'owl-nav-style-one' : 'owl-nav-none'; ?>" id="yt-testimonial-slider" <?php $widget->print_render_attribute_string( 'carousel' ); ?>>                
                
                <?php foreach ($settings['testimonial'] as $key => $value):
                    $image = isset($value['image']) ? $value['image'] : '';
                    $desc = isset($value['desc']) ? $value['desc'] : '';
                    $title = isset($value['title']) ? $value['title'] : '';
                    $designation = isset($value['designation']) ? $value['designation'] : '';
                ?>
                
                <!-- Testimonial Block Two -->
                <div class="testimonial-block-two">
                    <div class="inner-box">
                        <div class="upper-box">
                            <?php if(!empty($image['id'])) { 
                            $img = exp_get_image_by_size( array(
                                'attach_id'  => $image['id'],
                                'thumb_size' => '86x85',
                                'class' => 'no-lazyload',
                            ));
                            $thumbnail = $img['thumbnail'];?>
                            <div class="author-image">
                                <?php echo wp_kses_post($thumbnail); ?>
                            </div>
                            <?php } ?>
                            
                            <div class="title te-designation"><?php echo exp_print_html($designation); ?></div>
                            <h4  class="author-name te-title"><?php echo exp_print_html($title); ?></h4>
                            <div class="rating te-rating">
                                <?php
                                    $ratting = wp_kses($value['star'], true ); 
                                    for ($x = 1; $x <= 5; $x++) {
                                    if($x <= $ratting) echo '<span class="fa fa-star"></span>'; else echo '<span class="fa fa-star-o"></span>'; 
                                    }
                                ?>
                            </div>
                        </div>
                        <div class="quote-icon flaticon-right-quote"></div>
                        <div class="text te-text"><?php echo exp_print_html($desc); ?> </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>        
    </div>
</section>
<!-- ==== / testimonial section end ==== -->

<?php endif; ?>
