<?php
$html_id = exp_get_element_id($settings);
$tax = array();
$select_post_by = $widget->get_setting('select_post_by', '');
$source = $post_ids = [];
if($select_post_by === 'post_selected'){
    $post_ids = $widget->get_setting('source_'.$settings['post_type'].'_post_ids', '');
}else{
    $source  = $widget->get_setting('source_'.$settings['post_type'], '');
}
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
extract(exp_get_posts_of_grid(
    'post', 
    ['source' => $source, 'orderby' => $orderby, 'order' => $order, 'limit' => $limit, 'post_ids' => $post_ids],
    ['category']
));

$grid_class = '';
$grid_class = 'exp-grid-inner exp-grid-masonry row';


if($settings['col_xl'] == '5') {
    $col_xl = 'exp5';
} else {
    $col_xl = 12 / intval($widget->get_setting('col_xl', 4));
}
$col_lg = 12 / intval($widget->get_setting('col_lg', 4));
$col_md = 12 / intval($widget->get_setting('col_md', 3));
$col_sm = 12 / intval($widget->get_setting('col_sm', 2));
$col_xs = 12 / intval($widget->get_setting('col_xs', 1));
$grid_sizer = "col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";


$pagination_type = $widget->get_setting('pagination_type', 'pagination');

$post_type = $widget->get_setting('post_type','post');
$layout = $widget->get_setting('layout_'.$post_type, 'post-2');

$grid_masonry = $widget->get_setting('grid_masonry');
$show_author = $widget->get_setting('author');
$show_date = $widget->get_setting('date');
$btn_title = $widget->get_setting('btn_title');
$img_size = $widget->get_setting('img_size');
$img_size_m = $widget->get_setting('img_size_m');
$show_read_btn = $widget->get_setting('show_read_btn');
$show_title = $widget->get_setting('show_title');
$show_comments = $widget->get_setting('show_comments');

$load_more = array(
    'post_type'       => $post_type,   
    'layout'          => $layout,
    'startPage'       => $paged,
    'maxPages'        => $max,
    'total'           => $total,
    'perpage'         => $limit,
    'nextLink'        => $next_link,
    'source'          => $source,
    'orderby'         => $orderby,
    'order'           => $order,
    'limit'           => $limit,
    'post_ids'        => $post_ids,
    'col_xl'          => $col_xl,
    'col_lg'          => $col_lg,
    'col_md'          => $col_md,
    'col_sm'          => $col_sm,
    'col_xs'          => $col_xs,
    'pagination_type' => $pagination_type,
    'grid_masonry'    => $grid_masonry,
    'show_author'     => $show_author,
    'show_date'       => $show_date,
    'btn_title'       => $btn_title,
    'img_size'        => $img_size,
    'img_size_m'      => $img_size_m,
    'show_read_btn'   => $show_read_btn,
    'show_comments'   => $show_comments,
    'show_title'       => $show_title,
);

if (is_array($posts)):
?>

<!-- ==== blog section start ==== -->
<section id="<?php echo esc_attr($html_id) ?>" class="blog exp-grid p-0 m-0" data-layout="masonry" data-start-page="<?php echo esc_attr($paged); ?>" data-max-pages="<?php echo esc_attr($max); ?>" data-total="<?php echo esc_attr($total); ?>" data-next-link="<?php echo esc_attr($next_link); ?>">
        
        <div class="<?php echo esc_attr($grid_class); ?>" data-gutter="15">
            <div class="grid-sizer <?php echo esc_attr($grid_sizer); ?>"></div>
            <?php $load_more['tax'] = $tax; dailyfit_get_post_grid($posts, $load_more); ?>
        </div>
    <?php   

    if ($pagination_type == 'pagination') { ?>
        <div class="blog-item-navigation exp-grid-pagination aos-init aos-animate" data-loadmore="<?php echo esc_attr(json_encode($load_more)); ?>" data-query="<?php echo esc_attr(json_encode($args)); ?>">
            <?php dailyfit()->page->get_pagination($query, true); ?>
        </div>
    <?php } ?>
    <?php if (!empty($next_link) && $pagination_type == 'loadmore') { ?>
        <div class="exp-load-more" data-loadmore="<?php echo esc_attr(json_encode($load_more)); ?>">
            <div class="ajax">
                <span class="btn btn-gradient dailyfit-btn">
                    <?php echo esc_html__('Load More', 'dailyfit') ?>
                    <span class="exp-load-icon"><i class="fa fa-spinner"></i></span>
                </span>
            </div>
        </div>
    <?php } ?>
        
</section>
<!-- ==== / blog section end ==== -->


<?php endif;  ?>