<?php
$html_id = exp_get_element_id($settings);
$tax = array();
$select_post_by = $widget->get_setting('select_post_by', '');
$source = $post_ids = [];
if($select_post_by === 'post_selected'){
    $post_ids = $widget->get_setting('source_'.$settings['post_type'].'_post_ids', '');
}else{
    $source  = $widget->get_setting('source_'.$settings['post_type'], '');
}
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
extract(exp_get_posts_of_grid(
    'portfolio', 
    ['source' => $source, 'orderby' => $orderby, 'order' => $order, 'limit' => $limit, 'post_ids' => $post_ids],
    ['portfolio-category']
));

$grid_class = '';
$grid_class = 'exp-grid-inner row';


if($settings['col_xl'] == '5') {
    $col_xl = 'exp5';
} else {
    $col_xl = 12 / intval($widget->get_setting('col_xl', 4));
}
$col_lg = 12 / intval($widget->get_setting('col_lg', 4));
$col_md = 12 / intval($widget->get_setting('col_md', 3));
$col_sm = 12 / intval($widget->get_setting('col_sm', 2));
$col_xs = 12 / intval($widget->get_setting('col_xs', 1));
$grid_sizer = "col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";



$post_type = $widget->get_setting('post_type','portfolio');
$layout = $widget->get_setting('layout_'.$post_type, 'portfolio-1');

$grid_masonry = $widget->get_setting('grid_masonry');
$img_size = $widget->get_setting('img_size');
$show_title = $widget->get_setting('show_title');

$load_more = array(
    'post_type'       => $post_type,   
    'layout'          => $layout,
    'total'           => $total,
    'perpage'         => $limit,
    'nextLink'        => $next_link,
    'source'          => $source,
    'orderby'         => $orderby,
    'order'           => $order,
    'limit'           => $limit,
    'post_ids'        => $post_ids,
    'col_xl'          => $col_xl,
    'col_lg'          => $col_lg,
    'col_md'          => $col_md,
    'col_sm'          => $col_sm,
    'col_xs'          => $col_xs,
    'img_size'        => $img_size,
    'grid_masonry'    => $grid_masonry,
    'show_title'      => $show_title,
);

if (is_array($posts)):
?>

<!-- ==== blog section start ==== -->
<section id="<?php echo esc_attr($html_id) ?>" class="portfolio-page-section p-0 m-0 exp-grid" data-total="<?php echo esc_attr($total); ?>" data-next-link="<?php echo esc_attr($next_link); ?>">
    <div class="auto-container-dailyfit">
        <div class="portfolio__inner">
            <div class="<?php echo esc_attr($grid_class); ?> masonary-layout" data-gutter="15">
                <?php $load_more['tax'] = $tax; dailyfit_get_post_grid($posts, $load_more); ?>
            </div>
        </div>
    </div>   
</section>
<!-- ==== / blog section end ==== -->


<?php endif;  ?>