<?php

$html_id = exp_get_element_id($settings);
$source    = $widget->get_setting('source_'.$settings['post_type']);
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$post_ids = $widget->get_setting('post_ids', '');
$settings['layout']    = $settings['layout_'.$settings['post_type']];
extract(exp_get_posts_of_grid('post', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$exp_animate = $widget->get_setting('exp_animate', '');
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows','false');  
$pagination = $widget->get_setting('pagination','false');
$pagination_type = $widget->get_setting('pagination_type','bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');

$img_size = $widget->get_setting('img_size');
$show_author = $widget->get_setting('show_author');
$show_date = $widget->get_setting('show_date');
$show_comment = $widget->get_setting('show_comment');
$show_button = $widget->get_setting('show_button');
$button_text = $widget->get_setting('button_text');
$show_excerpt = $widget->get_setting('show_excerpt');
$num_words = $widget->get_setting('num_words');
$drap = $widget->get_setting('drap');

$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1', 
    'slide_percolumnfill'           => '1', 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => $col_xl,
    'slides_to_show_xxl'             => $col_xxl,  
    'slides_to_show_lg'             => $col_lg, 
    'slides_to_show_md'             => $col_md, 
    'slides_to_show_sm'             => $col_sm, 
    'slides_to_show_xs'             => $col_xs, 
    'slides_to_scroll'              => $slides_to_scroll,  
    'slides_gutter'                 => 30, 
    'arrow'                         => $arrows,
    'pagination'                    => $pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => $autoplay,
    'pause_on_hover'                => $pause_on_hover,
    'pause_on_interaction'          => 'true',
    'delay'                         => $autoplay_speed,
    'loop'                          => $infinite,
    'speed'                         => $speed
];

$widget->add_render_attribute( 'carousel', [
    'class'         => 'exp-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]); ?>

<?php if (is_array($posts)): ?>
    <div class="news-section p-0 m-0 exp-swiper-sliders exp-post-carousel <?php if($arrows == true) { echo 'exp-arrows-active'; } ?>" <?php if($settings['drap']) : ?>data-cursor-drap="<?php echo esc_html('DRAG', 'dailyfit'); ?>"<?php endif; ?>>
        <div class="swiper exp-carousel-inner">
            <div <?php exp_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="news-carousel-two swiper-wrapper exp-swiper-wrapper">
                <?php
                    $image_size = !empty($img_size) ? $img_size : '570x320';
                    foreach ($posts as $post):
                    $img_id       = get_post_thumbnail_id( $post->ID );
                    $author = get_user_by('id', $post->post_author);
                    $blog_excerpt = get_post_meta($post->ID, 'blog_excerpt', true);
                    if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): 
                        $img          = exp_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $image_size
                        ) );
                        $thumbnail    = $img['thumbnail'];
                        $thumbnail_url    = $img['url'];
                        ?>
                        
                        <div class="swiper-slide exp-swiper-slide">
                            <div class="news-block-three <?php echo esc_attr($exp_animate); ?>">
                                <div class="inner-box">
                                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                                    <div class="image">
                                        <a href="<?php echo esc_url(get_the_permalink( $post->ID )); ?>" class="link">
                                            <?php echo wp_kses_post($thumbnail); ?>
                                        </a>
                                    </div>
                                    <?php endif; ?>
                                    <div class="lower-content">
                                        <?php if( $show_author == 'true' || $show_date == 'true' || $show_comment == 'true' ) : ?>
                                        <ul class="post-meta">
                                            <?php if( $show_author == 'true' ) : ?>
                                            <li class="te-author"><span class="fa fa-user"></span> &nbsp; <?php echo esc_html($author->display_name); ?></li>
                                            <?php endif; ?>
                                            <?php if( $show_date == 'true' ) : ?>
                                            <li class="te-date"><span class="fa fa-calendar"></span> &nbsp; <?php echo get_the_date('', $post->ID); ?></li>
                                            <?php endif; ?>
                                            <?php 
                                                if( $show_comment == 'true' ) :
                                                $comment_count = get_comments_number($post->ID); 
                                            ?>
                                            <li class="te-comment">
                                                <span class="fa fa-comments"></span> &nbsp; 
                                                <?php if($comment_count > 1) { echo esc_html__('Comments', 'dailyfit'); } ?>
                                                <?php if($comment_count == 1 || $comment_count == 0) { echo esc_html__('Comment', 'dailyfit'); } ?>
                                                <?php echo esc_attr($comment_count ); ?>
                                            </li>
                                            <?php endif; ?>
                                        </ul>
                                        <?php endif; ?>
                                        <?php  if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)):  ?>
                                            <h3><a class="te-title" href="<?php echo esc_url(get_the_permalink( $post->ID )); ?>"><?php echo esc_html(wp_trim_words(get_the_title($post->ID), 5,'..')); ?></a></h3>
                                        <?php else :  ?>
                                            <h3><a class="te-title" href="<?php echo esc_url(get_the_permalink( $post->ID )); ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h3>
                                        <?php endif;  ?>
                                        <?php if($show_excerpt == 'true'): ?>
                                        <div class="text te-text"><?php echo wp_trim_words( $blog_excerpt, $num_words ); ?></div>
                                        <?php endif; ?>
                                        <?php if( $show_button == 'true' ): ?>
                                        <a href="<?php echo esc_url(get_the_permalink( $post->ID )); ?>" class="read-more te-post-btn">
                                            <?php echo wp_kses( $button_text, true );?>
                                        </a>
                                        <?php endif;?>
                                    </div>
                                    
                                </div>
                            </div>                                
                        </div>
                        
                    <?php endif; ?>
                <?php endforeach; ?>
                </div> 
            </div>
            
            <?php if($arrows !== 'false'): ?>
            <div class="owl-nav">
                <div class="prev-blog-slide prev-slide exp-swiper-arrow-prev owl-prev">
                    <i class="fa fa-angle-left"></i>
                </div>
            
                <div class="next-blog-slide next-slide exp-swiper-arrow-next owl-next">
                    <i class="fa fa-angle-right"></i>
                </div>
            </div> 
            <?php endif; ?>
            
            <?php if($pagination !== 'false'): ?>
                <div class="exp-swiper-dots owl-dots"></div>
            <?php endif; ?>
            
        </div>
    </div>
<?php endif; ?>