<?php

$html_id = exp_get_element_id($settings);

$tax = ['portfolio-category'];
$select_post_by = $widget->get_setting('select_post_by', '');
$source = $post_ids = [];
if ($select_post_by === 'post_selected') {
   $post_ids = $widget->get_setting('source_' . $settings['post_type'] . '_post_ids', '');
} else {
   $source  = $widget->get_setting('source_' . $settings['post_type'], '');
}
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$settings['layout']    = $settings['layout_' . $settings['post_type']];
extract(exp_get_posts_of_grid('portfolio', [
   'source' => $source,
   'orderby' => $orderby,
   'order' => $order,
   'limit' => $limit,
   'post_ids' => $post_ids,
]));


$exp_animate = $widget->get_setting('exp_animate', '');
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows','false');
$pagination = $widget->get_setting('pagination','false');
$pagination_type = $widget->get_setting('pagination_type','bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');

$filter = $widget->get_setting('filter', 'false');
$filter_default_title = $widget->get_setting('filter_default_title', 'All');

$img_size = $widget->get_setting('img_size');

$show_title = $widget->get_setting('show_title');
$show_category = $widget->get_setting('show_category');
$show_ext_link = $widget->get_setting('show_ext_link');
$show_popup_image = $widget->get_setting('show_popup_image');


$drap = $widget->get_setting('drap');

$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1', 
    'slide_percolumnfill'           => '1', 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => $col_xl,
    'slides_to_show_xxl'             => $col_xxl,  
    'slides_to_show_lg'             => $col_lg, 
    'slides_to_show_md'             => $col_md, 
    'slides_to_show_sm'             => $col_sm, 
    'slides_to_show_xs'             => $col_xs, 
    'slides_to_scroll'              => $slides_to_scroll,  
    'slides_gutter'                 => 30, 
    'arrow'                         => $arrows,
    'pagination'                    => $pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => $autoplay,
    'pause_on_hover'                => $pause_on_hover,
    'pause_on_interaction'          => 'true',
    'delay'                         => $autoplay_speed,
    'loop'                          => $infinite,
    'speed'                         => $speed
];

$widget->add_render_attribute( 'carousel', [
    'class'         => 'exp-swiper-container swiper-container swiper',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]); ?>

<?php if (is_array($posts)): ?>
    <div class="project-section p-0 m-0 exp-swiper-sliders exp-portfolio-carousel" <?php if($arrows == true) { echo 'exp-arrows-active'; } ?>>
        <div class="exp-carousel-inner">
            <div class="project-tab">
                
                <?php if ($select_post_by === 'term_selected' && $filter == "true") { ?>
                     <ul class="swiper-filter-wrap product-tab-btns clearfix">
                        <?php if (!empty($filter_default_title)): ?>
                           <li class="p-tab-btn filter-item active" data-filter-target="all">
                              <?php echo esc_html($filter_default_title); ?>
                           </li>
                        <?php endif; ?>
                        <?php foreach ($categories as $category):
                           $category_arr = explode('|', $category);
                           $term = get_term_by('slug', $category_arr[0], $category_arr[1]);
                        ?>
                           <li class="filter-item p-tab-btn" data-filter-target="<?php echo esc_attr($term->slug); ?>">
                              <?php echo esc_html($term->name); ?>
                           </li>
                        <?php endforeach; ?>
                     </ul>
                <?php  } ?>
                
                 <div <?php exp_print_html($widget->get_render_attribute_string('carousel')); ?>>
                    <div class="exp-swiper-wrapper swiper-wrapper">
                       <?php
                       foreach ($posts as $post):
                           $filter_class = '';
                           if ($select_post_by === 'term_selected' && $filter == "true")
                            $filter_class = exp_get_term_of_post_to_class($post->ID, array_unique($tax));
                        
                          $image_size = !empty($img_size) ? $img_size : '529x950';
                          $img_id       = get_post_thumbnail_id($post->ID);
                          $img          = exp_get_image_by_size(array(
                             'attach_id'  => $img_id,
                             'thumb_size' => $image_size
                          ));
                          $thumbnail    = $img['thumbnail'];
                          $thumbnail_url    = $img['url'];
                          
                          if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): 
                       ?>
                          <div class="swiper-slide exp-swiper-slide swiper-slide-filter" data-filter="<?php echo esc_attr($filter_class) ?>">
                             <div class="exp-item--inner">
                                 
                                 <div class="gallery-block style-two">
    								<div class="inner-box">
    									<div class="image">
                                            <?php echo wp_kses_post($thumbnail); ?>
                                            <div class="overlay-box">
                            
                                                <?php  if( $show_popup_image || $show_ext_link ):  ?>
                                                    <div class="options">
                                                        <?php if( $show_ext_link ):  ?>
                                                            <a href="<?php if(!empty($portfolio_external_link)) { echo esc_url($portfolio_external_link); } else { echo esc_url(get_the_permalink( $post->ID )); } ?>" class="plus-icon"><span class="icon flaticon-unlink"></span></a>
                                                        <?php  endif; ?>
                                                        <?php  if( $show_popup_image ):   ?>
                                                            <a href="<?php echo esc_url($thumbnail_url);?>" class="plus-icon lightbox-image" data-fancybox-group="gallery-one"><span class="icon flaticon-increase-size-option"></span></a>
                                                        <?php  endif; ?>
                                                    </div>
                                                <?php endif; ?>
                                                
                                                <div class="content clearfix">
                                                    <?php  if( $show_title ):  ?>
                                                        <h3>
                                                            <a class="te-title" href="<?php if(!empty($portfolio_external_link)) { echo esc_url($portfolio_external_link); } else { echo esc_url(get_the_permalink( $post->ID )); } ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a>
                                                        </h3>
                                                    <?php endif;  ?>
                                                    <?php if( $show_category ):  ?>
                                                    <div class="category te-category"><?php the_terms( $post->ID, 'portfolio-category', '', ', ', '' ); ?></div>
                                                    <?php endif;  ?>
                                                </div>
                                                    
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                             </div>
                          </div>
                       <?php endif; endforeach; ?>
                    </div>
                 </div>


            
                <?php if ($arrows !== false): ?>
                   <div class="exp-swiper-arrow-wrap style-5">
                      <div class="exp-swiper-arrow exp-swiper-arrow-prev swiper-arrow"><i class="fa fa-angle-left"></i></div>
                      <div class="exp-swiper-arrow exp-swiper-arrow-next swiper-arrow"><i class="fa fa-angle-right"></i></div>
                   </div>
                <?php endif; ?>
                  
            </div>
        </div>
    </div>
<?php endif; ?>