<?php
	use \Elementor\Group_Control_Background;
	use \Elementor\Group_Control_Image_Size;
	$html_id = exp_get_element_id($settings);
	$layout = $settings[ 'layout' ];
?>
	
    <!-- ==== about section start ==== -->
    <div class="featured-block p-0 m-0">
        <div class="block-inner">
            <?php if ( $settings['icon_type'] == 'icon' && !empty($settings['exp_icon']['value']) ) : ?>
            <div class="group-left te-icons">                        
				<?php \Elementor\Icons_Manager::render_icon( $settings['exp_icon'], [ 'aria-hidden' => 'true', 'class' => 'icon' ], 'i' ); ?>
            </div>
            <?php endif; ?>
			
			<?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
            <div class="group-left te-icon">
               <?php $img_icon  = exp_get_image_by_size( array(
                        'attach_id'  => $settings['icon_image']['id'],
                        'thumb_size' => 'full',
                    ) );
                    $thumbnail_icon    = $img_icon['thumbnail'];
                echo exp_print_html($thumbnail_icon); ?>
            </div>
            <?php endif; ?>
            <strong class="te-title"><?php echo wp_kses($settings['title'], true ) ;?></strong>
            <div class="feature-text te-text"><?php echo wp_kses($settings['text'], true ) ;?></div>
        </div>
    </div>