<?php
	$html_id = exp_get_element_id($settings);
	$layout = $settings[ 'layout' ];
?>   
	
    <!-- ==== pricing section start ==== -->
    <section class="pricing p-0 m-0">
    	<div class="pricing__thumb">
            <div class="pricing__thumb-inner">
                <?php if($settings['feature_img']){ ?>
                <div class="shape-lg" data-aos="fade-left" data-aos-duration="1000">
                    <img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_img']['id'])); ?>" alt="<?php bloginfo( 'name' ); ?>">
                </div>
                <?php } ?>
                <?php if($settings['feature_img_v2']){ ?>
                <div class="shape-sm" data-aos="fade-right" data-aos-duration="1000" data-aos-delay="200">
                    <img src="<?php echo esc_url(wp_get_attachment_url($settings['feature_img_v2']['id'])); ?>" alt="<?php bloginfo( 'name' ); ?>">
                </div>
                <?php } ?>
                <div class="pricing__thumb-content" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                    <div class="left-content">
                        <h2><span class="odometer" data-odometer-final="<?php echo wp_kses($settings['experience_year'], true); ?>"></span><span><?php echo wp_kses($settings['alphabet_letter'], true); ?></span></h2>
                        <p><?php esc_html_e('Years','dailyfit'); ?></p>
                    </div>
                    <div class="right-content">
                    	<p><span><?php echo wp_kses($settings['experience_desc'], true); ?></span></p>
                    </div>
                    <?php if($settings['experience_bg_pattern_img']){ ?><img src="<?php echo esc_url(wp_get_attachment_url($settings['experience_bg_pattern_img']['id'])); ?>" alt="<?php bloginfo( 'name' ); ?>" class="flat"><?php } ?>
                    <?php if($settings['basket_img']){ ?><img src="<?php echo esc_url(wp_get_attachment_url($settings['basket_img']['id'])); ?>" alt="<?php bloginfo( 'name' ); ?>" class="basket"><?php } ?>
                </div>
         	</div>
         </div>
	</section>
    	