<?php
	$html_id = exp_get_element_id($settings);
	$active = intval($settings['active']);
	$accordion = $settings['accordion'];
	if(!empty($accordion)) : 
?>

<!-- Accordian Column -->
<div class="accordian-column p-0 m-0">
    <div class="inner-column">
        <!-- Accordian Box -->
        <ul class="accordion-box">
			<?php foreach ($accordion as $key => $value):
				$is_active = ($key + 1) == $active;
				$title = isset($value['title']) ? $value['title'] : '';
				$desc = isset($value['desc']) ? $value['desc'] : '';
			?>                              
            <!--Block-->
            <li class="accordion block <?php echo esc_attr($is_active ? 'active-block' : ''); ?>">
                <div class="acc-btn <?php echo esc_attr($is_active ? 'active' : ''); ?>">
                    <div class="icon-outer te-title"><span class="icon icon-plus fa fa-plus"></span> <span class="icon icon-minus fa fa-minus"></span></div>
                    <?php echo wp_kses($title, true); ?>
                </div>
                <div class="acc-content <?php echo esc_attr($is_active ? 'current' : ''); ?>">
                    <div class="content">
                        <div class="text te-text"><?php echo wp_kses($desc, true); ?></div>
                    </div>
                </div>
            </li>
            <?php endforeach; ?>
        </ul>
        
    </div>
</div>
<?php endif; ?>