<?php 
$template = (int)$widget->get_setting('content_template','0');
if($template > 0 ){
	if ( !has_action( 'exp_anchor_target_hidden_panel_'.$template) ){
		add_action( 'exp_anchor_target_hidden_panel_'.$template, 'dailyfit_hook_anchor_hidden_panel' );
	} 
}
?>
<div class="exp-anchor-button exp-cursor--cta type-<?php echo esc_attr($settings['icon_type']); ?> <?php echo esc_attr($settings['style'].' '.$settings['exp_animate']); ?> <?php if($template == '1') { echo 'exp-anchor-mobile-menu'; } ?>" data-target=".exp-hidden-template-<?php echo esc_attr($template); ?>" data-delay-hover="<?php echo esc_attr($settings['exp_close_animate_delay']); ?>" data-wow-delay="<?php echo esc_attr($settings['exp_animate_delay']); ?>ms">
	<?php if($settings['icon_type'] == 'default') { ?>
		<div class="exp-anchor-divider">
			<span class="exp-icon-line exp-icon-line1"></span>
			<span class="exp-icon-line exp-icon-line2"></span>
			<span class="exp-icon-line exp-icon-line3"></span>
		</div>
	<?php } elseif($settings['icon_type'] == 'icon' && !empty($settings['exp_icon']['value'])) { ?>
		<?php \Elementor\Icons_Manager::render_icon( $settings['exp_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
		<label class="exp-empty exp-pl-8"><?php echo esc_html($settings['label']); ?></label>
	<?php } elseif($settings['icon_type'] == 'icon-theme') { ?>
		<div class="exp-anchor-theme-style1 <?php echo esc_attr($settings['style_icon_theme']); ?>">
			<div class="exp-anchor-divider">
				<span></span>
				<span></span>
				<span></span>
				<span></span>
			</div>
		</div>
	<?php } ?>
</div>