<?php
	$html_id = exp_get_element_id($settings);
	$counter_value = wp_kses($settings['counter_value'], true);
	
	$opts = [
        'counter_value' => $counter_value, 
    ];
    
    $widget->add_render_attribute( 'coming', [
    'class'         => 'exp-coming-soon',
    'data-settings' => wp_json_encode($opts)
]);
?>
	
    <style id="clock-animations"></style>
    
    <!-- Coming Soon -->
	<section class="coming-soon" <?php if($settings['bg_img']){ ?>style="background-image: url(<?php echo esc_url(wp_get_attachment_url($settings['bg_img']['id']));?>);"<?php };?>>
        <div class="content">
            <div class="content-inner">
                <div class="auto-container">
                    <?php if($settings['logo_img']){ ?>
                    <div class="logo"><a href="<?php echo esc_url(home_url( '/' )); ?>"><img src="<?php echo wp_get_attachment_url($settings['logo_img']['id']);?>" alt="<?php bloginfo( 'name' ); ?>" /></a></div>
                    <?php } ?>
                    <div class="time-counter">
                        <!-- Time Countdown -->
                        <div class="time-countdown clearfix" data-countdown="<?php echo esc_attr( $counter_value ); ?>"></div>

                        <!-- Clock / Bg Clock -->
                        <div class="clock-wrapper">
                            <div class="clock-base">
                                <div class="click-indicator">
                                    <div><span></span></div>
                                    <div><span></span></div>
                                    <div><span></span></div>
                                    <div><span></span></div>
                                    <div><span></span></div>
                                    <div><span></span></div>
                                    <div><span></span></div>
                                    <div><span></span></div>
                                    <div><span></span></div>
                                    <div><span></span></div>
                                    <div><span></span></div>
                                    <div><span></span></div>
                                </div>
                                <div class="clock-hour"></div>
                                <div class="clock-minute"></div>
                                <div class="clock-second"></div>
                                <div class="clock-center"></div>
                            </div>
                        </div>
                    </div>
                    <!--Emailed Form-->
                    <div class="emailed-form">
                        <h3 class="te-title"><?php echo wp_kses( $settings['title'], true );?></h3>
                        <div class="text te-text"><?php echo wp_kses( $settings['text'], true );?></div>
                        
                        <?php if( $settings[ 'show_search_form' ] === 'yes' ){ ?>
                        <?php echo do_shortcode( $settings['form_id'] );?>    
                        <?php } ?>
                    </div>
                    
                    <ul class="social-icon-one te-icons">
                        <?php foreach($settings['social_icon'] as $item):?>
                        <li>
                            <a href="<?php echo esc_url($item['social_link']['url']); ?>" target="_blank" title="facebook">
                        	    <?php \Elementor\Icons_Manager::render_icon( $item['social_icons'], [ 'aria-hidden' => 'true', 'class' => '' ], 'span' ); ?>
                            </a>
                        </li>
                        <?php endforeach;?>
                    </ul>
                    
                </div>
            </div>
        </div>
    </section>
    <!-- End Coming Soon -->