<?php
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
$html_id = exp_get_element_id($settings);
$layout = $settings[ 'layout' ];

$exp_animate = $widget->get_setting('exp_animate', '');
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows','false');
$pagination = $widget->get_setting('pagination','false');
$pagination_type = $widget->get_setting('pagination_type','bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');
$drap = $widget->get_setting('drap');

$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1', 
    'slide_percolumnfill'           => '1', 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => $col_xl,
    'slides_to_show_xxl'             => $col_xxl,  
    'slides_to_show_lg'             => $col_lg, 
    'slides_to_show_md'             => $col_md, 
    'slides_to_show_sm'             => $col_sm, 
    'slides_to_show_xs'             => $col_xs, 
    'slides_to_scroll'              => $slides_to_scroll,  
    'slides_gutter'                 => 30, 
    'arrow'                         => $arrows,
    'pagination'                    => $pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => $autoplay,
    'pause_on_hover'                => $pause_on_hover,
    'pause_on_interaction'          => 'true',
    'delay'                         => $autoplay_speed,
    'loop'                          => $infinite,
    'speed'                         => $speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'exp-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
if(isset($settings['partner']) && !empty($settings['partner']) && count($settings['partner'])): ?>
    
    <!-- ==== testimonial section start ==== -->
    <section class="clients-section p-0 m-0 exp-swiper-sliders exp-post-carousel <?php if($arrows == true) { echo 'exp-arrows-active'; } ?>" <?php if($settings['drap']) : ?>data-cursor-drap="<?php echo esc_html('DRAG', 'dailyfit'); ?>"<?php endif; ?>>
        <div class="sponsors-outer">
            <div class="sponsors-carousel swiper-container swiper exp-carousel-inner">                
                <div <?php exp_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                    <div class="swiper-wrapper exp-swiper-wrapper">
                        <?php foreach ($settings['partner'] as $key => $value): ?>
                        <!-- /.swiper-slide -->
                        <div class="swiper-slide exp-swiper-slide">
                            <div class="slide-item">
                                <figure class="image-box">
                                    <a href="<?php echo esc_url( $value['ext_link']['url']); ?>">
                                        <?php echo Group_Control_Image_Size::get_attachment_image_html( $value, 'thumbnail', 'partner_image' );?>
                                    </a>
                                </figure>
                            </div>                            
                        </div>
                        <!-- /.swiper-slide -->
                        
                        <?php endforeach; ?>
                    </div>
                </div>                    
            
                <?php if($arrows !== 'false'):  ?>
                
                <!-- If we need navigation buttons -->
                <div class="testimonial-one__nav owl-nav">
                    <div class="swiper-button-prev exp-swiper-arrow exp-swiper-arrow-prev exp-swiper-arrow-dark1" id="testimonial-one__swiper-button-next">
                        <i class="icon-arrow-left"></i>
                    </div>
                    <div class="swiper-button-next  exp-swiper-arrow exp-swiper-arrow-next exp-swiper-arrow-dark1" id="testimonial-one__swiper-button-prev">
                        <i class="icon-arrow-right"></i>
                    </div>
                </div>
                
                <?php endif; ?>
                
                <?php if($pagination !== 'false'): ?>
                <div class="testimonial-pagination owl-dots"></div>
                <?php endif; ?>
                
            </div>
        </div>
    </section>
     <!-- ==== / testimonial section end ==== -->
    
<?php endif; ?>