<?php 
 
if(!function_exists('dailyfit_get_post_grid')){
    function dailyfit_get_post_grid($posts = [], $settings = []){ 
        if (empty($posts) || !is_array($posts) || empty($settings) || !is_array($settings)) {
            return false;
        }
        switch ($settings['layout']) {
            case 'post-1':
                dailyfit_get_post_grid_layout1($posts, $settings);
                break;
            
            case 'post-2':
                dailyfit_get_post_grid_layout2($posts, $settings);
                break;
                
            case 'post-3':
                dailyfit_get_post_grid_layout3($posts, $settings);
                break;
            
            case 'portfolio-1':
                dailyfit_get_portfolio_grid_layout1($posts, $settings);
                break;
                
            case 'team-1':
                dailyfit_get_team_grid_layout1($posts, $settings);
                break;
                
            case 'team-2':
                dailyfit_get_team_grid_layout2($posts, $settings);
                break;
            
            case 'service-1':
                dailyfit_get_service_grid_layout1($posts, $settings);
                break;
                
            case 'service-2':
                dailyfit_get_service_grid_layout2($posts, $settings);
                break;
                
            case 'product-1':
                dailyfit_get_product_grid_layout1($posts, $settings);
                break;

            default:
                return false;
                break;
        }
    }
}


// Start Post Grid
//--------------------------------------------------
function dailyfit_get_post_grid_layout1($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '370x260';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "exp-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "exp-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = exp_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = exp_get_image_by_size( array(
                    'post_id'    => $post->ID,
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            }
            $author = get_user_by('id', $post->post_author); 
            $blog_excerpt = get_post_meta($post->ID, 'blog_excerpt', true);
            ?>
            <div class="news-block-two <?php echo esc_attr($item_class ); ?>">
                <div class="inner-box">
                        
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                    <div class="image">
                        <a href="<?php echo esc_url( get_the_permalink( $post->ID ) );?>">
                            <?php echo wp_kses_post($thumbnail); ?>
                        </a>
                    </div>
                    <?php endif; ?>
                    
                    
                    <div class="lower-content">
                        <?php if( $show_category == 'true' ) : ?>
                            <ul class="post-meta">
                                <?php the_terms( $post->ID, 'category', '<li><span class="icon fa fa-folder-open"></span>', ', ', '</li>' ); ?>
                            </ul>
                        <?php endif; ?>
                            
                        <?php if( $show_title == 'true' ) : ?>
                            <h4><a class="te-title" href="<?php echo esc_url(get_the_permalink( $post->ID )); ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h4>
                        <?php endif; ?>
                        
                        <?php if( $show_excerpt == 'true' ) : ?>
                            <div class="text te-text">
                                <?php echo wp_trim_words( $blog_excerpt, $num_words, $more = null ); ?>
                            </div>
                        <?php endif; ?>
                        
                        
                        <div class="lower-box">
                            <div class="clearfix">
                                
                                <?php if( $show_comments == 'yes' ) :
                                        $comment_count = get_comments_number($post->ID); 
                                ?>
                                    <div class="pull-left exp-comments te-comments">
                                        <span class="icon fa fa-comment-o"></span> &nbsp;
                                        <?php if($comment_count > 1) { echo esc_html__('Comments', 'dailyfit'); } ?>
                                        <?php if($comment_count == 1 || $comment_count == 0) { echo esc_html__('0 Comment', 'dailyfit'); } ?>
                                        <?php echo esc_attr($comment_count ); ?>
                                    </div>
                                <?php endif; ?>
                                
                                
                                <?php if( $show_author == 'yes' || $show_date == 'yes' ) : ?>
                                    <div class="pull-right">
                                        
                                            <div class="author-info te-author">
                                                <div class="info-inner">
                                                    
                                                    <?php  if( $show_author == 'yes' ):   ?>
                                                        <div class="icon flaticon-user-4"></div>
                                                        <?php echo esc_html($author->display_name); ?>
                                                    <?php endif;  ?>
                                                    
                                                    <?php  if( $show_date == 'yes' ):   ?>
                                                        <span class="te-date"><?php echo get_the_date('', $post->ID); ?></span>
                                                    <?php endif;  ?>
                                        
                                                </div>
                                                
                                            </div>
                                        
                                    </div>
                                <?php endif; ?>
                                
                            </div>
                        </div>
                        
                    </div>
                   
                </div>
                
            </div>
        <?php
        endforeach;
    endif;
}

function dailyfit_get_post_grid_layout2($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '470x270';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "exp-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "exp-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = exp_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = exp_get_image_by_size( array(
                    'post_id'    => $post->ID,
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            }
            $author = get_user_by('id', $post->post_author); ?>
            <div class="news-block <?php echo esc_attr($item_class ); ?>">
                <div class="news-block-one update-block">
                    <div class="inner-box">
                        
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                        <figure class="image-box">
                            
                            <?php if( $show_date == 'yes' ) : ?>
                                <span class="post-date te-date"><?php echo get_the_date('', $post->ID); ?></span>
                            <?php endif; ?>
                            
                            <a href="<?php echo esc_url(get_the_permalink( $post->ID )); ?>" class="link">
                                <?php echo wp_kses_post($thumbnail); ?>
                            </a>
                        </figure>
                    <?php endif; ?>
                    
                    <div class="lower-content">
                        
                        <?php if( $show_author == 'yes' || $show_comments == 'yes' ) : ?>
                        
                            <ul class="post-info clearfix">
                                <?php if( $show_author == 'yes' ) : ?>
                                    <li class="te-author"><i class="flaticon-user-1"></i> &nbsp; <?php echo esc_html($author->display_name); ?></li>
                                <?php endif; ?>
                                <?php 
                                    if( $show_comments == 'yes' ) :
                                    $comment_count = get_comments_number($post->ID); 
                                ?>
                                <li class="te-comments">
                                    <i class="icon fa fa-comment-o"></i> &nbsp; 
                                    <?php echo esc_attr($comment_count ); ?>
                                    <?php if($comment_count > 1) { echo esc_html__('Comments', 'dailyfit'); } ?>
                                    <?php if($comment_count == 1 || $comment_count == 0) { echo esc_html__('Comment', 'dailyfit'); } ?>
                                </li>
                                <?php endif; ?>
                            </ul>
                        
                        <?php endif; ?>
                        
                        <?php if( $show_title == 'true' ):  ?>
                
                            <h4><a class="te-title" href="<?php echo esc_url(get_the_permalink( $post->ID )); ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h4>
                        
                        <?php endif; ?>
                        
                         <?php if( $show_read_btn == 'yes' ):  ?>
                            <div class="link-btn">
                                <a href="<?php echo esc_url(get_the_permalink( $post->ID )); ?>" class="read-more te-post-btn">
                                    <span class="txt">
                                    <?php  if( $show_read_btn == 'yes' ) :  ?>
                                        <?php echo wp_kses( $btn_title, true );?>
                                    <?php else:?>
                                        <?php esc_html_e('Read More', 'dailyfit');?>
                                    <?php endif;?>
                                    </span>
                                </a>
                            </div>
                        <?php endif; ?>
                        
                    </div>
                    
                </div>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}

function dailyfit_get_post_grid_layout3($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '360x260';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "exp-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "exp-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = exp_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = exp_get_image_by_size( array(
                    'post_id'    => $post->ID,
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            }
            $blog_excerpt = get_post_meta($post->ID, 'blog_excerpt', true);
            ?>
            <div class="news-block <?php echo esc_attr($item_class ); ?>">
                <div class="news-block-one update-block">
                    <div class="inner-box">
                        
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                        <div class="image">
                            <a href="<?php echo esc_url(get_the_permalink( $post->ID )); ?>" class="link">
                                <?php echo wp_kses_post($thumbnail); ?>
                            </a>
                             <?php if( $show_date == 'yes' ) : ?>
                                <div class="post-date te-date"><?php echo get_the_date('j', $post->ID); ?><span><?php echo get_the_date('M', $post->ID); ?></span></span></div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    
                    <div class="lower-content">
                        
                        <?php if( $show_title == 'true' ):  ?>
                
                            <h4><a class="te-title" href="<?php echo esc_url(get_the_permalink( $post->ID )); ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h4>
                        
                        <?php endif; ?>
                        
                        <?php if( $show_excerpt == 'true' ) : ?>
                            <div class="text te-text">
                                <?php echo wp_trim_words( $blog_excerpt, $num_words, $more = null ); ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if( $show_read_btn == 'yes' ):  ?>
                            <div class="btn-two-outer">
                                <a href="<?php echo esc_url(get_the_permalink( $post->ID )); ?>" class="theme-btn btn-style-two">
                                    <span class="txt">
                                    <?php  if( $show_read_btn == 'yes' ) :  ?>
                                        <?php echo wp_kses( $btn_title, true );?>
                                    <?php else:?>
                                        <?php esc_html_e('Read More', 'dailyfit');?>
                                    <?php endif;?>
                                    </span>
                                </a>
                            </div>
                        <?php endif; ?>
                        
                    </div>
                    
                </div>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}


// End Post Grid
//--------------------------------------------------

// Start Portfolio Grid
//--------------------------------------------------
function dailyfit_get_portfolio_grid_layout1($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '370x370';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $portfolio_external_link = get_post_meta($post->ID, 'portfolio_external_link', true);
            $item_class = "exp-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "exp-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            $img_id = get_post_thumbnail_id($post->ID);
            $post_thumbnail_url = wp_get_attachment_url($img_id);
            if($img_id) {
                $img = exp_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            } ?>
            <div class="gallery-block <?php echo esc_attr($item_class); ?>">
                <div class="inner-box">
                    <div class="image">
                        <?php echo wp_kses_post($thumbnail); ?>
                        <div class="content">
                            <?php if( $show_title ):  ?>
                                <div class="content-inner">
                                    <h5><a class="te-title" href="<?php if(!empty($portfolio_external_link)) { echo esc_url($portfolio_external_link); } else { echo esc_url(get_the_permalink( $post->ID )); } ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h5>
                                    <a href="<?php if(!empty($portfolio_external_link)) { echo esc_url($portfolio_external_link); } else { echo esc_url(get_the_permalink( $post->ID )); } ?>" class="icon fa fa-arrow-circle-o-right"></a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>                    
            </div>
        <?php
        endforeach;
    endif;
}


// Start Team Grid
//--------------------------------------------------
function dailyfit_get_team_grid_layout1($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '320x469';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "exp-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "exp-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = exp_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            }
            $social_media = get_post_meta($post->ID, 'social_media_tabs', true);
            ?>
            <div class="team-block <?php echo esc_attr($item_class); ?>">
                <div class="inner-box wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                    <div class="image">
                        <a href="<?php echo esc_url( the_permalink( $post->ID ) );?>">
                            <?php echo wp_kses_post($thumbnail); ?>
                        </a>
                    </div>
                    <?php endif; ?>
                    
                    <?php if( $show_designation || $show_title ):  ?>
                    <div class="content">
                        <?php if( $show_designation ):  ?>
                        <div class="title te-designation"><?php echo (get_post_meta( $post->ID, 'designation', true ));  ?></div>
                        <?php endif; ?>
                        
                        <?php if ( $show_title ) :  ?>
                        <a href="<?php echo esc_url( the_permalink( $post->ID ) );?>" class="name te-title"><?php echo get_the_title($post->ID); ?></a>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                    
                    <?php if ( $show_social && ! empty( $social_media ) ) : ?>
                    <div class="shared-boxed">
                        <div class="shared-inner">
                            <span class="share-now fa fa-share-alt"></span>
                            <?php  
                            for ( $i=0; $i < count( $social_media['select_social_media'] ); $i++ ) {
                                $social_icon = ( isset( $social_media['select_social_media'][$i] ) && !empty( $social_media['select_social_media'][$i] ) ) ? $social_media['select_social_media'][$i] : '';
                                $social_link = ( isset( $social_media['link_social_media'][$i] ) && !empty( $social_media['link_social_media'][$i] ) ) ? $social_media['link_social_media'][$i] : '';
                            ?>
                            <a target="_blank" href="<?php echo esc_url($social_link); ?>"><span class="fa <?php echo esc_attr($social_icon); ?>"></span></a>
                            <?php }  ?>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}

function dailyfit_get_team_grid_layout2($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '320x469';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "exp-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "exp-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = exp_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            }
            $social_media = get_post_meta($post->ID, 'social_media_tabs', true);
            ?>
            
            <!-- Team Block Two -->
            <div class="team-block-two <?php echo esc_attr($item_class); ?>">
                <div class="inner-box wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                    <div class="image">
                        <a href="<?php echo esc_url( the_permalink( $post->ID ) );?>">
                            <?php echo wp_kses_post($thumbnail); ?>
                        </a>
                    </div>
                    <?php endif; ?>
                    
                    <?php if( $show_designation || $show_title ):  ?>
                    <div class="content">
                        <?php if( $show_designation ):  ?>
                        <div class="title te-designation"><?php echo (get_post_meta( $post->ID, 'designation', true ));  ?></div>
                        <?php endif; ?>
                        
                        <?php if ( $show_title ) :  ?>
                        <a href="<?php echo esc_url( the_permalink( $post->ID ) );?>" class="name te-title"><?php echo get_the_title($post->ID); ?></a>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                    
                    <div class="side-title"><?php the_terms( $post->ID, 'team-category', '', ', ', '' ); ?></div>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}

// End Team Grid
//--------------------------------------------------

// Start Service Grid
//--------------------------------------------------
function dailyfit_get_service_grid_layout1($posts = [], $settings = []){
    extract($settings);

    if (is_array($posts)):
        $count = 1;
        foreach ($posts as $key => $post): 
            $item_class = "exp-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "exp-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = exp_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $service_excerpt = get_post_meta($post->ID, 'service_excerpt', true);
            $service_external_link = get_post_meta($post->ID, 'service_external_link', true);
            $service_icon_type = get_post_meta($post->ID, 'service_icon_type', true);
            $service_icon_font = get_post_meta($post->ID, 'service_icon_font', true);
            $service_icon_img = get_post_meta($post->ID, 'service_icon_img', true);
            ?>
            <div class="service-block-two <?php echo esc_attr($item_class); ?>">
                <div class="inner-box wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                    <?php if($service_icon_type == 'icon' && !empty($service_icon_font)) : ?>
                    <div class="icon-box te-icons">
                        <span class="icon <?php echo esc_attr($service_icon_font); ?>"></span>
                    </div>
                    <?php endif; ?>
                    
                    <?php if($service_icon_type == 'image' && !empty($service_icon_img)) : 
                    $icon_img = exp_get_image_by_size( array(
                        'attach_id'  => $service_icon_img['id'],
                        'thumb_size' => 'full',
                    ));
                    $icon_thumbnail = $icon_img['thumbnail'];
                    ?>
                    <div class="te-icons icon-box">
                        <?php echo wp_kses_post($icon_thumbnail); ?>
                    </div>
                    <?php endif; ?>
                    
                    <span class="number te-number"><?php $count = sprintf('%02d', $count); echo wp_kses_post($count); ?></span>
                    <div class="title te-subtitle"><?php the_terms( $post->ID, 'service-category', '', ', ', '' ); ?></div>
                    <h4><a class="te-title" href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_the_permalink( $post->ID)); } ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h4>
                    <?php if($show_excerpt == 'true' && !empty($service_excerpt)): ?>
                    <div class="text te-text"><?php echo wp_trim_words( $service_excerpt, $num_words, $more = null ); ?></div>
                    <?php endif; ?>
                    
                </div>
            </div>
        <?php
        $count++; endforeach;
    endif;
}

function dailyfit_get_service_grid_layout2($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '370x370';

    if (is_array($posts)):
        foreach ($posts as $key => $post): 
            $item_class = "exp-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "exp-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }
            
            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = exp_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            }

            if(!empty($tax))
                $filter_class = exp_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $service_excerpt = get_post_meta($post->ID, 'service_excerpt', true);
            $service_external_link = get_post_meta($post->ID, 'service_external_link', true);
            $service_icon_type = get_post_meta($post->ID, 'service_icon_type', true);
            $service_icon_font = get_post_meta($post->ID, 'service_icon_font', true);
            $service_icon_img = get_post_meta($post->ID, 'service_icon_img', true);
            ?>
            <div class="classess-block <?php echo esc_attr($item_class); ?>">
                <div class="inner-box">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                    <div class="image">
                        <a href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_the_permalink( $post->ID)); } ?>">
                            <?php echo wp_kses_post($thumbnail); ?>
                        </a>
                        
                        <?php if($service_icon_type == 'icon' && !empty($service_icon_font)) : ?>
                        <div class="icon-box">
                            <span class="icon te-author <?php echo esc_attr($service_icon_font); ?>"></span>
                        </div>
                        <?php endif; ?>
                        
                        <?php if($service_icon_type == 'image' && !empty($service_icon_img)) : 
                            $icon_img = exp_get_image_by_size( array(
                                'attach_id'  => $service_icon_img['id'],
                                'thumb_size' => 'full',
                            ));
                            $icon_thumbnail = $icon_img['thumbnail'];
                            ?>
                            <div class="icon-box">
                                <div class="icon te-author"><?php echo wp_kses_post($icon_thumbnail); ?></div>
                            </div>
                        <?php endif; ?>
                    </div>
                     <?php endif; ?>
                    <div class="lower-content">
                        <div class="title te-subtitle"><?php the_terms( $post->ID, 'service-category', '', ', ', '' ); ?></div>
                        <h4><a class="te-title" href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_the_permalink( $post->ID)); } ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a></h4>
                        <?php if($show_excerpt == 'true' && !empty($service_excerpt)): ?>
                        <div class="te-text text"><?php echo wp_trim_words( $service_excerpt, $num_words, $more = null ); ?></div>
                        <?php endif; ?>
                        <a href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_the_permalink( $post->ID)); } ?>" class="read-more te-post-btn">
						    <?php echo wp_kses( $btn_title, true );?>
                        </a>
                    </div>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}

// End Service Grid
//--------------------------------------------------

// Start Product Grid
//--------------------------------------------------
function dailyfit_get_product_grid_layout1($posts = [], $settings = []){ 
    extract($settings);

    $images_size = !empty($img_size) ? $img_size : '600x600';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "exp-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "exp-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = exp_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $product = wc_get_product( $post->ID ); ?>
            <div class="<?php echo esc_attr($item_class); ?>">
                <div class="exp-item--inner" data-wow-duration="1.2s">
                    <div class="woocommerce-product-inner">
                        <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): 
                            $img_id = get_post_thumbnail_id($post->ID);
                            $img = dailyfit_get_image_by_size( array(
                                'attach_id'  => $img_id,
                                'thumb_size' => $images_size,
                                'class' => 'no-lazyload',
                            ));
                            $thumbnail = $img['thumbnail'];
                            ?>
                            <div class="woocommerce-product-header">
                                <a class="woocommerce-product-details" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                    <?php echo wp_kses_post($thumbnail); ?>
                                </a>
                                <div class="woocommerce-product-meta">
                                    <div class="woocommerce-add-to-cart">
                                        <?php
                                        echo apply_filters( 'woocommerce_loop_add_to_cart_link',
                                            sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" class="button ajax_add_to_cart %s product_type_%s">%s</a>',
                                                esc_url( $product->add_to_cart_url() ),
                                                esc_attr( $product->get_id() ),
                                                esc_attr( $product->get_sku() ),
                                                $product->is_purchasable() ? 'add_to_cart_button' : '',
                                                esc_attr( $product->get_type() ),
                                                esc_html( $product->add_to_cart_text() )
                                            ),
                                            $product );
                                        ?>
                                    </div>
                                    <?php if (class_exists('WPCleverWoosc')) { ?>
                                        <div class="woocommerce-compare">
                                            <?php echo do_shortcode('[woosc id="'.esc_attr( $product->get_id() ).'"]'); ?>
                                        </div>
                                    <?php } ?>
                                    <?php if (class_exists('WPCleverWoosw')) { ?>
                                        <div class="woocommerce-wishlist">
                                            <?php echo do_shortcode('[woosw id="'.esc_attr( $product->get_id() ).'"]'); ?>
                                        </div>
                                    <?php } ?>
                                    <?php if (class_exists('WPCleverWoosq')) { ?>
                                        <div class="woocommerce-quick-view">
                                            <?php echo do_shortcode('[woosq id="'.esc_attr( $product->get_id() ).'"]'); ?>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="woocommerce-product-content">
                            <?php if($show_category == 'true'): ?>
                                <div class="woocommerce-product-category">
                                    <?php the_terms( $post->ID, 'product_cat', '', ', ' ); ?>
                                </div>
                            <?php endif; ?>
                            <h4 class="woocommerce-product--title">
                                <a class="te-title" href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_html(get_the_title($post->ID)); ?></a>
                            </h4>
                            <?php if($show_price == 'true'): ?>
                                <span class="woocommerce-product--price"><?php echo wp_kses_post($product->get_price_html()); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}
// End Product Grid
//--------------------------------------------------

add_action( 'wp_ajax_dailyfit_get_pagination_html', 'dailyfit_get_pagination_html' );
add_action( 'wp_ajax_nopriv_dailyfit_get_pagination_html', 'dailyfit_get_pagination_html' );
function dailyfit_get_pagination_html(){
    try{
        if(!isset($_POST['query_vars'])){
            throw new Exception(__('Something went wrong while requesting. Please try again!', 'dailyfit'));
        }
        $query = new WP_Query($_POST['query_vars']);
        ob_start();
        dailyfit()->page->get_pagination( $query,  true );
        $html = ob_get_clean();
        wp_send_json(
            array(
                'status' => true,
                'message' => esc_attr__('Load Successfully!', 'dailyfit'),
                'data' => array(
                    'html' => $html,
                    'query_vars' => $_POST['query_vars'],
                    'post' => $query->have_posts()
                ),
            )
        );
    }
    catch (Exception $e){
        wp_send_json(array('status' => false, 'message' => $e->getMessage()));
    }
    die;
}

add_action( 'wp_ajax_dailyfit_load_more_post_grid', 'dailyfit_load_more_post_grid' );
add_action( 'wp_ajax_nopriv_dailyfit_load_more_post_grid', 'dailyfit_load_more_post_grid' );
function dailyfit_load_more_post_grid(){
    try{
        if(!isset($_POST['settings'])){
            throw new Exception(__('Something went wrong while requesting. Please try again!', 'dailyfit'));
        }
        $settings = $_POST['settings'];
        set_query_var('paged', $settings['paged']);
        extract(exp_get_posts_of_grid($settings['post_type'], [
            'source' => isset($settings['source'])?$settings['source']:'',
            'orderby' => isset($settings['orderby'])?$settings['orderby']:'date',
            'order' => isset($settings['order'])?$settings['order']:'desc',
            'limit' => isset($settings['limit'])?$settings['limit']:'6',
            'post_ids' => isset($settings['post_ids'])?$settings['post_ids']:[],
        ]));
        ob_start();
         
        dailyfit_get_post_grid($posts, $settings);
        $html = ob_get_clean();
        wp_send_json(
            array(
                'status' => true,
                'message' => esc_attr__('Load Successfully!', 'dailyfit'),
                'data' => array(
                    'html' => $html,
                    'paged' => $settings['paged'],
                    'posts' => $posts,
                    'max' => $max,
                ),
            )
        );
    }
    catch (Exception $e){
        wp_send_json(array('status' => false, 'message' => $e->getMessage()));
    }
    die;
}

add_action( 'wp_ajax_dailyfit_get_filter_html', 'dailyfit_get_filter_html' );
add_action( 'wp_ajax_nopriv_dailyfit_get_filter_html', 'dailyfit_get_filter_html' );
function dailyfit_get_filter_html(){
    try{
        if(!isset($_POST['settings'])){
            throw new Exception(__('Something went wrong while requesting. Please try again!', 'dailyfit'));
        }
        $settings = $_POST['settings'];
        $loadmore_filter = $_POST['loadmore_filter'];
        if($loadmore_filter == '1'){
            set_query_var('paged', 1);
            $limit = isset($settings['limit'])?$settings['limit']:'6';
            $limitx = (int)$limit * (int)$settings['paged'];
        }else{
            set_query_var('paged', $settings['paged']);
            $limitx = isset($settings['limit'])?$settings['limit']:'6';
        }
        extract(exp_get_posts_of_grid($settings['post_type'], [
                'source' => isset($settings['source'])?$settings['source']:'',
                'orderby' => isset($settings['orderby'])?$settings['orderby']:'date',
                'order' => isset($settings['order'])?$settings['order']:'desc',
                'limit' => $limitx,
                'post_ids' => isset($settings['post_ids'])?$settings['post_ids']: [],
            ],
            $settings['tax']
        ));
        ob_start(); ?>
        
        <span class="filter-item active" data-filter="*">
            <?php echo esc_html($settings['filter_default_title']); ?>
            <?php if($settings['show_cat_count'] == '1'): ?>
                <span class="filter-item-count"><?php echo count($posts); ?></span> 
            <?php endif; ?>
        </span>
        <?php foreach ($categories as $category):
            $category_arr = explode('|', $category);
            $term = get_term_by('slug',$category_arr[0], $category_arr[1]);
            $tax_count = 0;
            foreach ($posts as $key => $post){
                $this_terms = get_the_terms( $post->ID,  $settings['tax'][0] );
                $term_list = [];
                foreach ($this_terms as $t) {
                    $term_list[] = $t->slug;
                } 
                if(in_array($term->slug,$term_list))
                    $tax_count++;
            } 
            if($tax_count > 0): ?>
                <span class="filter-item" data-filter="<?php echo esc_attr('.' . $term->slug); ?>">
                    <?php echo esc_html($term->name); ?>
                    <?php if($settings['show_cat_count'] == '1'): ?>
                        <span class="filter-item-count"><?php echo esc_html($tax_count); ?></span> 
                    <?php endif; ?>
                </span>
            <?php endif; ?>
        <?php endforeach; ?>

        <?php $html = ob_get_clean();
        wp_send_json(
            array(
                'status' => true,
                'message' => esc_attr__('Load Successfully!', 'dailyfit'),
                'data' => array(
                    'html' => $html,
                    'paged' => $settings['paged'],
                    'posts' => $posts,
                    'max' => $max,
                ),
            )
        );
    }
    catch (Exception $e){
        wp_send_json(array('status' => false, 'message' => $e->getMessage()));
    }
    die;
}