<?php 
/* Start Section */
add_action( 'elementor/element/section/section_structure/after_section_end', 'dailyfit_add_custom_section_controls' ); 
add_action( 'elementor/element/section/section_structure/after_section_end', 'dailyfit_add_custom_section_overlay_color' ); 
add_action( 'elementor/element/section/section_structure/after_section_end', 'dailyfit_add_custom_section_overlay_img' ); 
add_action( 'elementor/element/section/section_structure/after_section_end', 'dailyfit_add_custom_section_divider' ); 
add_action( 'elementor/element/section/section_structure/after_section_end', 'dailyfit_add_custom_section_particles' );
function dailyfit_add_custom_section_controls( \Elementor\Element_Base $element) {
     
    $element->start_controls_section(
        'section_exp',
        [
            'label' => esc_html__( 'Dailyfit General Settings', 'dailyfit' ),
            'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
        ]
    );
 
    $element->add_control(
        'row_mouse_move_animation',
        [
            'label'   => esc_html__( 'Mouse Move Animation', 'dailyfit' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => array(
                ''        => esc_html__( 'No', 'dailyfit' ),
                'yes'   => esc_html__( 'Yes', 'dailyfit' ),
            ),
            'default'      => '',
            'prefix_class' => 'exp-mouse-animation-',
        ]
    );

    $element->add_control(
        'header_layout_type',
        [
            'label'   => esc_html__( 'Row Shape', 'dailyfit' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => array(
                'none'        => esc_html__( 'None', 'dailyfit' ),
                'clip'   => esc_html__( 'Clip', 'dailyfit' ),
            ),
            'prefix_class' => 'exp-type-header-',
            'default'      => 'none',
        ]
    );

    $element->add_control(
        'row_scroll_fixed',
        [
            'label'   => esc_html__( 'Column Fixed', 'dailyfit' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => array(
                'none'        => esc_html__( 'No', 'dailyfit' ),
                'fixed'   => esc_html__( 'Yes', 'dailyfit' ),
            ),
            'prefix_class' => 'exp-row-scroll-',
            'default'      => 'none',      
        ]
    );

    $element->add_control(
        'full_content_with_space',
        [
          'label' => esc_html__( 'Full Content with space from?', 'dailyfit' ),
          'type'         => \Elementor\Controls_Manager::SELECT,
                'prefix_class' => 'exp-full-content-with-space-',
                'options'      => array(
                    'none'    => esc_html__( 'None', 'dailyfit' ),
                    'start'   => esc_html__( 'Start', 'dailyfit' ),
                    'end'     => esc_html__( 'End', 'dailyfit' ),
                ),
                'default'      => 'none',
                'condition' => [
                    'layout' => 'full_width'
                ]
        ]
    );
       
    $element->add_control(
        'exp_container_width',
        [
                'label' => esc_html__('Container Width', 'dailyfit'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 1200,
                'condition' => [
                  'layout' => 'full_width',
                    'full_content_with_space!' => 'none'
                ]           
        ]
    );
      
    $element->end_controls_section();
};
function dailyfit_add_custom_section_overlay_color( \Elementor\Element_Base $element) {
     
    $element->start_controls_section(
        'section_overlay_color',
        [
            'label' => esc_html__( 'Dailyfit Overlay Color', 'dailyfit' ),
            'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
        ]
    );
 
    $element->add_control(
        'exp_color_offset',
        [
            'label'   => esc_html__( 'Overlay Color', 'dailyfit' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => array(
                'none'        => esc_html__( 'No', 'dailyfit' ),
                'left'   => esc_html__( 'Left Space', 'dailyfit' ),
                'right'   => esc_html__( 'Right Space', 'dailyfit' ),
                'skew'   => esc_html__( 'Skew', 'dailyfit' ),
            ),
            'prefix_class' => 'exp-bg-color-',
            'default'      => 'none',
        ]
    );

    $element->add_control(
        'overlay_left_space',
        [
            'label' => esc_html__('Overlay Left Space', 'dailyfit' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}}.exp-bg-color-left::before' => 'left: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'exp_color_offset' => ['left'],
            ],
        ]
    );

    $element->add_control(
        'overlay_right_space',
        [
            'label' => esc_html__('Overlay Right Space', 'dailyfit' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}}.exp-bg-color-right::before' => 'right: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'exp_color_offset' => ['right'],
            ],
        ]
    );

    $element->add_control(
        'offset_color',
        [
            'label' => esc_html__('Overlay Color', 'dailyfit' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.exp-bg-color-left:before, {{WRAPPER}}.exp-bg-color-right:before, {{WRAPPER}}.exp-bg-color-skew:before' => 'background-color: {{VALUE}};',
            ],
            'condition' => [
                'exp_color_offset' => ['left','right','skew'],
            ],
        ]
    );

    $element->add_control(
        'overlay_broder_radius',
        [
            'label' => esc_html__('Overlay Border Radius', 'dailyfit' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}}.exp-bg-color-left:before, {{WRAPPER}}.exp-bg-color-right:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'condition' => [
                'exp_color_offset' => ['left','right'],
            ],
        ]
    );
      
    $element->end_controls_section();
};

function dailyfit_add_custom_section_overlay_img( \Elementor\Element_Base $element) {
     
    $element->start_controls_section(
        'section_overlay_img',
        [
            'label' => esc_html__( 'Dailyfit Overlay Image', 'dailyfit' ),
            'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
        ]
    );
 
    $element->add_control(
        'exp_overlay_display',
        [
            'label'   => esc_html__( 'Overlay Image', 'dailyfit' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => array(
                'none'        => esc_html__( 'No', 'dailyfit' ),
                'image'   => esc_html__( 'Yes', 'dailyfit' ),
            ),
            'prefix_class' => 'exp-section-overlay-',
            'default'      => 'none',
        ]
    );

    $element->add_control(
        'exp_overlay_img',
        [
            'label'   => esc_html__( 'Select Image', 'dailyfit' ),
            'type'    => \Elementor\Controls_Manager::MEDIA,
            'condition' => [
                'exp_overlay_display' => ['image'],
            ],
        ]
    );
      
    $element->end_controls_section();
};

function dailyfit_add_custom_section_divider( \Elementor\Element_Base $element) {
     
    $element->start_controls_section(
        'section_divider',
        [
            'label' => esc_html__( 'Dailyfit Divider', 'dailyfit' ),
            'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
        ]
    );
 
    $element->add_control(
        'row_divider',
        [
            'label'   => esc_html__( 'Divider', 'dailyfit' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => array(
                ''        => esc_html__( 'None', 'dailyfit' ),
                'angle-top'   => esc_html__( 'Angle Top Left', 'dailyfit' ),
                'angle-top-right'   => esc_html__( 'Angle Top Right', 'dailyfit' ),
                'angle-bottom-left'   => esc_html__( 'Angle Bottom Left', 'dailyfit' ),
                'angle-bottom'   => esc_html__( 'Angle Bottom Right', 'dailyfit' ),
                'angle-top-bottom'   => esc_html__( 'Angle Top & Bottom Right', 'dailyfit' ),
                'angle-top-bottom-left'   => esc_html__( 'Angle Top & Bottom Left', 'dailyfit' ),
                'wave-animation-top'   => esc_html__( 'Wave Animation Top', 'dailyfit' ),
                'wave-animation-bottom'   => esc_html__( 'Wave Animation Bottom 1', 'dailyfit' ),
                'wave-animation-bottom2'   => esc_html__( 'Wave Animation Bottom 2', 'dailyfit' ),
                'curved-top'   => esc_html__( 'Curved Top', 'dailyfit' ),
                'curved-bottom'   => esc_html__( 'Curved Bottom', 'dailyfit' ),
                'vertical1'   => esc_html__( 'Divider Vertical', 'dailyfit' ),
            ),
            'prefix_class' => 'exp-row-divider-active exp-row-divider-',
            'default'      => '',
        ]
    );

    $element->add_control(
        'divider_color',
        [
            'label' => esc_html__('Divider Color', 'dailyfit' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .exp-row-angle, {{WRAPPER}} .exp-wave-parallax > use' => 'fill: {{VALUE}} !important;',
                '{{WRAPPER}} .exp-divider-vertical > div' => 'background-color: {{VALUE}} !important;',
            ],
        ]
    );

    $element->add_responsive_control(
        'divider_height',
        [
            'label' => esc_html__('Divider Height', 'dailyfit' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .exp-row-angle, {{WRAPPER}} .exp-section-waves' => 'height: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'row_divider!' => ['vertical1'],
            ],     
        ]
    );
      
    $element->end_controls_section();
};

function dailyfit_add_custom_section_particles( \Elementor\Element_Base $element) {
     
    $element->start_controls_section(
        'section_particles',
        [
            'label' => esc_html__( 'Dailyfit Particles', 'dailyfit' ),
            'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
        ]
    );

    $element->add_control(
        'row_particles_display',
        [
            'label'   => esc_html__( 'Particles', 'dailyfit' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => 'false',  
        ]
    );

    $element->add_control(
        'number',
        [
                'label' => esc_html__('Number', 'dailyfit'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 4,      
                'condition' => [
                    'row_particles_display' => ['yes'],
                ],     
        ]
    );

    $element->add_control(
        'size',
        [
                'label' => esc_html__('Size', 'dailyfit'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 3, 
                'condition' => [
                    'row_particles_display' => ['yes'],
                ],           
        ]
    );

    $element->add_control(
        'size_random',
        [
                'label' => esc_html__('Size Random', 'dailyfit'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'false',
                'condition' => [
                    'row_particles_display' => ['yes'],
                ],   
        ]
    );

    $element->add_control(
        'move_direction',
        [
            'label'   => esc_html__( 'Move Direction', 'dailyfit' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => array(
                'none'        => esc_html__( 'None', 'dailyfit' ),
                'top'        => esc_html__( 'Top', 'dailyfit' ),
                'top-right'        => esc_html__( 'Top Right', 'dailyfit' ),
                'right'        => esc_html__( 'Right', 'dailyfit' ),
                'bottom-right'        => esc_html__( 'Bottom Right', 'dailyfit' ),
                'bottom'        => esc_html__( 'Bottom', 'dailyfit' ),
                'bottom-left'        => esc_html__( 'Bottom Left', 'dailyfit' ),
                'left'        => esc_html__( 'Left', 'dailyfit' ),
                'top-left'        => esc_html__( 'Top Left', 'dailyfit' ),
            ),
            'default'      => 'none',
            'condition' => [
                'row_particles_display' => ['yes'],
            ],  
        ]
    );

    $repeater = new \Elementor\Repeater();
    $repeater->add_control(
        'particle_color', 
        [
            'label' => esc_html__('Color', 'dailyfit' ),
            'type' => \Elementor\Controls_Manager::COLOR,
        ]
    );
    $element->add_control(
        'particle_color_item',
        [
            'label' => esc_html__('Color', 'dailyfit'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [],
            'condition' => [
                'row_particles_display' => ['yes'],
            ],    
        ]
    );
      
    $element->end_controls_section();
};

/* End Section */

/* Start Column */
add_action( 'elementor/element/column/layout/after_section_end', 'dailyfit_add_custom_columns_controls' ); 
function dailyfit_add_custom_columns_controls( \Elementor\Element_Base $element) {
    $element->start_controls_section(
        'columns_exp',
        [
            'label' => esc_html__( 'Dailyfit General Settings', 'dailyfit' ),
            'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
        ]
    );
    $element->add_control(
        'col_line',
        [
            'label'   => esc_html__( 'Column Line Style', 'dailyfit' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => array(
                'none'           => esc_html__( 'None', 'dailyfit' ),
                'line1'           => esc_html__( 'Line 1', 'dailyfit' ),
                'line2'           => esc_html__( 'Line 2', 'dailyfit' ),
            ),
            'default' => 'none',
            'prefix_class' => 'exp-col-'
        ]
    );

    $element->add_control(
        'col_line_color',
        [
            'label' => esc_html__('Column Line Color', 'dailyfit' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.exp-col-line2:before' => 'background-color: {{VALUE}};',
            ],
            'condition' => [
                'col_line' => ['line2'],
            ],
        ]
    );

    $element->add_control(
        'col_line_height',
        [
            'label' => esc_html__('Column Line Height', 'dailyfit' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}}.exp-col-line2:before' => 'height: {{SIZE}}{{UNIT}};',
            ],
            'condition' => [
                'col_line' => ['line2'],
            ],
        ]
    );

    $element->add_control(
        'col_content_align',
        [
            'label'   => esc_html__( 'Column Content Align', 'dailyfit' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => array(
                ''           => esc_html__( 'Default', 'dailyfit' ),
                'start'           => esc_html__( 'Start', 'dailyfit' ),
                'center'           => esc_html__( 'Center', 'dailyfit' ),
                'end'           => esc_html__( 'End', 'dailyfit' ),
            ),
            'default' => '',
            'prefix_class' => 'exp-col-align-'
        ]
    );
    $element->add_control(
        'col_sticky',
        [
            'label'   => esc_html__( 'Column Sticky', 'dailyfit' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => array(
                'none'           => esc_html__( 'No', 'dailyfit' ),
                'sticky' => esc_html__( 'Yes', 'dailyfit' ),
            ),
            'default' => 'none',
            'prefix_class' => 'exp-column-'
        ]
    );
    $element->end_controls_section();
}

/* End Column */

add_action( 'elementor/element/after_add_attributes', 'dailyfit_custom_el_attributes', 10, 1 );
function dailyfit_custom_el_attributes($el){
    if( 'section' !== $el->get_name() ) {
        return;
    }
    $settings = $el->get_settings();

    $exp_container_width = !empty($settings['exp_container_width']) ? (int)$settings['exp_container_width'] : 1200;

    if( isset( $settings['stretch_section']) && $settings['stretch_section'] == 'section-stretched') 
        $exp_container_width = $exp_container_width - 30;

    $exp_container_width = $exp_container_width.'px';

    if ( isset( $settings['full_content_with_space'] ) && $settings['full_content_with_space'] === 'start' ) {
       
        $el->add_render_attribute( '_wrapper', 'style', 'padding-left: calc( (100% - '.$exp_container_width.')/2);');
    }
    if ( isset( $settings['full_content_with_space'] ) && $settings['full_content_with_space'] === 'end' ) {
       
          $el->add_render_attribute( '_wrapper >', 'style', 'padding-right: calc( (100% - '.$exp_container_width.')/2);');
    }
}

add_filter( 'exp-custom-section/before-render', 'dailyfit_custom_section_before_render', 10, 3 );
function dailyfit_custom_section_before_render($html ,$settings, $el) {
    if(!empty($settings['row_mouse_move_animation']) && $settings['row_mouse_move_animation'] == 'yes') {
        $html .= '<div class="exp-cursor-section"><div class="exp-cursor-wrapper"><div class="exp-cursor--follower exp-js-follower"></div></div></div>';
    }

    if(!empty($settings['row_divider'])) {
        if($settings['row_divider'] == 'angle-top' || $settings['row_divider'] == 'angle-bottom' || $settings['row_divider'] == 'angle-top-right' || $settings['row_divider'] == 'angle-bottom-left') {
            $html .=  '<svg class="exp-row-angle" style="fill:#ffffff" xmlns="http://www.w3.org/2000/svg" width="100%" viewBox="0 0 100 100" version="1.1" preserveAspectRatio="none" height="130px"><path stroke="" stroke-width="0" d="M0 100 L100 0 L200 100"></path></svg>';
        }
        if($settings['row_divider'] == 'angle-top-bottom' || $settings['row_divider'] == 'angle-top-bottom-left') {
            $html .=  '<svg class="exp-row-angle exp-row-angle-top" style="fill:#ffffff" xmlns="http://www.w3.org/2000/svg" width="100%" viewBox="0 0 100 100" version="1.1" preserveAspectRatio="none" height="130px"><path stroke="" stroke-width="0" d="M0 100 L100 0 L200 100"></path></svg><svg class="exp-row-angle exp-row-angle-bottom" style="fill:#ffffff" xmlns="http://www.w3.org/2000/svg" width="100%" viewBox="0 0 100 100" version="1.1" preserveAspectRatio="none" height="130px"><path stroke="" stroke-width="0" d="M0 100 L100 0 L200 100"></path></svg>';
        }
        if($settings['row_divider'] == 'wave-animation-top' || $settings['row_divider'] == 'wave-animation-bottom') {
            $html .=  '<svg class="exp-row-angle" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none" viewBox="0 0 1440 150" fill="#fff"><path d="M 0 26.1978 C 275.76 83.8152 430.707 65.0509 716.279 25.6386 C 930.422 -3.86123 1210.32 -3.98357 1439 9.18045 C 2072.34 45.9691 2201.93 62.4429 2560 26.198 V 172.199 L 0 172.199 V 26.1978 Z"><animate repeatCount="indefinite" fill="freeze" attributeName="d" dur="10s" values="M0 25.9086C277 84.5821 433 65.736 720 25.9086C934.818 -3.9019 1214.06 -5.23669 1442 8.06597C2079 45.2421 2208 63.5007 2560 25.9088V171.91L0 171.91V25.9086Z; M0 86.3149C316 86.315 444 159.155 884 51.1554C1324 -56.8446 1320.29 34.1214 1538 70.4063C1814 116.407 2156 188.408 2560 86.315V232.317L0 232.316V86.3149Z; M0 53.6584C158 11.0001 213 0 363 0C513 0 855.555 115.001 1154 115.001C1440 115.001 1626 -38.0004 2560 53.6585V199.66L0 199.66V53.6584Z; M0 25.9086C277 84.5821 433 65.736 720 25.9086C934.818 -3.9019 1214.06 -5.23669 1442 8.06597C2079 45.2421 2208 63.5007 2560 25.9088V171.91L0 171.91V25.9086Z"></animate></path></svg>';
        }
        if($settings['row_divider'] == 'wave-animation-bottom2') {
            $exp_uniqid = uniqid();
            $html .=  '<svg class="exp-section-waves exp-section-waves1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"viewBox="0 24 150 28" preserveAspectRatio="none" shape-rendering="auto"><defs><path id="exp-gentle-wave-'.$exp_uniqid.'" d="M-160 44c30 0 58-18 88-18s 58 18 88 18 58-18 88-18 58 18 88 18 v44h-352z" /></defs><g class="exp-wave-parallax"><use xlink:href="#exp-gentle-wave-'.$exp_uniqid.'" x="48" y="0" /><use xlink:href="#exp-gentle-wave-'.$exp_uniqid.'" x="48" y="3" /><use xlink:href="#exp-gentle-wave-'.$exp_uniqid.'" x="48" y="5" /><use xlink:href="#exp-gentle-wave-'.$exp_uniqid.'" x="48" y="7" /></g></svg>';
        }
        if($settings['row_divider'] == 'curved-top' || $settings['row_divider'] == 'curved-bottom') {
            $html .=  '<svg class="exp-row-angle" xmlns="http://www.w3.org/2000/svg" width="100%" viewBox="0 0 1920 128" version="1.1" preserveAspectRatio="none" style="fill:#ffffff"><path stroke-width="0" d="M-1,126a3693.886,3693.886,0,0,1,1921,2.125V-192H-7Z"></path></svg>';
        }
        if($settings['row_divider'] == 'vertical1') {
            $html .=  '<div class="exp-divider-vertical"><div class="exp-section-line1"></div><div class="exp-section-line2"></div><div class="exp-section-line3"></div><div class="exp-section-line4"></div><div class="exp-section-line5"></div><div class="exp-section-line6"></div></div>';
        }
    }

    if($settings['exp_overlay_display'] == 'image') {
        $html .=  '<div class="exp-overlay--image bg-image" style="background-image:url('.$settings['exp_overlay_img']['url'].');"></div>';
    }

    if(!empty($settings['row_particles_display']) && $settings['row_particles_display'] == 'yes') {
        wp_enqueue_script('particles-background');
        $s_random = '';
        if($settings['size_random'] == 'yes') {
            $s_random = 'true';
        } else {
            $s_random = 'false';
        }
        $colors = [];
        foreach($settings['particle_color_item'] as $values) {
            $colors[] = $values['particle_color'];
        }
        if(empty($colors)) {
            $colors = ["#b73490","#006b41","#cd3000","#608ecb","#ffb500","#6e4e00","#6b541b","#305686","#00ffb4","#8798ff","#0044c1"];
        }
        $el->add_render_attribute( 'color', 'data-color', json_encode($colors) );
        $html .= '<div id="exp-row-particles-'.uniqid().'" class="exp-row-particles" data-number="'.$settings['number'].'" data-size="'.$settings['size'].'" data-size-random="'.$s_random.'" data-move-direction="'.$settings['move_direction'].'" '.$el->get_render_attribute_string( 'color' ).'></div>';
    }

    return $html;

}