<?php


/** Set ABSPATH for execution */
define( 'ABSPATH', dirname(dirname(__FILE__)) . '/' );
define( 'WPINC', 'wp-includes' );


/**
 * @ignore
 */
function add_filter() {}

/**
 * @ignore
 */
function esc_attr($str) {return $str;}

/**
 * @ignore
 */
function apply_filters() {}

/**
 * @ignore
 */
function get_option() {}

/**
 * @ignore
 */
function is_lighttpd_before_150() {}

/**
 * @ignore
 */
function add_action() {}

/**
 * @ignore
 */
function did_action() {}

/**
 * @ignore
 */
function do_action_ref_array() {}

/**
 * @ignore
 */
function get_bloginfo() {}

/**
 * @ignore
 */
function is_admin() {return true;}

/**
 * @ignore
 */
function site_url() {}

/**
 * @ignore
 */
function admin_url() {}

/**
 * @ignore
 */
function home_url() {}

/**
 * @ignore
 */
function includes_url() {}

/**
 * @ignore
 */
function wp_guess_url() {}

if ( ! function_exists( 'json_encode' ) ) :
/**
 * @ignore
 */
function json_encode() {}
endif;



/* Convert hexdec color string to rgb(a) string */
 
function hex2rgba($color, $opacity = false) {
 
    $default = 'rgb(0,0,0)';
 
    //Return default if no color provided
    if(empty($color))
          return $default; 
 
    //Sanitize $color if "#" is provided 
        if ($color[0] == '#' ) {
            $color = substr( $color, 1 );
        }
 
        //Check if color has 6 or 3 characters and get values
        if (strlen($color) == 6) {
                $hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
        } elseif ( strlen( $color ) == 3 ) {
                $hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
        } else {
                return $default;
        }
 
        //Convert hexadec to rgb
        $rgb =  array_map('hexdec', $hex);
 
        //Check if opacity is set(rgba or rgb)
        if($opacity){
            if(abs($opacity) > 1)
                $opacity = 1.0;
            $output = 'rgba('.implode(",",$rgb).','.$opacity.')';
        } else {
            $output = 'rgb('.implode(",",$rgb).')';
        }
 
        //Return rgb(a) color string
        return $output;
}
$yellow = $_GET['main_color'];

ob_start(); ?>

@charset "utf-8";
/* Theme Color */

a,
.theme_color,
.scroll-to-top,
.main-slider-two .title,
.list-style-one li .icon,
.video-box .overlay-box span,
.main-slider .social-box li a:hover,
.testimonial-block .inner-box .rating .fa,
.main-header .header-top .language .flag-icon,
.main-header .header-top .info-list li a:hover,
.main-header .header-top .info-list li .icon,
.main-menu .navigation > li:hover > a,
.main-menu .navigation > li.current > a,
.service-block.style-two .inner-box h4 a,
.about-section .content-column .red-text,
.main-footer .logo-widget .social-links a:hover,
.main-footer .consult-widget .social-links a:hover,
.main-header .outer-box .cart-box .cart-panel .btns-boxed li a:hover,
.main-header .outer-box .cart-product .inner .cross-icon:hover,
.main-header .outer-box .cart-product .inner h3 a:hover,
.main-header .outer-box .cart-box .cart-box-btn:hover,
.news-block .inner-box .lower-content h4 a:hover,
.main-footer .news-widget .post h5 a:hover,
.main-footer .list-link li a:hover,
.main-footer .timing-widget ul li:last-child,
.main-slider-two .owl-nav .owl-prev:hover,
.main-slider-two .owl-nav .owl-next:hover,
.main-slider-two .video-box,
.main-slider-three .title,
.page-breadcrumb li,
.social-icon-one li a:hover,
.page-breadcrumb li a:hover,
.service-block-two .inner-box .title,
.testimonial-block-two .inner-box .rating .fa,
.featured-block-two .inner-box .image .icon-box,
.news-block-two .inner-box .lower-content .post-meta li .icon,
.news-block-two .inner-box .lower-content h4 a:hover,
.timetable-section-two .appointment-box .appointment-inner .text a,
.featured-block-two .inner-box .lower-content h4 a:hover,
.choose-section .images-column .info-box.style-two .more,
.featured-block-two .inner-box .lower-content .read-more:hover,
.contact-map-section .map-info-boxed .info-column ul li strong,
.testimonial-section .testimonial-column .owl-nav .owl-prev:hover,
.testimonial-section .testimonial-column .owl-nav .owl-next:hover,
.pricing-block .inner-box .price span,
.fact-counter-two .column .inner .icon,
.main-footer .footer-info-list li a:hover,
.main-footer .footer-info-list li .icon,
.testimonial-block-three .inner-box .rating,
.classess-block .inner-box .image .icon-box,
.classess-block .inner-box .lower-content .title,
.classess-block .inner-box .lower-content h4 a:hover,
.help-widget .lower-content ul li .icon,
.list-style-two li:before,
.blog-cat li a:hover,
.shop-list li a,
.cart-table tbody tr .remove-btn,
.checkout-page .default-links li a,
.shop-page .prod-tabs .reviews-container .rev-header .rating,
.sidebar .popular-posts .post a:hover,
.blog-single .post-share-options .social-box li a:hover,
.shop-page .prod-tabs .add-review .rating .rate-box:hover,
.shop-page .prod-tabs .add-review .rating .rate-box:focus,
.shop-page .prod-tabs .add-review .rating .rate-box:active,
.product-details .basic-details .details-header .rating span,
.shop-item .inner-box .lower-content h6 a:hover,
.news-block-three .inner-box .lower-content h3 a:hover,
.portfolio-detail-section .inner-box .info-list li span,
.main-menu .navigation > li > ul > li:hover > a,
.main-menu .navigation > li > ul > li > ul > li:hover > a,
.main-menu .navigation > li > ul > li > a:before,
.main-menu .navigation > li > ul > li > ul > li > a:before,
.main-menu .navigation > li > ul > li.dropdown:hover > a:after,
.classes-detail .inner-box .lower-content .schedule-column .inner-column .time span,
.classess-block .inner-box .lower-content .read-more:hover,
.coming-soon .emailed-form .form-group input[type="submit"],
.coming-soon .emailed-form button,
.author-box .social-icon li a,
.blog-single .post-share-options .tags a:hover,
.blog-single .inner-box .lower-content blockquote .quote-icon,
.news-block-three .inner-box .lower-content .read-more:hover,
.timeslot a:hover,
.pt-blog-contain .pt-post-meta ul li i,
.footer-widget ul li a:hover, .footer-widget ul li:hover:before,
.widget ul li a:hover,
.author-box .social-icon li a i,
.main-slider-three .social-box li a:hover,
.product-categories > li a:hover,
.woocommerce .woocommerce-Price-amount,
.woocommerce ul.product_list_widget li a:not(.remove):hover,
.woocommerce div.product .woocommerce-tabs ul.tabs li:hover a, .woocommerce div.product .woocommerce-tabs ul.tabs li.active a,
.woocommerce p.stars a,
.woocommerce .woocommerce-message::before,
.woocommerce .woocommerce-info a,
.woocommerce .woocommerce-info::before,
.woocommerce form .form-row .required,
.blog-single .inner-box .lower-content p.mptt-theme-mode-event a,
.main-footer .footer-bottom .copyright a,
.main-footer .footer-bottom .copyright a:hover,
.calculate-section .info-column .table-outer .info-list .table-name,
.news-block-one.update-block .inner-box .lower-content .post-info li,
.choose-section.update-section .inner-column .list-detail ul li i,
.solution-block .inner-box .icon-box,
.contact-form-section.update .contact-info li .icon,
.news-block-three .inner-box .lower-content .post-meta li .icon,
.blog-single .inner-box .image .post-item-date,
.blog-single .inner-box .lower-content .post-meta li .icon
{
    color: #<?php echo esc_attr($yellow); ?>;
}

.slider.red-color {
    color: #<?php echo esc_attr($yellow); ?> !important;
}

.main-header .sticky-header .main-menu .navigation > li:hover > a,
.main-header .sticky-header .main-menu .navigation > li.current > a
{
    color: #<?php echo esc_attr($yellow); ?>;
}

.main-header .sticky-header .main-menu .navigation > li:hover > a, .main-header .sticky-header .main-menu .navigation > li.current > a,
.sticky-header .main-menu .navigation > li:hover a:before, .sticky-header .main-menu .navigation > li.current a:before,
.main-menu .navigation > li:hover:before, .main-menu .navigation > li.current:before{
    color: #<?php echo esc_attr($yellow); ?> !important;
}

.product-categories > li a:hover,
.woocommerce a.remove{
    color: #<?php echo esc_attr($yellow); ?> !important;
}


/*Background Color*/
.clock-hour,
.clock-minute,
.clock-second:after,
.checkout-btn,
.cart-table .cart-header,
.scroll-to-top:hover,
.services-section:after,
.featured-block .icon:after,
.header-style-three .header-top,
.team-block .inner-box .content:before,
.timetable-section .table-title-box .title,
.classess-block .inner-box:hover .image .icon-box,
.timetable-section .timetable-tabs .tab-btns .tab-btn,
.main-header .outer-box .cart-box .cart-box-btn .total-cart,
.main-header .header-top .language .dropdown-menu > li > a:hover,
.main-header .outer-box .cart-box .cart-panel .btns-boxed li a,
.main-slider-two .owl-dots .owl-dot.active,
.main-slider-two .owl-dots .owl-dot:hover,
.choose-section .images-column .info-box,
.featured-block-two .inner-box .image,
.news-block-two .inner-box .image,
.gallery-block .inner-box .image .content .icon,
.ui-state-active, .ui-widget-content .ui-state-active,
.featured-block-two .inner-box:hover .image .icon-box,
.timetable-section-two .table-title-box .title,
.timetable-section-two .timetable-tabs .tab-btns .tab-btn,
.main-footer .consult-widget .phone .icon,
.search-popup .close-search,
.newsletter-section .inner-container,
.accordion-box .block .icon-outer .icon,
.team-block-two .inner-box .side-title,
.team-block-two .inner-box .content:before,
.classess-block .inner-box .image,
.sidebar .service-list li a:hover,
.sidebar .service-list li.current a,
.brochure-box .inner .icon,
.sidebar-title:before,
.sidebar .search-box .form-group button,
.sidebar .popular-tags a:hover,
.shop-item .inner-box .image .sale,
.sidebar-page-container .comments-area .comment-box .theme-btn:hover,
.shop-item .inner-box .image .overlay-box .cart-option li a:hover,
.styled-pagination li.active a, .styled-pagination li:hover a,
.gallery-block .inner-box .image .content .content-inner:before,
.testimonial-block-three .inner-box .author-image .quote-icon,
.shop-item .inner-box .image .overlay-box .cart-option li a,
.news-block-three .inner-box .image,
.news-block-three .inner-box .owl-nav .owl-prev:hover,
.news-block-three .inner-box .owl-nav .owl-next:hover,
.news-block-three .inner-box .image .overlay-box,
.blog-single .inner-box .image,
.author-box .social-icon li a:hover,
.main-header .sticky-header .outer-box .cart-box .cart-box-btn .total-cart,
.color-palate .option-box > li,
.mptt-shortcode-wrapper .mptt-navigation-tabs li a,
.main-slider-three .owl-nav .owl-prev:hover, .main-slider-three .owl-nav .owl-next:hover,
.widget .tagcloud a:hover,
.pagination li a:focus, .pagination li a:hover, .pagination li span:focus, .pagination li span:hover, .pagination li span.current,
.pagination li a.next:hover, .pagination li a.prev:hover,
.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #place_order,
.product-categories > li a:hover:before,
.woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover,
.shop-sidebar .widget .widget-title:before,
.woocommerce div.product div.images .woocommerce-product-gallery__trigger,
.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt,
.woocommerce div.product .woocommerce-tabs ul.tabs li a:before,
.woocommerce #review_form #respond .form-submit input,
.woocommerce #review_form #respond .form-submit input:hover,
.woocommerce #respond input#submit.disabled, .woocommerce #respond input#submit:disabled, .woocommerce #respond input#submit[disabled]:disabled, .woocommerce a.button.disabled, .woocommerce a.button:disabled, .woocommerce a.button[disabled]:disabled, .woocommerce button.button.disabled, .woocommerce button.button:disabled, .woocommerce button.button[disabled]:disabled, .woocommerce input.button.disabled, .woocommerce input.button:disabled, .woocommerce input.button[disabled]:disabled,
.woocommerce #place_order:hover,
.main-footer .footer-widget h4:before,
.solution-block .inner-box:before,
.solution-section .owl-dots .owl-dot,
.counter-section .pattern-layer:before,
.blog-single .inner-box .image .post-item-date, .news-block-three .inner-box .image .post-item-date
{
    background-color: #<?php echo esc_attr($yellow); ?>;
}

.content-side .classes-detail .pt-post-date, rs-progress-bar {
    background: #<?php echo esc_attr($yellow); ?> !important;
}

.news-block-one.update-block .inner-box .image-box .post-date,
.news-block-one.update-block .inner-box .lower-content .link-btn a:before,
.blog-single .inner-box .lower-content blockquote .quote-icon,
.comment-form p.form-submit input[type="submit"] {
    background: #<?php echo esc_attr($yellow); ?>;
}

.mptt-shortcode-wrapper.mptt-table-responsive .mptt-shortcode-table tbody .mptt-event-container:hover
{
    background-color: #<?php echo esc_attr($yellow); ?> !important;
}

.mptt-shortcode-hours
{
    background-color: #<?php echo esc_attr($yellow); ?> !important;
}

.classes-detail .inner-box .lower-content p.timeslot:hover,
.blog-single .inner-box .lower-content p.mptt-theme-mode-event:hover {
    border-bottom-color: #<?php echo esc_attr($yellow); ?>;
}


.mptt-shortcode-wrapper .mptt-navigation-tabs li a {
    border-left: 3px solid #<?php echo esc_attr($yellow); ?>;
}

.color-palate-head, .color-trigger
{
    background-color: #<?php echo esc_attr($yellow); ?>;
}

/*Border Color*/

.clock-second:after,
.btn-style-three:hover,
.btn-one-outer:before,
.btn-one-outer:after,
.btn-two-outer:before,
.btn-two-outer:after,
.btn-three-outer:before,
.btn-three-outer:after,
.main-menu .navigation > li > ul,
.main-footer .consult-widget .phone,
.main-header .btn-box .pass-btn,
.author-box .social-icon li a:hover,
.author-box .social-icon li a,
.single-product-item .img-holder,
.main-header.header-style-two .nav-outer:before,
.main-header .header-upper .logo-box:before,
.main-menu .navigation > li > ul > li > ul,
.main-header .outer-box .cart-box .cart-panel,
.ui-state-active, .ui-widget-content .ui-state-active,
.main-header .header-top .language .dropdown-menu,
.featured-block-two .inner-box .lower-content .read-more:before,
.timetable-section .timetable-tabs .tab-btns .tab-btn,
.timetable-section-two .timetable-tabs .tab-btns .tab-btn,
.main-header .outer-box .cart-box .cart-panel .btns-boxed li a,
.testimonial-block-two .inner-box .upper-box .author-image:before,
.classess-block .inner-box .lower-content .read-more:before,
.cart-section .apply-coupon .form-group input[type="text"],
.news-block-three .inner-box .lower-content .read-more:before,
.rtl .main-header .header-upper .logo-box:before,
.shop-form input:focus, .shop-form select:focus, .shop-form textarea:focus,
.styled-form input:focus, .styled-form select:focus, .styled-form textarea:focus,
.testimonials-thumbs-carousel .carousel-thumbnails .carousel-indicators li .image:before,
.mptt-shortcode-wrapper .mptt-navigation-tabs li.active a, .mptt-shortcode-wrapper .mptt-navigation-tabs li:hover,
.mptt-shortcode-wrapper .mptt-navigation-tabs li:hover a,
wrapper .mptt-navigation-tabs li:hover, .mptt-shortcode-wrapper .mptt-navigation-tabs li:hover a,
.woocommerce ul.products li.product:hover .product-media, .woocommerce-page ul.products li.product:hover .product-media
{
    border-color: #<?php echo esc_attr($yellow); ?>;
}

.comment-form p.form-submit input[type="submit"] {
    border: 2px solid #<?php echo esc_attr($yellow); ?>;
}

.btn-style-two:after,
.btn-style-two:before,
.btn-style-three:before,
.btn-style-three:after{
    border-bottom-color:#<?php echo esc_attr($yellow); ?>;
}

.woocommerce .woocommerce-error, .woocommerce .woocommerce-info, .woocommerce .woocommerce-message {
    border-top: 2px solid #<?php echo esc_attr($yellow); ?> !important;
}

.mptt-shortcode-wrapper .mptt-navigation-tabs li a:before {
    border-left:8px solid #<?php echo esc_attr($yellow); ?>;
}

.timetable-section-two .timetable-tabs .tab-btns .tab-btn:before,
.timetable-section .timetable-tabs .tab-btns .tab-btn:before{
    border-left-color:#<?php echo esc_attr($yellow); ?>;
}

/*RGBA Color Light*/
.instagram-widget .post-thumb .overlay-box,
.sidebar .popular-posts .post .post-thumb .overlay-box{
    background-color:#<?php echo esc_attr($yellow); ?>;
}

.woocommerce ul.products li.product .product-media, .woocommerce-page ul.products li.product .product-media {
    border: 5px solid #<?php echo esc_attr($yellow); ?>;
}

.sidebar-info-contents .content-inner .contact-info .list-style-one li .icon {
     border: 2px solid #<?php echo esc_attr($yellow); ?>;
}

.blog-single .post-share-options .social-box li a {
    border-bottom: 2px solid #<?php echo esc_attr($yellow); ?>;
}

/*RGBA Color Dark*/

.fluid-section-one .outer-container .right-column .image-layer:before,
.counter-section .inner-container .pattern-layer:before{
    background-color:#<?php echo esc_attr($yellow); ?>;7
}
/*RGBA Color Light*/

/*RGBA Color Dark*/

@media only screen and (max-width: 767px){
    
    .main-menu .navbar-header .navbar-toggle{
        border-color:#<?php echo esc_attr($yellow); ?>;
    }
    
    .main-menu .navbar-header .navbar-toggle,
    .main-menu .navbar-collapse > .navigation,
    .main-menu .navbar-collapse > .navigation > li > ul,
    .main-menu .navbar-collapse > .navigation > li > ul > li > ul,
    .main-menu .navbar-collapse > .navigation > li > a,
    .main-menu .navbar-collapse > .navigation > li > ul > li > a,
    .main-menu .navbar-collapse > .navigation > li > ul > li > ul > li > a,
    .main-menu .navbar-collapse > .navigation > li > a:hover,
    .main-menu .navbar-collapse > .navigation > li > a:active,
    .main-menu .navbar-collapse > .navigation > li > a:focus,
    .main-menu .navbar-collapse > .navigation > li:hover > a,
    .main-menu .navbar-collapse > .navigation > li > ul > li:hover > a,
    .main-menu .navbar-collapse > .navigation > li > ul > li > ul > li:hover > a,
    .main-menu .navbar-collapse > .navigation > li.current > a,
    .main-menu .navbar-collapse > .navigation > li.current-menu-item > a,
    .header-style-two.inner-header .main-menu .navigation > li > a{
        background-color:#<?php echo esc_attr($yellow); ?>;
    }
    
}


<?php 

$out = ob_get_clean();
$expires_offset = 31536000; // 1 year
header('Content-Type: text/css; charset=UTF-8');
header('Expires: ' . gmdate( "D, d M Y H:i:s", time() + $expires_offset ) . ' GMT');
header("Cache-Control: public, max-age=$expires_offset");
header('Vary: Accept-Encoding'); // Handle proxies
header('Content-Encoding: gzip');

echo gzencode($out);
exit;