(function($){
    "user strict";

    $( window ).on( 'elementor:init', function() {
        var ExpIconsItemView = elementor.modules.controls.BaseData.extend({
            wrapper: null,
            items: null,
            iconpicker_els: null,
            url_els: null,
            add_btn: null,
            delete_btn: null,
            template: null,
            onReady: function () {
                var self = this;
                this.wrapper = $(this.el);
                this.items = this.wrapper.find(".exp-group-item");
                this.add_btn = this.wrapper.find(".exp-group-add");
                this.template = this.wrapper.find(".exp-template").val();

                self.setupIconPicker();
                self.setupUrlInput();
                self.setupDeleteBtn();
                this.add_btn.on("click", function(){
                    var new_item = $(self.template);
                    self.wrapper.find(".exp-group").append(new_item);
                    setTimeout(function(){
                        self.setupIconPicker();
                        self.setupUrlInput();
                        self.setupDeleteBtn();
                        self.items = self.wrapper.find(".exp-group-item");
                    }, 300);
                });
            },

            setupIconPicker: function () {
                var self = this;
                self.iconpicker_els = self.wrapper.find(".exp-iconpicker");
                self.iconpicker_els.fontIconPicker();
                self.iconpicker_els.on("change", function(e){
                    e.preventDefault();
                    self.saveValue();
                });
            },

            setupUrlInput: function () {
                var self = this;
                self.wrapper.find(".exp-url-input").on("keyup", function(e){
                    e.preventDefault();
                    self.saveValue();
                });

                self.wrapper.find(".exp-content-input").on("keyup", function(e){
                    e.preventDefault();
                    self.saveValue();
                });

                self.wrapper.find(".exp-content-pricing").on("keyup", function(e){
                    e.preventDefault();
                    self.saveValue();
                });

                self.wrapper.find(".exp-class-pricing").on("keyup", function(e){
                    e.preventDefault();
                    self.saveValue();
                });

                self.wrapper.find(".exp-title-input").on("keyup", function(e){
                    e.preventDefault();
                    self.saveValue();
                });

                self.wrapper.find(".exp-number-input").on("keyup", function(e){
                    e.preventDefault();
                    self.saveValue();
                });
 
            },

            setupDeleteBtn: function () {
                var self = this;
                self.delete_btn = self.wrapper.find(".exp-group-delete");
                self.delete_btn.on("click", function(e){
                    e.preventDefault();
                    $(this).parent().remove();
                    self.items = self.wrapper.find(".exp-group-item");
                    self.saveValue();
                });
            },

            saveValue: function () {
                var values = [];
                $.each(this.items, function(index, item){
                    var item_val = {};
                    item_val.icon = $(item).find(".exp-iconpicker").val();
                    item_val.url = $(item).find(".exp-url-input").val();
                    item_val.content = $(item).find(".exp-content-input").val();
                    item_val.content_pricing = $(item).find(".exp-content-pricing").val();
                    item_val.class_pricing = $(item).find(".exp-class-pricing").val();
                    item_val.title = $(item).find(".exp-title-input").val();
                    item_val.number = $(item).find(".exp-number-input").val();
                    values.push(item_val);
                });
                this.setValue(JSON.stringify(values));
            },

            onBeforeDestroy: function () {
                this.saveValue();
            }
        });

        elementor.addControlView('exp_icons', ExpIconsItemView);
        elementor.addControlView('exp_lists', ExpIconsItemView);
        elementor.addControlView('exp_lists_pricing', ExpIconsItemView);
        elementor.addControlView('exp_progressbar', ExpIconsItemView);
    } );
}(jQuery));