<?php $__env->startSection('title', 'Modifier le membre'); ?>

<?php $__env->startSection('content'); ?>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap');

        .edit-container {
            max-width: 1000px;
            margin: 0 auto;
            padding: 0 20px;
        }

        .edit-card {
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(10px);
            border-radius: 24px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.15);
            padding: 0;
            overflow: hidden;
            animation: slideUp 0.6s ease-out;
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .card-header {
            background: linear-gradient(135deg, #D30402 0%, #764ba2 100%);
            padding: 40px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .card-header::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
            animation: pulse 3s ease-in-out infinite;
        }

        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.1); }
        }

        .card-header h2 {
            color: #fff;
            font-weight: 700;
            font-size: 32px;
            margin: 0 0 10px 0;
            position: relative;
            z-index: 1;
        }

        .card-header p {
            color: rgba(255, 255, 255, 0.9);
            font-size: 16px;
            margin: 0;
            position: relative;
            z-index: 1;
        }

        .card-body {
            padding: 50px;
        }

        .form-group {
            margin-bottom: 28px;
        }

        .form-label {
            display: block;
            font-weight: 600;
            font-size: 14px;
            color: #2d3748;
            margin-bottom: 8px;
            letter-spacing: 0.3px;
        }

        .form-control, .form-select {
            width: 100%;
            padding: 14px 18px;
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            font-size: 15px;
            transition: all 0.3s ease;
            background-color: #f8fafc;
            color: #2d3748;
        }

        .form-control:focus, .form-select:focus {
            outline: none;
            border-color: #667eea;
            background-color: #fff;
            box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
            transform: translateY(-2px);
        }

        .form-control:hover, .form-select:hover {
            border-color: #cbd5e0;
        }

        .photo-section {
            background: linear-gradient(135deg, #f6f8fb 0%, #eef2f7 100%);
            border-radius: 16px;
            padding: 30px;
            margin: 30px 0;
        }

        .photo-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 30px;
            align-items: center;
        }

        .current-photo {
            text-align: center;
        }

        .current-photo-label {
            display: block;
            font-weight: 600;
            color: #4a5568;
            margin-bottom: 15px;
            font-size: 14px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .photo-wrapper {
            position: relative;
            display: inline-block;
        }

        .photo-wrapper img {
            width: 140px;
            height: 140px;
            border-radius: 20px;
            object-fit: cover;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
            border: 4px solid #fff;
        }

        .upload-area {
            text-align: center;
        }

        .upload-label {
            display: block;
            font-weight: 600;
            color: #4a5568;
            margin-bottom: 15px;
            font-size: 14px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .file-input-wrapper {
            position: relative;
            display: inline-block;
            cursor: pointer;
            width: 100%;
        }

        .file-input-box {
            border: 3px dashed #cbd5e0;
            border-radius: 16px;
            padding: 40px 20px;
            text-align: center;
            background: #fff;
            transition: all 0.3s ease;
        }

        .file-input-box:hover {
            border-color: #667eea;
            background: linear-gradient(135deg, rgba(102, 126, 234, 0.05) 0%, rgba(118, 75, 162, 0.05) 100%);
            transform: translateY(-3px);
        }

        .file-input-box input {
            position: absolute;
            opacity: 0;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            cursor: pointer;
        }

        .upload-icon {
            font-size: 40px;
            margin-bottom: 10px;
            display: block;
        }

        .upload-text {
            color: #667eea;
            font-weight: 600;
            font-size: 15px;
        }

        .upload-subtext {
            color: #a0aec0;
            font-size: 13px;
            margin-top: 5px;
        }

        #new-photo-preview {
            margin-top: 20px;
        }

        #new-photo-preview img {
            width: 120px;
            height: 120px;
            border-radius: 16px;
            object-fit: cover;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
            border: 3px solid #667eea;
        }

        /* Styles pour le certificat */
        .certificat-section {
            background: linear-gradient(135deg, #fff5f5 0%, #ffe5e5 100%);
            border-radius: 16px;
            padding: 30px;
            margin: 30px 0;
        }

        .certificat-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 30px;
            align-items: start;
        }

        .current-certificat {
            text-align: center;
        }

        .certificat-preview {
            background: #fff;
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            display: inline-block;
        }

        .certificat-icon {
            font-size: 60px;
            margin-bottom: 10px;
            display: block;
        }

        .certificat-name {
            font-size: 13px;
            color: #718096;
            word-break: break-all;
            margin-top: 10px;
        }

        .btn-view-certificat {
            display: inline-block;
            margin-top: 15px;
            padding: 10px 24px;
            background: linear-gradient(135deg, #D30402 0%, #764ba2 100%);
            color: #fff;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 600;
            font-size: 14px;
            transition: all 0.3s ease;
        }

        .btn-view-certificat:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(211, 4, 2, 0.3);
            color: #fff;
        }

        .no-certificat {
            color: #a0aec0;
            font-style: italic;
            padding: 30px;
        }

        #new-certificat-preview {
            margin-top: 20px;
            padding: 15px;
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        }

        .certificat-preview-name {
            font-size: 14px;
            color: #4a5568;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .button-group {
            display: flex;
            gap: 15px;
            justify-content: center;
            margin-top: 40px;
        }

        .btn-primary-modern {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: #fff;
            font-weight: 600;
            font-size: 16px;
            padding: 16px 40px;
            border: none;
            border-radius: 12px;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
        }

        .btn-primary-modern:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.5);
        }

        .btn-secondary-modern {
            background: #fff;
            color: #4a5568;
            font-weight: 600;
            font-size: 16px;
            padding: 16px 40px;
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-block;
        }

        .btn-secondary-modern:hover {
            background: #f7fafc;
            border-color: #cbd5e0;
            transform: translateY(-3px);
            color: #2d3748;
        }

        @media (max-width: 768px) {
            .photo-grid, .certificat-grid {
                grid-template-columns: 1fr;
            }

            .card-body {
                padding: 30px 20px;
            }

            .button-group {
                flex-direction: column;
            }

            .btn-primary-modern, .btn-secondary-modern {
                width: 100%;
            }
        }
    </style>

    <div class="edit-container">
        <div class="edit-card">
            <div class="card-header">
                <h2>✨ Modifier le membre</h2>
                <p>Mettez à jour les informations du profil</p>
            </div>

            <div class="card-body">
                <form action="<?php echo e(route('admin.members.demande.update', $member->id)); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label" for="nom">Nom</label>
                                <input type="text" class="form-control" id="nom" name="nom" value="<?php echo e(old('nom', $member->nom)); ?>" required>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label" for="prenom">Prénom</label>
                                <input type="text" class="form-control" id="prenom" name="prenom" value="<?php echo e(old('prenom', $member->prenom)); ?>" required>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label" for="email">Email</label>
                                <input type="email" class="form-control" id="email" name="email" value="<?php echo e(old('email', $member->email)); ?>" required>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label" for="tel">Téléphone</label>
                                <input type="text" class="form-control" id="tel" name="tel" value="<?php echo e(old('tel', $member->tel)); ?>">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label" for="adresse">Adresse</label>
                                <input type="text" class="form-control" id="adresse" name="adresse" value="<?php echo e(old('adresse', $member->adresse)); ?>">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label" for="nationalite">Nationalité</label>
                                <input type="text" class="form-control" id="nationalite" name="nationalite" value="<?php echo e(old('nationalite', $member->nationalite)); ?>">
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label" for="role">Rôle</label>
                                <select class="form-select" id="role" name="role" required>
                                    <option value="Black belt degree" <?php echo e($member->role == 'Black belt degree' ? 'selected' : ''); ?>>Black Belt Degree</option>
                                    <option value="Coach self defense" <?php echo e($member->role == 'Coach self defense' ? 'selected' : ''); ?>>Coach Self Defense</option>
                                    <option value="Coach body guard" <?php echo e($member->role == 'Coach body guard' ? 'selected' : ''); ?>>Coach Body Guard</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- Section Photo -->
                    <div class="photo-section">
                        <div class="photo-grid">
                            <div class="current-photo">
                                <span class="current-photo-label">Photo actuelle</span>
                                <div class="photo-wrapper">
                                    <img src="data:image/jpeg;base64,<?php echo e(base64_encode($member->photo1)); ?>" alt="Photo actuelle">
                                </div>
                            </div>

                            <div class="upload-area">
                                <span class="upload-label">Nouvelle photo</span>
                                <div class="file-input-wrapper">
                                    <div class="file-input-box">
                                        <input type="file" name="photo1" id="photo1" accept="image/*" onchange="previewImage(event)">
                                        <span class="upload-icon">📸</span>
                                        <div class="upload-text">Cliquer pour choisir</div>
                                        <div class="upload-subtext">PNG, JPG jusqu'à 5MB</div>
                                    </div>
                                </div>
                                <div id="new-photo-preview" style="display:none;">
                                    <img id="preview-img" src="" alt="Aperçu">
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Section Certificat -->
                    <div class="certificat-section">
                        <div class="certificat-grid">
                            <div class="current-certificat">
                                <span class="current-photo-label">Certificat actuel</span>
                                <?php if($member->certificat): ?>
                                    <div class="certificat-preview">
                                        <span class="certificat-icon">📄</span>
                                        <div class="certificat-name"><?php echo e(basename($member->certificat)); ?></div>
                                        <a href="<?php echo e(asset('project/storage/app/public/' . $member->certificat)); ?>" target="_blank" class="btn-view-certificat">
                                            👁️ Voir le certificat
                                        </a>
                                    </div>
                                <?php else: ?>
                                    <div class="no-certificat">
                                        Aucun certificat disponible
                                    </div>
                                <?php endif; ?>
                            </div>

                            <div class="upload-area">
                                <span class="upload-label">Nouveau certificat</span>
                                <div class="file-input-wrapper">
                                    <div class="file-input-box">
                                        <input type="file" name="certificat" id="certificat" accept=".pdf,.jpg,.jpeg,.png" onchange="previewCertificat(event)">
                                        <span class="upload-icon">📋</span>
                                        <div class="upload-text">Cliquer pour choisir</div>
                                        <div class="upload-subtext">PDF, PNG, JPG jusqu'à 10MB</div>
                                    </div>
                                </div>
                                <div id="new-certificat-preview" style="display:none;">
                                    <div class="certificat-preview-name">
                                        <span>📄</span>
                                        <span id="certificat-name"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="button-group">
                        <button type="submit" class="btn-primary-modern">💾 Enregistrer les modifications</button>
                        <a href="<?php echo e(url()->previous()); ?>" class="btn-secondary-modern">✖ Annuler</a>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        function previewImage(event) {
            const input = event.target;
            const preview = document.getElementById('new-photo-preview');
            const img = document.getElementById('preview-img');

            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    img.src = e.target.result;
                    preview.style.display = 'block';
                };
                reader.readAsDataURL(input.files[0]);
            }
        }

        function previewCertificat(event) {
            const input = event.target;
            const preview = document.getElementById('new-certificat-preview');
            const nameDisplay = document.getElementById('certificat-name');

            if (input.files && input.files[0]) {
                const fileName = input.files[0].name;
                nameDisplay.textContent = fileName;
                preview.style.display = 'block';
            }
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kyukusu/www/app/project/resources/views/admin/register_member/edit.blade.php ENDPATH**/ ?>