<!doctype html>
<html lang="fr">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width,initial-scale=1" />
    <title>Liste des Gyms</title>
    <style>
        :root {
            --bg: #FBFBFB;
            --muted: #8C8570;
            --brown: #5C3F17;
            --accent: #D30402;
            --card-radius: 14px;
            --gap: 20px;
            --max-width: 1200px;
            --shadow: 0 8px 24px rgba(92,63,23,0.08);
        }

        * { box-sizing: border-box }
        body {
            margin: 0;
            font-family: Inter, ui-sans-serif, system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;
            background: linear-gradient(180deg, var(--bg) 0%, #F7F6F3 100%);
            color: #222;
            padding: 40px 20px;
        }

        .container { max-width: var(--max-width); margin: 0 auto; }

        header { text-align: center; margin-bottom: 30px; }
        h1 { color: var(--brown); font-size: 26px; margin-bottom: 6px; }
        p.lead { color: var(--muted); }

        /* Styles pour les filtres - Full Width */
        .filters {
            background: white;
            border-radius: var(--card-radius);
            padding: 30px;
            margin: 0 0 30px 0;
            box-shadow: var(--shadow);
            width: 100%;
        }

        .filter-form {
            display: grid;
            grid-template-columns: 1fr 1fr 1fr auto;
            gap: 20px;
            align-items: end;
            width: 100%;
        }

        .filter-group {
            display: flex;
            flex-direction: column;
            gap: 8px;
            width: 100%;
        }

        .filter-group label {
            font-size: 14px;
            color: var(--brown);
            font-weight: 500;
        }

        .filter-input,
        .filter-select {
            padding: 12px 16px;
            border: 1px solid rgba(92,63,23,0.2);
            border-radius: 8px;
            font-size: 15px;
            background: white;
            color: #333;
            width: 100%;
            height: 46px;
        }

        .filter-input:focus,
        .filter-select:focus {
            outline: none;
            border-color: var(--accent);
            box-shadow: 0 0 0 3px rgba(211,4,2,0.1);
        }

        .filter-button {
            padding: 12px 30px;
            background: var(--accent);
            color: white;
            border: none;
            border-radius: 8px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.2s;
            height: 46px;
            min-width: 120px;
            font-size: 15px;
        }

        .filter-button:hover {
            background: #b90302;
            transform: translateY(-1px);
        }

        .clear-filters {
            padding: 12px 20px;
            background: transparent;
            color: var(--muted);
            border: 1px solid rgba(92,63,23,0.2);
            border-radius: 8px;
            cursor: pointer;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            height: 46px;
            transition: all 0.2s;
        }

        .clear-filters:hover {
            background: rgba(92,63,23,0.05);
            border-color: rgba(92,63,23,0.3);
        }

        .button-group {
            display: flex;
            gap: 12px;
            align-items: center;
            height: 46px;
        }

        .grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: var(--gap);
        }

        .card {
            background: linear-gradient(180deg, white, #fffaf6);
            border-radius: var(--card-radius);
            padding: 16px;
            box-shadow: var(--shadow);
            border: 1px solid rgba(92,63,23,0.06);
            display: flex;
            flex-direction: column;
            gap: 12px;
            transition: transform 0.3s ease;
        }

        .card .photos {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 8px;
        }

        .card .photos img {
            width: 100%;
            height: 200px;
            object-fit: cover;
            border-radius: 8px;
        }

        .card h3 {
            margin: 6px 0 0;
            font-size: 18px;
            color: var(--brown);
        }

        .card p.desc {
            margin: 6px 0 0;
            color: var(--muted);
            font-size: 14px;
            line-height: 1.4;
            display: -webkit-box;
            -webkit-line-clamp: 3;
            -webkit-box-orient: vertical;
            overflow: hidden;
            max-height: 4.2em;
        }

        .card:hover {
            transform: translateY(-6px);
        }

        .specialite-badge {
            display: inline-block;
            background: rgba(211,4,2,0.1);
            color: var(--accent);
            padding: 4px 10px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 500;
            margin-top: 5px;
        }

        .nationalite-badge {
            display: inline-block;
            background: rgba(92,63,23,0.1);
            color: var(--brown);
            padding: 4px 10px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 500;
            margin-left: 8px;
        }

        .no-results {
            text-align: center;
            padding: 60px;
            color: var(--muted);
            font-size: 16px;
            grid-column: 1 / -1;
            background: white;
            border-radius: var(--card-radius);
            box-shadow: var(--shadow);
        }

        .results-count {
            text-align: center;
            margin-bottom: 20px;
            color: var(--muted);
            font-size: 14px;
            background: rgba(92,63,23,0.05);
            padding: 8px 16px;
            border-radius: 20px;
            display: inline-block;
        }

        .pagination {
            grid-column: 1 / -1;
            text-align: center;
            margin-top: 40px;
        }

        .card-full {
            grid-column: 1 / -1;
            display: flex;
            flex-direction: column;
        }

        .card-full .photos {
            grid-template-columns: repeat(3, 1fr);
        }

        .all-gyms-message {
            text-align: center;
            margin-bottom: 20px;
            color: var(--muted);
            font-size: 14px;
            font-style: italic;
        }

        @media (max-width: 1024px) {
            .filter-form {
                grid-template-columns: 1fr 1fr;
            }
        }

        @media (max-width: 768px) {
            .filter-form {
                grid-template-columns: 1fr;
                gap: 15px;
            }

            .button-group {
                flex-direction: column;
                height: auto;
                gap: 10px;
            }

            .filter-button,
            .clear-filters {
                width: 100%;
                text-align: center;
            }

            .filters {
                padding: 20px;
            }

            body {
                padding: 20px 15px;
            }

            .card .photos {
                grid-template-columns: 1fr;
            }

            .card .photos img {
                height: 200px;
            }

            .card-full .photos {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 480px) {
            .grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
<div class="container">
    <header>
        <h1>Our Gyms</h1>
        <p class="lead">Discover all our available gyms.</p>
    </header>

    <!-- Section des filtres - Full Width -->
    <div class="filters">
        <form method="GET" action="<?php echo e(route('gyms.liste')); ?>" class="filter-form">
            <div class="filter-group">
                <label for="search">Search Gyms</label>
                <input type="text"
                       id="search"
                       name="search"
                       class="filter-input"
                       placeholder="Search by name, address, description..."
                       value="<?php echo e(request('search')); ?>">
            </div>

            <div class="filter-group">
                <label for="specialite">Filter by Specialty</label>
                <select id="specialite" name="specialite" class="filter-select">
                    <option value="">All Specialties</option>
                    <?php $__currentLoopData = $specialites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specialite): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($specialite); ?>" <?php echo e(request('specialite') == $specialite ? 'selected' : ''); ?>>
                    <?php echo e($specialite); ?>

                    </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="filter-group">
                <label for="nationalite">Filter by Nationality</label>
                <select id="nationalite" name="nationalite" class="filter-select">
                    <option value="">All Nationalities</option>
                    <?php $__currentLoopData = $nationalites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nationalite): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($nationalite); ?>" <?php echo e(request('nationalite') == $nationalite ? 'selected' : ''); ?>>
                    <?php echo e($nationalite); ?>

                    </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="button-group">
                <button type="submit" class="filter-button">
                    Search
                </button>

                <?php if($hasFilter): ?>
                <a href="<?php echo e(route('gyms.liste')); ?>" class="clear-filters">
                    Clear All
                </a>
                <?php endif; ?>
            </div>
        </form>
    </div>

    <!-- Résultats -->
    <main>
        <!-- Grille des gyms -->
        <div class="grid">


            <!-- Gyms de la base de données -->
            <?php $__currentLoopData = $gyms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gym): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <article class="card">
                <div class="photos">
                    <?php if($gym->photo1): ?>
                    <img src="data:image/jpeg;base64,<?php echo e(base64_encode($gym->photo1)); ?>" alt="photo gym 1">
                    <?php endif; ?>
                    <?php if($gym->photo2): ?>
                    <img src="data:image/jpeg;base64,<?php echo e(base64_encode($gym->photo2)); ?>" alt="photo gym 2">
                    <?php endif; ?>
                    <?php if($gym->photo3): ?>
                    <img src="data:image/jpeg;base64,<?php echo e(base64_encode($gym->photo3)); ?>" alt="photo gym 3">
                    <?php endif; ?>
                </div>

                <h3><?php echo e($gym->informations ?? 'Gym sans nom'); ?></h3>

                <div>
                    <?php if($gym->specialite): ?>
                    <span class="specialite-badge"><?php echo e($gym->specialite); ?></span>
                    <?php endif; ?>
                    <?php if($gym->nationalite): ?>
                    <span class="nationalite-badge"><?php echo e($gym->nationalite); ?></span>
                    <?php endif; ?>
                </div>

                <p class="desc"><?php echo e(Str::limit($gym->description ?? 'Aucune description disponible.', 150)); ?></p>

                <p style="font-size:13px;color:var(--muted);margin-top:auto;">
                    📍 <?php echo e($gym->adresse ?? 'Adresse non spécifiée'); ?><br>
                    ☎️ <?php echo e($gym->tel ?? '-'); ?><br>
                    <?php if($gym->email): ?>
                    📧 <?php echo e($gym->email); ?><br>
                    <?php endif; ?>
                    <?php if($gym->website): ?>
                    🌐 <?php echo e($gym->website); ?>

                    <?php endif; ?>
                </p>
            </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <?php if($gyms->count() > 0): ?>
        <!-- Compteur de résultats -->
        <div style="text-align: center; margin-bottom: 20px;">
                <span class="results-count">
                    <?php echo e($gyms->total()); ?> gym(s) found
                    <?php if($hasFilter): ?>
                        <?php if(request()->has('search') && !empty(request('search'))): ?>
                            for "<?php echo e(request('search')); ?>"
                        <?php endif; ?>
                        <?php if(request()->has('specialite') && !empty(request('specialite'))): ?>
                            in specialty "<?php echo e(request('specialite')); ?>"
                        <?php endif; ?>
                        <?php if(request()->has('nationalite') && !empty(request('nationalite'))): ?>
                            from "<?php echo e(request('nationalite')); ?>"
                        <?php endif; ?>
                    <?php else: ?>
                        (All gyms)
                    <?php endif; ?>
                </span>
        </div>

        <!-- Message quand on affiche tous les gyms -->
        <?php if(!$hasFilter): ?>
        <div class="all-gyms-message">
            Showing all available gyms. Use filters above to narrow your search.
        </div>
        <?php endif; ?>



        <!-- Pagination -->
        <?php if($gyms->hasPages()): ?>
        <div class="pagination">
            <?php echo e($gyms->links()); ?>

        </div>
        <?php endif; ?>

        <?php else: ?>
        <!-- Aucun résultat trouvé -->
        <div class="no-results">
            <p style="font-size: 18px; margin-bottom: 10px;">No gyms found matching your criteria.</p>
            <p style="margin-bottom: 20px;">
                <?php if(request()->has('search') && !empty(request('search'))): ?>
                Search: "<?php echo e(request('search')); ?>"
                <?php endif; ?>
                <?php if(request()->has('specialite') && !empty(request('specialite'))): ?>
                Specialty: "<?php echo e(request('specialite')); ?>"
                <?php endif; ?>
                <?php if(request()->has('nationalite') && !empty(request('nationalite'))): ?>
                Nationality: "<?php echo e(request('nationalite')); ?>"
                <?php endif; ?>
            </p>
            <p style="margin-bottom: 20px;">Try modifying your search or filters.</p>
            <a href="<?php echo e(route('gyms.liste')); ?>" class="filter-button" style="text-decoration: none; display: inline-block;">
                Show All Gyms
            </a>
        </div>
        <?php endif; ?>
    </main>

</div>

<script>
    function sendHeight() {
        const height = document.documentElement.scrollHeight;
        window.parent.postMessage({ type: 'resize', height: height }, '*');
    }

    // Envoyer la hauteur au chargement et à chaque redimensionnement
    window.addEventListener('load', sendHeight);
    window.addEventListener('resize', sendHeight);

    // Observer les changements de contenu
    const observer = new MutationObserver(sendHeight);
    observer.observe(document.body, { childList: true, subtree: true });

    // Auto-submit sur changement de sélection
    document.getElementById('specialite')?.addEventListener('change', function() {
        this.form.submit();
    });

    document.getElementById('nationalite')?.addEventListener('change', function() {
        this.form.submit();
    });

    // Soumettre le formulaire en appuyant sur Enter dans la barre de recherche
    document.getElementById('search')?.addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            this.form.submit();
        }
    });

    // Focus sur le champ de recherche au chargement
    document.addEventListener('DOMContentLoaded', function() {
        const searchField = document.getElementById('search');
        if (searchField) {
            searchField.focus();
        }
    });
</script>
</body>
</html><?php /**PATH /home/kyukusu/www/app/project/resources/views/gyms/liste.blade.php ENDPATH**/ ?>