<?php $__env->startSection('title', $title ?? 'Members List'); ?>

<?php $__env->startSection('content'); ?>
    <h2><?php echo e($title ?? 'Members List'); ?> Members</h2>

    <?php if($members->count() > 0): ?>
        <table>
            <thead>
            <tr>
                <th>#</th>
                <th>Nom</th>
                <th>Prénom</th>
                <th>Email</th>
                <th>Matricule</th>
                <th>Téléphone</th>
                <th>Adresse</th>
                <th>Nationalité</th>
                <th>Role</th>
                <th>Certificat</th>
                <th>Validé</th>
                <th>Actions</th>

            </tr>
            </thead>
            <tbody>
            <?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td>
                        <img src="data:image/jpeg;base64,<?php echo e(base64_encode($member->photo1)); ?>" style="width: 50px">
                    </td>
                    <td><?php echo e($member->nom); ?></td>
                    <td><?php echo e($member->prenom); ?></td>
                    <td><?php echo e($member->email); ?></td>
                    <td><?php echo e($member->matricule); ?></td>
                    <td><?php echo e($member->tel); ?></td>
                    <td><?php echo e($member->adresse); ?></td>
                    <td><?php echo e($member->nationalite); ?></td>
                    <td><?php echo e($member->role); ?></td>
                    <td>
                        <?php if($member->certificat): ?>
                            <a href="<?php echo e(asset('project/storage/app/public/' . $member->certificat)); ?>" target="_blank">
                                Ouvrir le certificat
                            </a>
                        <?php else: ?>
                            Aucun certificat
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if($member->validate === 1): ?>
                            <span class="status-validated">Validé</span>
                        <?php elseif($member->validate === 0): ?>
                            <span class="status-refused">Refusé</span>
                        <?php else: ?>
                            <span class="status-pending">En attente</span>
                        <?php endif; ?>
                    </td>

                    <td class="action-buttons">
                        <?php if(!$member->validate): ?>
                            <a href="<?php echo e(route('admin.members.demande.validate', $member->id)); ?>" class="btn-validate" title="Valider l'inscription">
                                Validate
                            </a>
                        <?php else: ?>
                            <a href="<?php echo e(route('admin.members.demande.validate', $member->id)); ?>" class="btn-refuse" title="Refuser l'inscription">
                                Refuse
                            </a>
                        <?php endif; ?>

                        <a href="<?php echo e(route('admin.members.demande.edit', $member->id)); ?>" class="btn-validate" title="Modifier">
                            Edit
                        </a>

                        <a href="<?php echo e(route('admin.members.demande.destroy', $member->id)); ?>" class="btn-refuse" title="Supprimer l'inscription">
                            Supprimer
                        </a>
                    </td>

                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    <?php else: ?>
        <p>Aucun membre trouvé pour ce certificat.</p>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/kyukusu/www/app/project/resources/views/admin/register_member/liste_demande.blade.php ENDPATH**/ ?>