<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\RegisterMemberController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
Route::get('/clear', function () {
    Cache::flush();
    Artisan::call('view:clear');
    Artisan::call('route:cache');

});
Route::get('/', function () {
    return view('pages.connexion');
});
Route::get('/register_member/inscription/black_belt_degree', function () {
    return view('pages.register_member.inscription.black_belt_degree');
});
Route::get('/register_member/inscription/coach_body_guard', function () {
    return view('pages.register_member.inscription.coach_body_guard');
});
Route::get('/register_member/inscription/coach_self_defense', function () {
    return view('pages.register_member.inscription.coach_self_defense');
});
Route::get('/gyms', [\App\Http\Controllers\GymController::class, 'liste'])->name('gyms.liste');
Route::get('/register_member', [\App\Http\Controllers\RegisterMemberController::class, 'liste'])->name('register_member.liste');
Route::get('/register_member/profile/{id}/{nom}', [\App\Http\Controllers\RegisterMemberController::class, 'show'])->name('register_member.profile.show');

Route::post('/register_member/inscription', [RegisterMemberController::class, 'store'])->name('register_member.store');
Auth::routes();
Route::post('/login', [\App\Http\Controllers\Auth\LoginController::class, 'login'])->name('login');
Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

//Route::get('/admin-register_member-liste-demande', function () {
//    return view('admin.register_member.liste_demande');
//})->name('admin.register_member.liste.demande')->middleware('is_admin');
Route::get('admin/members/demande/blackbelt', [\App\Http\Controllers\admin\RegisterMemberController::class, 'blackBelt'])->name('admin.members.demande.blackbelt')->middleware('is_admin');
Route::get('admin/members/demande/selfdefense', [\App\Http\Controllers\admin\RegisterMemberController::class, 'selfDefense'])->name('admin.members.demande.selfdefense')->middleware('is_admin');
Route::get('admin/members/demande/bodyguard', [\App\Http\Controllers\admin\RegisterMemberController::class, 'bodyGuard'])->name('admin.members.demande.bodyguard')->middleware('is_admin');
Route::get('admin/members/demande/validate/{id}', [\App\Http\Controllers\admin\RegisterMemberController::class, 'updateValidate'])->name('admin.members.demande.validate')->middleware('is_admin');
Route::get('admin/members/demande/delete/{id}', [\App\Http\Controllers\admin\RegisterMemberController::class, 'destroy'])->name('admin.members.demande.destroy')->middleware('is_admin');
Route::get('admin/members/demande/edit/{id}', [\App\Http\Controllers\admin\RegisterMemberController::class, 'edit'])
    ->name('admin.members.demande.edit')
    ->middleware('is_admin');

Route::prefix('admin')->group(function () {
    Route::get('/gyms', [\App\Http\Controllers\admin\RegisterGymController::class, 'index'])->name('admin.gyms.index');
    Route::get('/gyms/create', [\App\Http\Controllers\admin\RegisterGymController::class, 'create'])->name('admin.gyms.create');
    Route::post('/gyms/store', [\App\Http\Controllers\admin\RegisterGymController::class, 'store'])->name('admin.gyms.store');
    Route::get('/gyms/{id}/edit', [\App\Http\Controllers\admin\RegisterGymController::class, 'edit'])->name('admin.gyms.edit');
    Route::put('/gyms/{id}', [\App\Http\Controllers\admin\RegisterGymController::class, 'update'])->name('admin.gyms.update');
    Route::get('/gyms/{id}/validate', [\App\Http\Controllers\admin\RegisterGymController::class, 'updateValidate'])->name('admin.gyms.validate');
    Route::delete('/gyms/{id}', [\App\Http\Controllers\admin\RegisterGymController::class, 'destroy'])->name('admin.gyms.destroy');
});

Route::post('admin/members/demande/update/{id}', [\App\Http\Controllers\admin\RegisterMemberController::class, 'update'])
    ->name('admin.members.demande.update')
    ->middleware('is_admin');

Route::get('/gyms/create', [\App\Http\Controllers\GymController::class, 'create'])->name('gyms.create');
Route::post('/gyms/store', [\App\Http\Controllers\GymController::class, 'store'])->name('gyms.store');

Route::get('admin/gyms', [\App\Http\Controllers\admin\RegisterGymController::class, 'index'])->name('admin.gyms.index')->middleware('is_admin');
Route::get('admin/gyms/validate/{id}', [\App\Http\Controllers\admin\RegisterGymController::class, 'updateValidate'])->name('admin.gyms.validate')->middleware('is_admin');
Route::get('admin/gyms/delete/{id}', [\App\Http\Controllers\admin\RegisterGymController::class, 'destroy'])->name('admin.gyms.destroy')->middleware('is_admin');
