<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Formulaire d’inscription</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;500;600&display=swap');

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Poppins', sans-serif;
        }

        body {
            background-color: #FBFBFB;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding: 20px;
        }

        .form-container {
            background: white;
            padding: 40px 30px;
            border-radius: 20px;
            box-shadow: 0 6px 20px rgba(0,0,0,0.1);
            width: 100%;
            max-width: 600px;
        }

        .form-container h2 {
            text-align: center;
            color: #5C3F17;
            margin-bottom: 25px;
        }

        form {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
        }

        .form-group {
            display: flex;
            flex-direction: column;
        }

        .form-group.full-width {
            grid-column: span 2;
        }

        label {
            margin-bottom: 6px;
            font-weight: 500;
            color: #5C3F17;
        }

        input, select {
            padding: 12px;
            border: 1px solid #8C8570;
            border-radius: 8px;
            background-color: #FBFBFB;
            font-size: 14px;
            outline: none;
            transition: border 0.3s;
        }

        input:focus, select:focus {
            border-color: #D30402;
        }

        .file-upload {
            position: relative;
            border: 2px dashed #8C8570;
            padding: 20px;
            text-align: center;
            cursor: pointer;
            border-radius: 10px;
            background-color: #FBFBFB;
            transition: border 0.3s, background 0.3s;
        }

        .file-upload:hover {
            border-color: #D30402;
            background-color: #fff5f5;
        }

        .file-upload input {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            opacity: 0;
            cursor: pointer;
        }

        button {
            grid-column: span 2;
            padding: 14px;
            border: none;
            border-radius: 8px;
            background-color: #D30402;
            color: white;
            font-weight: 600;
            font-size: 16px;
            cursor: pointer;
            transition: background 0.3s;
        }

        button:hover {
            background-color: #b90302;
        }

        @media (max-width: 600px) {
            form {
                grid-template-columns: 1fr;
            }
            button {
                grid-column: span 1;
            }
        }
    </style>
</head>
<body>
<div class="form-container">
    <h2>Inscription</h2>
    <form>
        <div class="form-group">
            <label for="nom">Nom</label>
            <input type="text" id="nom" name="nom" placeholder="Entrez votre nom" required />
        </div>

        <div class="form-group">
            <label for="prenom">Prénom</label>
            <input type="text" id="prenom" name="prenom" placeholder="Entrez votre prénom" required />
        </div>

        <div class="form-group full-width">
            <label for="adresse">Adresse</label>
            <input type="text" id="adresse" name="adresse" placeholder="Entrez votre adresse" required />
        </div>

        <div class="form-group">
            <label for="tel">Téléphone</label>
            <input type="tel" id="tel" name="tel" placeholder="+216 ..." required />
        </div>

        <div class="form-group">
            <label for="email">E-mail</label>
            <input type="email" id="email" name="email" placeholder="exemple@mail.com" required />
        </div>

        <div class="form-group">
            <label for="nationalite">Nationalité</label>
            <input type="text" id="nationalite" name="nationalite" placeholder="Ex: Tunisienne" required />
        </div>

        <div class="form-group">
            <label for="role">Rôle</label>
            <select id="role" name="role" required>
                <option value="">-- Sélectionnez un rôle --</option>
                <option>Black belt degree</option>
                <option>Coach self defense</option>
                <option>Coach body guard</option>
            </select>
        </div>

        <div class="form-group full-width">
            <label>Certificat</label>
            <div class="file-upload">
                <span>📁 Cliquez ou glissez un fichier ici</span>
                <input type="file" name="certificat" accept=".pdf,.jpg,.png" required />
            </div>
        </div>

        <button type="submit">S’inscrire</button>
    </form>
</div>
</body>
</html>
